/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.generator;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import gigaherz.enderRift.generator.GeneratorContainer;
import java.util.ArrayList;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class GeneratorScreen
extends ContainerScreen<GeneratorContainer> {
    private static final int bar1x = 1;
    private static final int bar2x = 17;
    private static final int barWidth = 14;
    private static final int barHeight = 42;
    protected ResourceLocation guiTextureLocation;
    protected ResourceLocation energyTextureLocation;

    public GeneratorScreen(GeneratorContainer container, PlayerInventory playerInventory, ITextComponent title) {
        super((Container)container, playerInventory, title);
        this.field_147000_g = 165;
        this.guiTextureLocation = new ResourceLocation("enderrift", "textures/gui/generator.png");
        this.energyTextureLocation = new ResourceLocation("enderrift", "textures/gui/energy.png");
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground();
        super.render(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146979_b(int i, int j) {
        String label;
        String name = this.title.func_150254_d();
        this.font.func_211126_b(name, (float)((this.field_146999_f - this.font.func_78256_a(name)) / 2), 6.0f, 0x404040);
        this.font.func_211126_b(this.field_213127_e.func_200200_C_().func_150254_d(), 8.0f, (float)(this.field_147000_g - 96 + 2), 0x404040);
        if (((GeneratorContainer)this.field_147002_h).tile.getGenerationPower() > 0) {
            label = I18n.func_135052_a((String)"text.enderrift.generator.status.generating.label", (Object[])new Object[0]);
            this.font.func_211126_b(label, 8.0f, 22.0f, 0x404040);
            this.font.func_211126_b(String.format("%d RF/t", ((GeneratorContainer)this.field_147002_h).tile.getGenerationPower()), 12.0f, 32.0f, 0x404040);
        } else if (((GeneratorContainer)this.field_147002_h).tile.isBurning()) {
            label = I18n.func_135052_a((String)"text.enderrift.generator.status.heating", (Object[])new Object[0]);
            this.font.func_211126_b(label, 8.0f, 22.0f, 0x404040);
        } else {
            label = I18n.func_135052_a((String)"text.enderrift.generator.status.idle", (Object[])new Object[0]);
            this.font.func_211126_b(label, 8.0f, 22.0f, 0x404040);
        }
        label = I18n.func_135052_a((String)"text.enderrift.generator.heat.label", (Object[])new Object[0]);
        this.font.func_211126_b(label, 8.0f, 46.0f, 0x404040);
        this.font.func_211126_b(String.format("%d C", ((GeneratorContainer)this.field_147002_h).tile.getHeatValue()), 12.0f, 56.0f, this.getHeatColor());
        String str = String.format("%d RF", ((GeneratorContainer)this.field_147002_h).tile.getContainedEnergy());
        this.font.func_211126_b(str, (float)(this.field_146999_f - 8 - this.font.func_78256_a(str)), 64.0f, 0x404040);
        this.drawBarTooltip(i, j, this.field_146999_f - 14 - 8, 20);
    }

    private void drawBarTooltip(int mx, int my, int ox, int oy) {
        int rx = mx - ox - this.field_147003_i;
        int ry = my - oy - this.field_147009_r;
        if (rx < 0 || ry < 0 || rx > 14 || ry > 42) {
            return;
        }
        ArrayList tooltip = Lists.newArrayList();
        tooltip.add(I18n.func_135052_a((String)"text.enderrift.generator.energy.label", (Object[])new Object[0]));
        tooltip.add(String.format("%d / %d RF", ((GeneratorContainer)this.field_147002_h).tile.getContainedEnergy(), 100000));
        this.renderTooltip(tooltip, mx - this.field_147003_i, my - this.field_147009_r);
    }

    protected void func_146976_a(float f, int i, int j) {
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.minecraft.func_110434_K().func_110577_a(this.guiTextureLocation);
        this.blit(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (((GeneratorContainer)this.field_147002_h).tile.isBurning()) {
            int k = this.getBurnLeftScaled(13);
            this.blit(this.field_147003_i + 80, this.field_147009_r + 36 + 12 - k, 176, 12 - k, 14, k + 1);
        }
        this.drawEnergyBar(this.field_147003_i + this.field_146999_f - 14 - 8, this.field_147009_r + 20, ((GeneratorContainer)this.field_147002_h).tile.getContainedEnergy(), 100000);
    }

    private void drawEnergyBar(int x, int y, int powerLevel, int powerLimit) {
        int bar2height = 1 + powerLevel * 40 / powerLimit;
        int bar1height = 42 - bar2height;
        this.minecraft.func_110434_K().func_110577_a(this.energyTextureLocation);
        GeneratorScreen.blit((int)x, (int)y, (float)1.0f, (float)0.0f, (int)14, (int)bar1height, (int)32, (int)64);
        GeneratorScreen.blit((int)x, (int)(y + bar1height), (float)17.0f, (float)bar1height, (int)14, (int)bar2height, (int)32, (int)64);
    }

    private int getHeatColor() {
        int heatLevel = ((GeneratorContainer)this.field_147002_h).tile.getHeatValue();
        if (heatLevel <= 100) {
            return 0x404040;
        }
        float p = (float)(heatLevel - 100) / 900.0f;
        int r = 160;
        int g = Math.round(64.0f + 96.0f * (1.0f - p));
        int b = 64;
        return r << 16 | g << 8 | b;
    }

    private int getBurnLeftScaled(int pixels) {
        int i = ((GeneratorContainer)this.field_147002_h).tile.getCurrentItemBurnTime();
        if (i == 0) {
            i = 200;
        }
        return ((GeneratorContainer)this.field_147002_h).tile.getBurnTimeRemaining() * pixels / i;
    }
}

