/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.plugins;

import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.automation.AggregatorTileEntity;
import gigaherz.enderRift.automation.driver.DriverBlock;
import gigaherz.enderRift.automation.driver.DriverTileEntity;
import gigaherz.enderRift.generator.GeneratorBlock;
import gigaherz.enderRift.generator.GeneratorTileEntity;
import gigaherz.enderRift.rift.RiftBlock;
import gigaherz.enderRift.rift.RiftTileEntity;
import gigaherz.enderRift.rift.StructureBlock;
import gigaherz.enderRift.rift.StructureTileEntity;
import gigaherz.enderRift.shadow.graphlib2.Graph;
import gigaherz.enderRift.shadow.graphlib2.GraphObject;
import java.util.List;
import java.util.Optional;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IDataAccessor;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.IWailaPlugin;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.WailaPlugin;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.energy.IEnergyStorage;

@WailaPlugin
public class WailaProviders
implements IWailaPlugin {
    private static final ResourceLocation CONFIG_GENERATOR = EnderRiftMod.location("generator");
    private static final ResourceLocation CONFIG_RIFT = EnderRiftMod.location("rift");
    private static final ResourceLocation CONFIG_DRIVER = EnderRiftMod.location("driver");
    private static final ResourceLocation CONFIG_RF = EnderRiftMod.location("rf");

    public void register(IRegistrar registrar) {
        registrar.addConfig(CONFIG_GENERATOR, true);
        registrar.addConfig(CONFIG_RIFT, true);
        registrar.addConfig(CONFIG_DRIVER, true);
        registrar.addConfig(CONFIG_RF, true);
        Object instance = new RiftTooltipProvider();
        registrar.registerStackProvider((IComponentProvider)instance, StructureTileEntity.class);
        registrar.registerBlockDataProvider((IServerDataProvider)instance, StructureTileEntity.class);
        registrar.registerComponentProvider((IComponentProvider)instance, TooltipPosition.BODY, StructureBlock.class);
        registrar.registerBlockDataProvider((IServerDataProvider)instance, RiftTileEntity.class);
        registrar.registerComponentProvider((IComponentProvider)instance, TooltipPosition.BODY, RiftBlock.class);
        instance = new StructureTooltipProvider();
        registrar.registerStackProvider((IComponentProvider)instance, StructureBlock.class);
        instance = new NetworkTooltipProvider();
        registrar.registerComponentProvider((IComponentProvider)instance, TooltipPosition.BODY, AggregatorTileEntity.class);
        instance = new DriverTooltipProvider();
        registrar.registerBlockDataProvider((IServerDataProvider)instance, DriverTileEntity.class);
        registrar.registerComponentProvider((IComponentProvider)instance, TooltipPosition.BODY, DriverBlock.class);
        instance = new GeneratorTooltipProvider();
        registrar.registerBlockDataProvider((IServerDataProvider)instance, GeneratorTileEntity.class);
        registrar.registerComponentProvider((IComponentProvider)instance, TooltipPosition.BODY, GeneratorBlock.class);
    }

    public static class RiftTooltipProvider
    implements IComponentProvider,
    IServerDataProvider<TileEntity> {
        public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
            return new ItemStack((IItemProvider)EnderRiftMod.EnderRiftBlocks.RIFT);
        }

        public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
            if (config.get(CONFIG_RIFT) && (accessor.getBlock() != EnderRiftMod.EnderRiftBlocks.STRUCTURE || accessor.getBlockState().func_177229_b(StructureBlock.TYPE1) == StructureBlock.Type1.CORNER)) {
                CompoundNBT tag = accessor.getServerData();
                if (tag != null && tag.func_74764_b("isFormed")) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("text.enderrift.rift.is_formed", new Object[]{tag.func_74767_n("isFormed")}));
                    tooltip.add((ITextComponent)new TranslationTextComponent("text.enderrift.rift.is_powered", new Object[]{tag.func_74767_n("isPowered")}));
                    if (tag.func_74767_n("isFormed")) {
                        tooltip.add((ITextComponent)new TranslationTextComponent("text.enderrift.rift.rift_id", new Object[]{tag.func_74762_e("riftId")}));
                        if (config.get(CONFIG_RF)) {
                            tooltip.add((ITextComponent)new TranslationTextComponent("text.enderrift.rift.rf", new Object[]{tag.func_74762_e("energy"), 1000000}));
                        }
                    }
                    tooltip.add((ITextComponent)new TranslationTextComponent("text.enderrift.rift.used_slots", new Object[]{tag.func_74762_e("usedSlots")}));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("text.enderrift.rift.is_formed", new Object[]{false}));
                }
            }
        }

        public void appendServerData(CompoundNBT tag, ServerPlayerEntity serverPlayerEntity, World world, TileEntity tileEntity) {
            Optional<RiftTileEntity> riftMaybe = tileEntity instanceof StructureTileEntity ? ((StructureTileEntity)tileEntity).getParent() : Optional.of((RiftTileEntity)tileEntity);
            riftMaybe.ifPresent(rift -> {
                tag.func_74768_a("usedSlots", rift.countInventoryStacks());
                tag.func_74757_a("isFormed", ((Boolean)rift.func_195044_w().func_177229_b((IProperty)RiftBlock.ASSEMBLED)).booleanValue());
                tag.func_74757_a("isPowered", rift.isPowered());
                tag.func_74768_a("riftId", rift.getRiftId());
                tag.func_74768_a("energy", rift.getEnergyBuffer().map(IEnergyStorage::getEnergyStored).orElse(0).intValue());
            });
        }
    }

    public static class StructureTooltipProvider
    implements IComponentProvider {
        public ItemStack getStack(IDataAccessor accessor, IPluginConfig config) {
            return new ItemStack((IItemProvider)EnderRiftMod.EnderRiftBlocks.STRUCTURE);
        }
    }

    public static class NetworkTooltipProvider
    implements IComponentProvider {
        public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
            Graph network = ((GraphObject)accessor.getTileEntity()).getGraph();
            if (network != null) {
                tooltip.add((ITextComponent)new TranslationTextComponent("text.enderrift.network.size", new Object[]{network.getObjects().size()}));
            }
        }
    }

    public static class DriverTooltipProvider
    implements IComponentProvider,
    IServerDataProvider<TileEntity> {
        public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
            if (config.get(CONFIG_DRIVER)) {
                CompoundNBT tag = accessor.getServerData();
                if (config.get(CONFIG_RF)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("text.enderrift.generator.energy", new Object[]{tag.func_74762_e("energy"), 100000}));
                }
            }
        }

        public void appendServerData(CompoundNBT tag, ServerPlayerEntity serverPlayerEntity, World world, TileEntity tileEntity) {
            DriverTileEntity rift = (DriverTileEntity)tileEntity;
            tag.func_74768_a("energy", rift.getInternalBuffer().map(IEnergyStorage::getEnergyStored).orElse(0).intValue());
        }
    }

    public static class GeneratorTooltipProvider
    implements IComponentProvider,
    IServerDataProvider<TileEntity> {
        public void appendBody(List<ITextComponent> tooltip, IDataAccessor accessor, IPluginConfig config) {
            if (config.get(CONFIG_GENERATOR)) {
                CompoundNBT tag = accessor.getServerData();
                if (tag.func_74762_e("powerGen") > 0) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("text.enderrift.generator.status.generating", new Object[]{tag.func_74762_e("powerGen")}));
                } else if (tag.func_74767_n("isBurning")) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("text.enderrift.generator.status.heating", new Object[0]));
                } else {
                    tooltip.add((ITextComponent)new TranslationTextComponent("text.enderrift.generator.status.idle", new Object[0]));
                }
                tooltip.add((ITextComponent)new TranslationTextComponent("text.enderrift.generator.heat", new Object[]{tag.func_74762_e("heat")}));
                if (config.get(CONFIG_RF)) {
                    tooltip.add((ITextComponent)new TranslationTextComponent("text.enderrift.generator.energy", new Object[]{tag.func_74762_e("energy"), 100000}));
                }
            }
        }

        public void appendServerData(CompoundNBT tag, ServerPlayerEntity serverPlayerEntity, World world, TileEntity tileEntity) {
            GeneratorTileEntity rift = (GeneratorTileEntity)tileEntity;
            tag.func_74757_a("isBurning", rift.isBurning());
            tag.func_74768_a("powerGen", rift.getGenerationPower());
            tag.func_74768_a("energy", rift.getContainedEnergy());
            tag.func_74768_a("heat", rift.getHeatValue());
        }
    }
}

