/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.rift;

import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.rift.RiftBlock;
import gigaherz.enderRift.rift.RiftTileEntity;
import gigaherz.enderRift.rift.StructureBlock;
import gigaherz.enderRift.rift.storage.RiftStorage;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class RiftStructure {
    static Block[] StructurePattern;
    static BlockState[] StructureStates;

    public static void init() {
        StructurePattern = new Block[]{Blocks.field_150339_S, Blocks.field_150451_bX, Blocks.field_150339_S, Blocks.field_150451_bX, null, Blocks.field_150451_bX, Blocks.field_150339_S, Blocks.field_150451_bX, Blocks.field_150339_S, Blocks.field_150451_bX, null, Blocks.field_150451_bX, null, EnderRiftMod.EnderRiftBlocks.RIFT, null, Blocks.field_150451_bX, null, Blocks.field_150451_bX, Blocks.field_150339_S, Blocks.field_150451_bX, Blocks.field_150339_S, Blocks.field_150451_bX, null, Blocks.field_150451_bX, Blocks.field_150339_S, Blocks.field_150451_bX, Blocks.field_150339_S};
        StructureStates = new BlockState[]{EnderRiftMod.EnderRiftBlocks.STRUCTURE.cornerState(StructureBlock.Corner.NW, true), EnderRiftMod.EnderRiftBlocks.STRUCTURE.edgeState(StructureBlock.Type2.SIDE_EW, true), EnderRiftMod.EnderRiftBlocks.STRUCTURE.cornerState(StructureBlock.Corner.NE, true), EnderRiftMod.EnderRiftBlocks.STRUCTURE.edgeState(StructureBlock.Type2.SIDE_NS, true), null, EnderRiftMod.EnderRiftBlocks.STRUCTURE.edgeState(StructureBlock.Type2.SIDE_NS, true), EnderRiftMod.EnderRiftBlocks.STRUCTURE.cornerState(StructureBlock.Corner.SW, true), EnderRiftMod.EnderRiftBlocks.STRUCTURE.edgeState(StructureBlock.Type2.SIDE_EW, true), EnderRiftMod.EnderRiftBlocks.STRUCTURE.cornerState(StructureBlock.Corner.SE, true), EnderRiftMod.EnderRiftBlocks.STRUCTURE.edgeState(StructureBlock.Type2.VERTICAL, false), null, EnderRiftMod.EnderRiftBlocks.STRUCTURE.edgeState(StructureBlock.Type2.VERTICAL, false), null, null, null, EnderRiftMod.EnderRiftBlocks.STRUCTURE.edgeState(StructureBlock.Type2.VERTICAL, false), null, EnderRiftMod.EnderRiftBlocks.STRUCTURE.edgeState(StructureBlock.Type2.VERTICAL, false), EnderRiftMod.EnderRiftBlocks.STRUCTURE.cornerState(StructureBlock.Corner.NW, false), EnderRiftMod.EnderRiftBlocks.STRUCTURE.edgeState(StructureBlock.Type2.SIDE_EW, false), EnderRiftMod.EnderRiftBlocks.STRUCTURE.cornerState(StructureBlock.Corner.NE, false), EnderRiftMod.EnderRiftBlocks.STRUCTURE.edgeState(StructureBlock.Type2.SIDE_NS, false), null, EnderRiftMod.EnderRiftBlocks.STRUCTURE.edgeState(StructureBlock.Type2.SIDE_NS, false), EnderRiftMod.EnderRiftBlocks.STRUCTURE.cornerState(StructureBlock.Corner.SW, false), EnderRiftMod.EnderRiftBlocks.STRUCTURE.edgeState(StructureBlock.Type2.SIDE_EW, false), EnderRiftMod.EnderRiftBlocks.STRUCTURE.cornerState(StructureBlock.Corner.SE, false)};
    }

    public static boolean duplicateOrb(World world, BlockPos pos, PlayerEntity player) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof RiftTileEntity)) {
            return false;
        }
        ItemStack stack = ((RiftTileEntity)te).getRiftItem();
        InventoryHelper.func_180173_a((World)world, (double)player.field_70165_t, (double)(player.field_70163_u + 0.5), (double)player.field_70161_v, (ItemStack)stack);
        return true;
    }

    public static void breakStructure(World world, BlockPos pos) {
        for (int yy = -1; yy <= 1; ++yy) {
            for (int xx = -1; xx <= 1; ++xx) {
                for (int zz = -1; zz <= 1; ++zz) {
                    BlockPos pos2 = pos.func_177982_a(xx, yy, zz);
                    if (world.func_180495_p(pos2).func_177230_c() != EnderRiftMod.EnderRiftBlocks.RIFT) continue;
                    RiftStructure.dismantle(world, pos2);
                    return;
                }
            }
        }
    }

    public static boolean assemble(World world, BlockPos pos, ItemStack itemStack) {
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != EnderRiftMod.EnderRiftBlocks.RIFT) {
            return false;
        }
        if (((Boolean)state.func_177229_b((IProperty)RiftBlock.ASSEMBLED)).booleanValue()) {
            return false;
        }
        for (int yy = 0; yy <= 2; ++yy) {
            for (int zz = 0; zz <= 2; ++zz) {
                for (int xx = 0; xx <= 2; ++xx) {
                    BlockState st;
                    BlockPos bp = pos.func_177982_a(xx - 1, yy - 1, zz - 1);
                    Block b = StructurePattern[yy * 9 + zz * 3 + xx];
                    Block w = world.func_180495_p(bp).func_177230_c();
                    if (b == null || !(b == Blocks.field_150350_a ? !w.isAir(st = world.func_180495_p(bp), (IBlockReader)world, bp) : b != EnderRiftMod.EnderRiftBlocks.RIFT && b != w)) continue;
                    return false;
                }
            }
        }
        RiftStructure.buildStructure(world, pos, itemStack, state);
        return true;
    }

    private static void buildStructure(World world, BlockPos pos, ItemStack itemStack, BlockState state) {
        for (int yy = 0; yy <= 2; ++yy) {
            for (int zz = 0; zz <= 2; ++zz) {
                for (int xx = 0; xx <= 2; ++xx) {
                    BlockState bs = StructureStates[yy * 9 + zz * 3 + xx];
                    if (bs == null) continue;
                    BlockPos bp = pos.func_177982_a(xx - 1, yy - 1, zz - 1);
                    world.func_175656_a(bp, bs);
                }
            }
        }
        world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)RiftBlock.ASSEMBLED, (Comparable)Boolean.valueOf(true)));
        RiftTileEntity rift = (RiftTileEntity)world.func_175625_s(pos);
        CompoundNBT tagCompound = itemStack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("RiftId")) {
            rift.assemble(tagCompound.func_74762_e("RiftId"));
        } else {
            rift.assemble(RiftStorage.get(world).getNextRiftId());
        }
    }

    public static void dismantle(World world, BlockPos pos) {
        for (int yy = 0; yy <= 2; ++yy) {
            for (int zz = 0; zz <= 2; ++zz) {
                for (int xx = 0; xx <= 2; ++xx) {
                    BlockPos bp;
                    Block b = StructurePattern[yy * 9 + zz * 3 + xx];
                    if (b == null || b == Blocks.field_150350_a || b == EnderRiftMod.EnderRiftBlocks.RIFT || world.func_180495_p(bp = pos.func_177982_a(xx - 1, yy - 1, zz - 1)).func_177230_c() != EnderRiftMod.EnderRiftBlocks.STRUCTURE) continue;
                    world.func_175656_a(bp, b.func_176223_P());
                }
            }
        }
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == EnderRiftMod.EnderRiftBlocks.RIFT && ((Boolean)state.func_177229_b((IProperty)RiftBlock.ASSEMBLED)).booleanValue()) {
            world.func_175656_a(pos, (BlockState)state.func_206870_a((IProperty)RiftBlock.ASSEMBLED, (Comparable)Boolean.valueOf(false)));
            RiftTileEntity rift = (RiftTileEntity)world.func_175625_s(pos);
            ItemStack stack = rift.getRiftItem();
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (ItemStack)stack);
            rift.unassemble();
        }
    }

    public static Block getOriginalBlock(BlockState state) {
        if (state.func_177230_c() == EnderRiftMod.EnderRiftBlocks.STRUCTURE) {
            if (state.func_177229_b(StructureBlock.TYPE1) == StructureBlock.Type1.CORNER) {
                return StructurePattern[0];
            }
            return StructurePattern[1];
        }
        return StructurePattern[13];
    }

    public static Block getOriginalBlock(IBlockReader worldIn, BlockPos pos) {
        for (int yy = 0; yy <= 2; ++yy) {
            for (int zz = 0; zz <= 2; ++zz) {
                for (int xx = 0; xx <= 2; ++xx) {
                    BlockPos pos2 = pos.func_177982_a(1 - xx, 1 - yy, 1 - zz);
                    if (worldIn.func_180495_p(pos2).func_177230_c() != EnderRiftMod.EnderRiftBlocks.RIFT) continue;
                    return StructurePattern[yy * 9 + zz * 3 + xx];
                }
            }
        }
        return null;
    }
}

