/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.rift;

import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.common.EnergyBuffer;
import gigaherz.enderRift.rift.storage.RiftInventory;
import gigaherz.enderRift.rift.storage.RiftStorage;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.registries.ObjectHolder;

public class RiftTileEntity
extends TileEntity
implements ITickableTileEntity {
    @ObjectHolder(value="enderrift:rift")
    public static TileEntityType<RiftTileEntity> TYPE;
    private static final int STARTUP_POWER = 10000;
    public static final int BUFFER_POWER = 1000000;
    private final Random rand = new Random();
    private EnergyBuffer energyBuffer = new EnergyBuffer(1000000);
    private boolean powered;
    private int riftId;
    private RiftInventory inventory;
    private float lastPoweringState;
    private float poweringState;
    private boolean poweringStartParticlesSpawned = false;
    public PoweredInventory poweredInventory = new PoweredInventory();
    public LazyOptional<IItemHandler> poweredInventoryProvider = LazyOptional.of(() -> this.poweredInventory);

    public RiftTileEntity() {
        super(TYPE);
    }

    public Optional<IEnergyStorage> getEnergyBuffer() {
        return Optional.of(this.energyBuffer);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.lastPoweringState = this.poweringState;
            if (this.powered) {
                if (!this.poweringStartParticlesSpawned) {
                    this.poweringStartParticlesSpawned = true;
                    for (int i = 0; i < 32; ++i) {
                        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197614_g, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.rand.nextGaussian(), this.rand.nextGaussian(), this.rand.nextGaussian());
                        this.field_145850_b.func_195594_a((IParticleData)ParticleTypes.field_197599_J, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, this.rand.nextGaussian(), this.rand.nextGaussian(), this.rand.nextGaussian());
                    }
                }
                this.poweringState = this.poweringState < 1.0f ? (this.poweringState += 0.1f) : 1.0f;
            } else {
                this.poweringStartParticlesSpawned = false;
                this.poweringState = this.poweringState > 0.0f ? (this.poweringState -= 0.02f) : 0.0f;
            }
            return;
        }
        int energyUsage = this.getEnergyUsage();
        int energyStored = this.energyBuffer.getEnergyStored();
        if (energyStored > this.energyBuffer.getMaxEnergyStored()) {
            energyStored = this.energyBuffer.getMaxEnergyStored();
            this.energyBuffer.setEnergy(energyStored);
        }
        if (energyStored > energyUsage && !this.field_145850_b.func_175640_z(this.field_174879_c)) {
            if (this.powered) {
                this.energyBuffer.setEnergy(energyStored - energyUsage);
            } else if (energyStored >= 10000) {
                this.powered = true;
                this.energyBuffer.setEnergy(energyStored - 10000);
                BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
            }
        } else {
            this.powered = false;
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 3);
        }
    }

    public void assemble(int id) {
        this.inventory = null;
        this.riftId = id;
        this.func_70296_d();
    }

    public void unassemble() {
        this.inventory = null;
        this.riftId = -1;
        this.func_70296_d();
    }

    @Nullable
    public IItemHandler getInventory() {
        if (this.riftId < 0) {
            return null;
        }
        if (this.inventory == null) {
            this.inventory = RiftStorage.get(this.field_145850_b).getRift(this.riftId);
            this.inventory.addWeakListener(this);
        }
        return this.inventory;
    }

    public int countInventoryStacks() {
        IItemHandler handler = this.getInventory();
        return handler == null ? 0 : handler.getSlots();
    }

    public ItemStack getRiftItem() {
        ItemStack stack = new ItemStack((IItemProvider)EnderRiftMod.EnderRiftItems.RIFT_ORB);
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("RiftId", this.riftId);
        stack.func_77982_d(tag);
        return stack;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        CapabilityEnergy.ENERGY.readNBT((Object)this.energyBuffer, null, compound.func_74781_a("Energy"));
        this.powered = compound.func_74767_n("Powered");
        this.riftId = compound.func_74762_e("RiftId");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        compound.func_218657_a("Energy", CapabilityEnergy.ENERGY.writeNBT((Object)this.energyBuffer, null));
        compound.func_74757_a("Powered", this.powered);
        compound.func_74768_a("RiftId", this.riftId);
        return compound;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tag = super.func_189517_E_();
        tag.func_74757_a("Powered", this.powered);
        return tag;
    }

    public void handleUpdateTag(CompoundNBT tag) {
        this.powered = tag.func_74767_n("Powered");
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.handleUpdateTag(pkt.func_148857_g());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.poweredInventoryProvider.cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStack chooseRandomStack() {
        IItemHandler handler = this.getInventory();
        if (handler == null) {
            return ItemStack.field_190927_a;
        }
        int max = handler.getSlots();
        if (max <= 0) {
            return ItemStack.field_190927_a;
        }
        int slot = this.rand.nextInt(max);
        return this.poweredInventory.getStackInSlot(slot);
    }

    public int getRiftId() {
        return this.riftId;
    }

    public int getEnergyUsage() {
        IItemHandler handler = this.getInventory();
        if (handler == null) {
            return 0;
        }
        return MathHelper.func_76143_f((double)Math.pow(handler.getSlots(), 0.8));
    }

    public boolean isPowered() {
        return this.powered;
    }

    public float getPoweringState() {
        return this.poweringState;
    }

    public float getLastPoweringState() {
        return this.lastPoweringState;
    }

    public class PoweredInventory
    implements IItemHandler {
        public int getSlots() {
            IItemHandler handler = RiftTileEntity.this.getInventory();
            if (handler == null) {
                return 0;
            }
            return handler.getSlots();
        }

        public ItemStack getStackInSlot(int slot) {
            if (!RiftTileEntity.this.powered) {
                return ItemStack.field_190927_a;
            }
            IItemHandler handler = RiftTileEntity.this.getInventory();
            if (handler == null) {
                return ItemStack.field_190927_a;
            }
            return handler.getStackInSlot(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (!RiftTileEntity.this.powered) {
                return stack;
            }
            IItemHandler handler = RiftTileEntity.this.getInventory();
            if (handler == null) {
                return stack;
            }
            return handler.insertItem(slot, stack, simulate);
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (!RiftTileEntity.this.powered) {
                return ItemStack.field_190927_a;
            }
            IItemHandler handler = RiftTileEntity.this.getInventory();
            if (handler == null) {
                return ItemStack.field_190927_a;
            }
            return handler.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }
    }
}

