/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.rift;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.rift.RiftBlock;
import gigaherz.enderRift.rift.RiftTileEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.LightUtil;

public class RiftTileEntityRenderer
extends TileEntityRenderer<RiftTileEntity> {
    private final Random random = new Random();
    private static final List<Direction> DIRECTIONS_AND_NULL = Lists.newArrayList((Object[])Direction.values());

    public RiftTileEntityRenderer() {
        DIRECTIONS_AND_NULL.add(null);
    }

    public void render(RiftTileEntity te, double x, double y, double z, float partialTicks, int destroyStage) {
        if (!((Boolean)te.func_195044_w().func_177229_b((IProperty)RiftBlock.ASSEMBLED)).booleanValue()) {
            return;
        }
        float lastPoweringState = te.getLastPoweringState();
        float nextPoweringState = te.getPoweringState();
        float poweringState = this.lerp(lastPoweringState, nextPoweringState, partialTicks);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Vec3d eyePosition = player.func_174824_e(partialTicks);
        BlockPos tePos = te.func_174877_v();
        double ty = eyePosition.func_82617_b() - ((double)tePos.func_177956_o() + 0.5);
        double tx = eyePosition.func_82615_a() - ((double)tePos.func_177958_n() + 0.5);
        double tz = eyePosition.func_82616_c() - ((double)tePos.func_177952_p() + 0.5);
        float yaw = (float)Math.atan2(tz, tx);
        float xz = (float)Math.sqrt(tx * tx + tz * tz);
        float pitch = (float)Math.atan2(ty, xz);
        this.func_147499_a(AtlasTexture.field_110575_b);
        GlStateManager.disableLighting();
        GlStateManager.disableAlphaTest();
        GlStateManager.disableRescaleNormal();
        GlStateManager.enableBlend();
        GlStateManager.blendFunc((int)770, (int)771);
        GlStateManager.pushMatrix();
        GlStateManager.translated((double)x, (double)y, (double)z);
        GlStateManager.translated((double)0.5, (double)0.5, (double)0.5);
        GlStateManager.rotatef((float)((float)Math.toDegrees(-yaw)), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)((float)Math.toDegrees(pitch)), (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.translated((double)-0.5, (double)-0.5, (double)-0.5);
        int step_time = 20;
        int steps = 5;
        int time_loop = step_time * steps;
        long time = te.func_145831_w().func_82737_E();
        int tm = (int)(time % (long)step_time);
        float c0 = 1.0f / (float)steps;
        float c1 = 1.0f / (1.0f - c0);
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        IBakedModel model = Minecraft.func_71410_x().func_209506_al().getModel(EnderRiftMod.location("block/sphere"));
        for (int i = 0; i < steps; ++i) {
            float progress0 = ((float)((tm + i * step_time) % time_loop) + partialTicks) / (float)time_loop;
            float progress1 = (progress0 - c0) * c1;
            float scale = 1.0f + poweringState + (0.6f + poweringState) * progress0;
            GlStateManager.pushMatrix();
            GlStateManager.translated((double)0.5, (double)0.5, (double)0.5);
            GlStateManager.scalef((float)scale, (float)scale, (float)scale);
            GlStateManager.translated((double)-0.5, (double)-0.5, (double)-0.5);
            int a = Math.round(Math.min(255.0f, Math.max(0.0f, (1.0f - progress1) * 255.0f)));
            int rgb = Math.round(Math.min(255.0f, Math.max(0.0f, progress1 * 255.0f)));
            int color = a << 24 | rgb << 16 | rgb << 8 | rgb;
            buffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            for (Direction d : DIRECTIONS_AND_NULL) {
                for (BakedQuad bakedquad : model.getQuads(null, d, this.random, (IModelData)EmptyModelData.INSTANCE)) {
                    LightUtil.renderQuadColor((BufferBuilder)buffer, (BakedQuad)bakedquad, (int)color);
                }
            }
            tessellator.func_78381_a();
            GlStateManager.popMatrix();
        }
        GlStateManager.popMatrix();
    }

    private float lerp(float a, float b, float p) {
        return a + p * (b - a);
    }
}

