/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.rift;

import com.google.common.collect.Lists;
import gigaherz.enderRift.automation.AggregatorBlock;
import gigaherz.enderRift.rift.RiftStructure;
import gigaherz.enderRift.rift.StructureTileEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootContext;

public class StructureBlock
extends AggregatorBlock<StructureTileEntity> {
    public static final EnumProperty<Type1> TYPE1 = EnumProperty.func_177709_a((String)"type1", Type1.class);
    public static final EnumProperty<Type2> TYPE2 = EnumProperty.func_177709_a((String)"type2", Type2.class);
    public static final EnumProperty<Corner> CORNER = EnumProperty.func_177709_a((String)"corner", Corner.class);
    public static final BooleanProperty BASE = BooleanProperty.func_177716_a((String)"base");
    public static final VoxelShape SHAPE_BASE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);
    public static final VoxelShape SHAPE_EW = Block.func_208617_a((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    public static final VoxelShape SHAPE_NS = Block.func_208617_a((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0);
    public static final VoxelShape SHAPE_UD = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    public static final VoxelShape SHAPE_EWB = VoxelShapes.func_197872_a((VoxelShape)SHAPE_EW, (VoxelShape)SHAPE_BASE);
    public static final VoxelShape SHAPE_NSB = VoxelShapes.func_197872_a((VoxelShape)SHAPE_NS, (VoxelShape)SHAPE_BASE);
    public static final VoxelShape SHAPE_CORNER = VoxelShapes.func_216384_a((VoxelShape)Block.func_208617_a((double)0.0, (double)3.0, (double)3.0, (double)16.0, (double)13.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), Block.func_208617_a((double)3.0, (double)3.0, (double)0.0, (double)13.0, (double)13.0, (double)16.0)});
    public static final VoxelShape CORNER_WITH_BASE = VoxelShapes.func_197872_a((VoxelShape)SHAPE_CORNER, (VoxelShape)SHAPE_BASE);

    public StructureBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a(TYPE1, (Comparable)((Object)Type1.NORMAL))).func_206870_a(TYPE2, (Comparable)((Object)Type2.NONE))).func_206870_a(CORNER, (Comparable)((Object)Corner.values[0]))).func_206870_a((IProperty)BASE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public boolean hasTileEntity(BlockState state) {
        return state.func_177229_b(TYPE1) == Type1.CORNER;
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new StructureTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{TYPE1, TYPE2, CORNER, BASE});
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext context) {
        if (state.func_177229_b(TYPE1) == Type1.NORMAL) {
            Type2 d = (Type2)((Object)state.func_177229_b(TYPE2));
            switch (d) {
                case NONE: 
                case SIDE_EW: {
                    return (Boolean)state.func_177229_b((IProperty)BASE) != false ? SHAPE_EWB : SHAPE_EW;
                }
                case VERTICAL: {
                    return SHAPE_UD;
                }
                case SIDE_NS: {
                    return (Boolean)state.func_177229_b((IProperty)BASE) != false ? SHAPE_NSB : SHAPE_NS;
                }
            }
        }
        return (Boolean)state.func_177229_b((IProperty)BASE) != false ? CORNER_WITH_BASE : SHAPE_CORNER;
    }

    @Deprecated
    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (newState.func_177230_c() == this) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            return;
        }
        super.func_196243_a(state, worldIn, pos, newState, isMoving);
        RiftStructure.breakStructure(worldIn, pos);
    }

    @Deprecated
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        return Lists.newArrayList((Object[])new ItemStack[]{new ItemStack((IItemProvider)RiftStructure.getOriginalBlock(state))});
    }

    public ItemStack getPickBlock(BlockState state, RayTraceResult target, IBlockReader world, BlockPos pos, PlayerEntity player) {
        return new ItemStack((IItemProvider)RiftStructure.getOriginalBlock(world, pos));
    }

    public BlockState cornerState(Corner corner, boolean base) {
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE1, (Comparable)((Object)Type1.CORNER))).func_206870_a(CORNER, (Comparable)((Object)corner))).func_206870_a((IProperty)BASE, (Comparable)Boolean.valueOf(base));
    }

    public BlockState edgeState(Type2 type2, boolean base) {
        return (BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(TYPE1, (Comparable)((Object)Type1.NORMAL))).func_206870_a(TYPE2, (Comparable)((Object)type2))).func_206870_a((IProperty)BASE, (Comparable)Boolean.valueOf(base));
    }

    public static enum Corner implements IStringSerializable
    {
        NE("ne"),
        NW("nw"),
        SE("se"),
        SW("sw");

        private final String name;
        public static Corner[] values;

        private Corner(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = Corner.values();
        }
    }

    public static enum Type2 implements IStringSerializable
    {
        NONE("none"),
        VERTICAL("vertical"),
        SIDE_EW("side_ew"),
        SIDE_NS("side_ns");

        private final String name;
        public static Type2[] values;

        private Type2(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = Type2.values();
        }
    }

    public static enum Type1 implements IStringSerializable
    {
        NORMAL("normal"),
        CORNER("corner");

        private final String name;
        public static Type1[] values;

        private Type1(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String func_176610_l() {
            return this.name;
        }

        static {
            values = Type1.values();
        }
    }
}

