/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.rift.storage;

import gigaherz.enderRift.rift.storage.RiftInventory;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class RiftStorage
extends WorldSavedData {
    private static final String DATA_NAME = "enderRiftStorageManager";
    private Map<Integer, RiftInventory> rifts = new HashMap<Integer, RiftInventory>();
    private int lastRiftId;

    public RiftStorage() {
        super(DATA_NAME);
    }

    public static RiftStorage get(World world) {
        if (!(world instanceof ServerWorld)) {
            throw new RuntimeException("Attempted to get the data from a client world. This is wrong.");
        }
        ServerWorld overworld = world.func_73046_m().func_71218_a(DimensionType.field_223227_a_);
        DimensionSavedDataManager storage = overworld.func_217481_x();
        return (RiftStorage)storage.func_215752_a(RiftStorage::new, DATA_NAME);
    }

    public RiftInventory getRift(int id) {
        RiftInventory rift = this.rifts.get(id);
        if (rift == null) {
            rift = new RiftInventory(this);
            this.rifts.put(id, rift);
            this.func_76185_a();
        }
        return rift;
    }

    public int getNextRiftId() {
        this.func_76185_a();
        return ++this.lastRiftId;
    }

    public void func_76184_a(CompoundNBT nbt) {
        ListNBT riftList = nbt.func_150295_c("Rifts", 10);
        this.rifts.clear();
        for (int i = 0; i < riftList.size(); ++i) {
            CompoundNBT riftTag = riftList.func_150305_b(i);
            byte j = riftTag.func_74771_c("Rift");
            RiftInventory inventory = new RiftInventory(this);
            inventory.readFromNBT(riftTag);
            this.rifts.put(Integer.valueOf(j), inventory);
        }
        this.lastRiftId = nbt.func_74762_e("LastRiftId");
    }

    public CompoundNBT func_189551_b(CompoundNBT nbtTagCompound) {
        ListNBT nbtTagList = new ListNBT();
        for (Map.Entry<Integer, RiftInventory> entry : this.rifts.entrySet()) {
            RiftInventory inventory = entry.getValue();
            CompoundNBT nbtTagCompound1 = new CompoundNBT();
            nbtTagCompound1.func_74768_a("Rift", entry.getKey().intValue());
            inventory.writeToNBT(nbtTagCompound1);
            nbtTagList.add((Object)nbtTagCompound1);
        }
        nbtTagCompound.func_218657_a("Rifts", (INBT)nbtTagList);
        nbtTagCompound.func_74768_a("LastRiftId", this.lastRiftId);
        return nbtTagCompound;
    }
}

