/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.shadow.graphlib2;

import gigaherz.enderRift.shadow.graphlib2.ContextDataFactory;
import gigaherz.enderRift.shadow.graphlib2.Graph;
import gigaherz.enderRift.shadow.graphlib2.GraphObject;
import gigaherz.enderRift.shadow.graphlib2.Mergeable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nullable;

public class ConcurrentGraph
extends Graph {
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();

    public static void connect(GraphObject object1, GraphObject object2) {
        ConcurrentGraph.connect(object1, object2, null);
    }

    public static void connect(GraphObject object1, GraphObject object2, @Nullable ContextDataFactory contextDataFactory) {
        ConcurrentGraph.connect(object1, object2, ConcurrentGraph::new, contextDataFactory);
    }

    public static void integrate(GraphObject object, List<GraphObject> neighbours) {
        ConcurrentGraph.integrate(object, neighbours, null);
    }

    public static void integrate(GraphObject object, List<GraphObject> neighbours, @Nullable ContextDataFactory contextDataFactory) {
        ConcurrentGraph.integrate(object, neighbours, ConcurrentGraph::new, contextDataFactory);
    }

    @Override
    public <T extends Mergeable<T>> T getContextData() {
        this.readLock.lock();
        try {
            Object t = super.getContextData();
            return t;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public void setContextData(Mergeable contextData) {
        this.writeLock.lock();
        try {
            super.setContextData(contextData);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void addNodeAndEdges(GraphObject object, Iterable<GraphObject> neighbours) {
        this.writeLock.lock();
        try {
            super.addNodeAndEdges(object, neighbours);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void addDirectedEdges(GraphObject object, Iterable<GraphObject> neighbours) {
        this.writeLock.lock();
        try {
            super.addDirectedEdges(object, neighbours);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void addSingleEdge(GraphObject object, GraphObject neighbour) {
        this.writeLock.lock();
        try {
            super.addSingleEdge(object, neighbour);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void removeSingleEdge(GraphObject object, GraphObject neighbour) {
        this.writeLock.lock();
        try {
            super.removeSingleEdge(object, neighbour);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void remove(GraphObject object) {
        this.writeLock.lock();
        try {
            super.remove(object);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    @Deprecated
    public Collection<GraphObject> getObjects() {
        return super.getObjects();
    }

    @Override
    public Collection<GraphObject> acquireObjects() {
        this.readLock.lock();
        return super.getObjects();
    }

    @Override
    public void releaseObjects() {
        this.readLock.unlock();
    }

    @Override
    public Collection<GraphObject> getNeighbours(GraphObject object) {
        this.readLock.lock();
        try {
            Collection<GraphObject> collection = super.getNeighbours(object);
            return collection;
        }
        finally {
            this.readLock.unlock();
        }
    }

    @Override
    public boolean contains(GraphObject object) {
        this.readLock.lock();
        try {
            boolean bl = super.contains(object);
            return bl;
        }
        finally {
            this.readLock.unlock();
        }
    }
}

