/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import gigaherz.enderRift.automation.browser.BrowserBlock;
import gigaherz.enderRift.automation.browser.BrowserContainer;
import gigaherz.enderRift.automation.browser.BrowserScreen;
import gigaherz.enderRift.automation.browser.BrowserTileEntity;
import gigaherz.enderRift.automation.browser.CraftingBrowserContainer;
import gigaherz.enderRift.automation.browser.CraftingBrowserScreen;
import gigaherz.enderRift.automation.driver.DriverBlock;
import gigaherz.enderRift.automation.driver.DriverTileEntity;
import gigaherz.enderRift.automation.iface.InterfaceBlock;
import gigaherz.enderRift.automation.iface.InterfaceContainer;
import gigaherz.enderRift.automation.iface.InterfaceScreen;
import gigaherz.enderRift.automation.iface.InterfaceTileEntity;
import gigaherz.enderRift.automation.proxy.ProxyBlock;
import gigaherz.enderRift.automation.proxy.ProxyTileEntity;
import gigaherz.enderRift.generator.GeneratorBlock;
import gigaherz.enderRift.generator.GeneratorContainer;
import gigaherz.enderRift.generator.GeneratorScreen;
import gigaherz.enderRift.generator.GeneratorTileEntity;
import gigaherz.enderRift.network.ClearCraftingGrid;
import gigaherz.enderRift.network.SendSlotChanges;
import gigaherz.enderRift.network.SetVisibleSlots;
import gigaherz.enderRift.network.UpdateField;
import gigaherz.enderRift.network.UpdatePowerStatus;
import gigaherz.enderRift.rift.OrbDuplicationRecipe;
import gigaherz.enderRift.rift.RiftBlock;
import gigaherz.enderRift.rift.RiftItem;
import gigaherz.enderRift.rift.RiftStructure;
import gigaherz.enderRift.rift.RiftTileEntity;
import gigaherz.enderRift.rift.StructureBlock;
import gigaherz.enderRift.rift.StructureTileEntity;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootParameterSet;
import net.minecraft.world.storage.loot.LootParameterSets;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.ValidationTracker;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.ObjectHolder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber
@Mod(value="enderrift")
public class EnderRiftMod {
    public static final String MODID = "enderrift";
    public static ItemGroup tabEnderRift = new ItemGroup("tabEnderRift"){

        public ItemStack func_78016_d() {
            return new ItemStack((IItemProvider)EnderRiftItems.RIFT_ORB);
        }
    };
    public static EnderRiftMod instance;
    public static final String CHANNEL = "enderrift";
    private static final String PROTOCOL_VERSION = "1.0";
    public static SimpleChannel channel;
    public static final Logger logger;

    @Nonnull
    private static <T> T toBeInitializedLater() {
        return null;
    }

    public EnderRiftMod() {
        instance = this;
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addGenericListener(Block.class, this::registerBlocks);
        modEventBus.addGenericListener(Item.class, this::registerItems);
        modEventBus.addGenericListener(TileEntityType.class, this::registerTEs);
        modEventBus.addGenericListener(ContainerType.class, this::registerContainers);
        modEventBus.addGenericListener(IRecipeSerializer.class, this::registerRecipeSerializers);
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::gatherData);
    }

    public void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{(Block)new RiftBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185852_e).func_200948_a(3.0f, 8.0f).func_208770_d()).setRegistryName("rift"), (Block)new StructureBlock(Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185852_e).func_200948_a(3.0f, 8.0f).func_222380_e()).setRegistryName("structure"), (Block)new InterfaceBlock(Block.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151665_m).func_200947_a(SoundType.field_185852_e).func_200948_a(3.0f, 8.0f)).setRegistryName("interface"), (Block)new BrowserBlock(false, Block.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151665_m).func_200947_a(SoundType.field_185852_e).func_200948_a(3.0f, 8.0f)).setRegistryName("browser"), (Block)new BrowserBlock(true, Block.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151665_m).func_200947_a(SoundType.field_185852_e).func_200948_a(3.0f, 8.0f)).setRegistryName("crafting_browser"), (Block)new ProxyBlock(Block.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151665_m).func_200947_a(SoundType.field_185852_e).func_200948_a(3.0f, 8.0f)).setRegistryName("proxy"), (Block)new DriverBlock(Block.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151665_m).func_200947_a(SoundType.field_185852_e).func_200948_a(3.0f, 8.0f)).setRegistryName("driver"), (Block)new GeneratorBlock(Block.Properties.func_200949_a((Material)Material.field_151573_f, (MaterialColor)MaterialColor.field_151665_m).func_200947_a(SoundType.field_185852_e).func_200948_a(3.0f, 8.0f)).setRegistryName("generator")});
    }

    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new BlockItem(EnderRiftBlocks.RIFT, new Item.Properties().func_200916_a(tabEnderRift)).setRegistryName(EnderRiftBlocks.RIFT.getRegistryName()), (Item)new BlockItem(EnderRiftBlocks.INTERFACE, new Item.Properties().func_200916_a(tabEnderRift)).setRegistryName(EnderRiftBlocks.INTERFACE.getRegistryName()), (Item)new BlockItem(EnderRiftBlocks.BROWSER, new Item.Properties().func_200916_a(tabEnderRift)).setRegistryName(EnderRiftBlocks.BROWSER.getRegistryName()), (Item)new BlockItem(EnderRiftBlocks.CRAFTING_BROWSER, new Item.Properties().func_200916_a(tabEnderRift)).setRegistryName(EnderRiftBlocks.CRAFTING_BROWSER.getRegistryName()), (Item)new BlockItem(EnderRiftBlocks.PROXY, new Item.Properties().func_200916_a(tabEnderRift)).setRegistryName(EnderRiftBlocks.PROXY.getRegistryName()), (Item)new BlockItem(EnderRiftBlocks.DRIVER, new Item.Properties().func_200916_a(tabEnderRift)).setRegistryName(EnderRiftBlocks.DRIVER.getRegistryName()), (Item)new BlockItem(EnderRiftBlocks.GENERATOR, new Item.Properties().func_200916_a(tabEnderRift)).setRegistryName(EnderRiftBlocks.GENERATOR.getRegistryName()), (Item)new RiftItem(new Item.Properties().func_200917_a(16).func_200916_a(tabEnderRift)).setRegistryName("rift_orb")});
    }

    public void registerTEs(RegistryEvent.Register<TileEntityType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new TileEntityType[]{(TileEntityType)TileEntityType.Builder.func_223042_a(RiftTileEntity::new, (Block[])new Block[]{EnderRiftBlocks.RIFT}).func_206865_a(null).setRegistryName("rift"), (TileEntityType)TileEntityType.Builder.func_223042_a(StructureTileEntity::new, (Block[])new Block[]{EnderRiftBlocks.STRUCTURE}).func_206865_a(null).setRegistryName("structure"), (TileEntityType)TileEntityType.Builder.func_223042_a(InterfaceTileEntity::new, (Block[])new Block[]{EnderRiftBlocks.INTERFACE}).func_206865_a(null).setRegistryName("interface"), (TileEntityType)TileEntityType.Builder.func_223042_a(BrowserTileEntity::new, (Block[])new Block[]{EnderRiftBlocks.BROWSER, EnderRiftBlocks.CRAFTING_BROWSER}).func_206865_a(null).setRegistryName("browser"), (TileEntityType)TileEntityType.Builder.func_223042_a(ProxyTileEntity::new, (Block[])new Block[]{EnderRiftBlocks.PROXY}).func_206865_a(null).setRegistryName("proxy"), (TileEntityType)TileEntityType.Builder.func_223042_a(DriverTileEntity::new, (Block[])new Block[]{EnderRiftBlocks.DRIVER}).func_206865_a(null).setRegistryName("driver"), (TileEntityType)TileEntityType.Builder.func_223042_a(GeneratorTileEntity::new, (Block[])new Block[]{EnderRiftBlocks.GENERATOR}).func_206865_a(null).setRegistryName("generator")});
    }

    public void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new ContainerType[]{(ContainerType)new ContainerType(BrowserContainer::new).setRegistryName("browser"), (ContainerType)new ContainerType(CraftingBrowserContainer::new).setRegistryName("crafting_browser"), (ContainerType)IForgeContainerType.create(InterfaceContainer::new).setRegistryName("interface"), (ContainerType)IForgeContainerType.create(GeneratorContainer::new).setRegistryName("generator")});
    }

    public void registerRecipeSerializers(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new IRecipeSerializer[]{(IRecipeSerializer)new OrbDuplicationRecipe.Serializer().setRegistryName("orb_duplication")});
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        int messageNumber = 0;
        channel.messageBuilder(ClearCraftingGrid.class, messageNumber++).encoder(ClearCraftingGrid::encode).decoder(ClearCraftingGrid::new).consumer(ClearCraftingGrid::handle).add();
        channel.messageBuilder(SendSlotChanges.class, messageNumber++).encoder(SendSlotChanges::encode).decoder(SendSlotChanges::new).consumer(SendSlotChanges::handle).add();
        channel.messageBuilder(SetVisibleSlots.class, messageNumber++).encoder(SetVisibleSlots::encode).decoder(SetVisibleSlots::new).consumer(SetVisibleSlots::handle).add();
        channel.messageBuilder(UpdateField.class, messageNumber++).encoder(UpdateField::encode).decoder(UpdateField::new).consumer(UpdateField::handle).add();
        channel.messageBuilder(UpdatePowerStatus.class, messageNumber++).encoder(UpdatePowerStatus::encode).decoder(UpdatePowerStatus::new).consumer(UpdatePowerStatus::handle).add();
        logger.debug("Final message number: " + messageNumber);
        RiftStructure.init();
    }

    public void clientSetup(FMLClientSetupEvent event) {
        ScreenManager.func_216911_a(GeneratorContainer.TYPE, GeneratorScreen::new);
        ScreenManager.func_216911_a(InterfaceContainer.TYPE, InterfaceScreen::new);
        ScreenManager.func_216911_a(BrowserContainer.TYPE, BrowserScreen::new);
        ScreenManager.func_216911_a(CraftingBrowserContainer.TYPE, CraftingBrowserScreen::new);
    }

    public void interComms(InterModEnqueueEvent event) {
        InterModComms.sendTo((String)"gbook", (String)"registerBook", () -> EnderRiftMod.location("xml/book.xml"));
    }

    public void gatherData(GatherDataEvent event) {
        Data.gatherData(event);
    }

    public static ResourceLocation location(String path) {
        return new ResourceLocation("enderrift", path);
    }

    static /* synthetic */ Object access$000() {
        return EnderRiftMod.toBeInitializedLater();
    }

    static {
        channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("enderrift", "enderrift")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
        logger = LogManager.getLogger((String)"enderrift");
    }

    public static class Data {
        public static void gatherData(GatherDataEvent event) {
            DataGenerator gen = event.getGenerator();
            if (event.includeServer()) {
                gen.func_200390_a((IDataProvider)new LootTables(gen));
            }
            if (event.includeClient()) {
                // empty if block
            }
        }

        private static class LootTables
        extends LootTableProvider
        implements IDataProvider {
            private final List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> tables = ImmutableList.of((Object)Pair.of(BlockTables::new, (Object)LootParameterSets.field_216267_h));

            public LootTables(DataGenerator gen) {
                super(gen);
            }

            protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
                return this.tables;
            }

            protected void validate(Map<ResourceLocation, LootTable> map, ValidationTracker validationtracker) {
                map.forEach((p_218436_2_, p_218436_3_) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)p_218436_2_, (LootTable)p_218436_3_));
            }

            public static class BlockTables
            extends BlockLootTables {
                protected void addTables() {
                    this.func_218492_c(EnderRiftBlocks.GENERATOR);
                    this.func_218492_c(EnderRiftBlocks.DRIVER);
                    this.func_218492_c(EnderRiftBlocks.PROXY);
                    this.func_218492_c(EnderRiftBlocks.INTERFACE);
                    this.func_218492_c(EnderRiftBlocks.BROWSER);
                    this.func_218492_c(EnderRiftBlocks.CRAFTING_BROWSER);
                    this.func_218492_c(EnderRiftBlocks.RIFT);
                }

                protected Iterable<Block> getKnownBlocks() {
                    return ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b.getRegistryName().func_110624_b().equals("enderrift")).collect(Collectors.toList());
                }
            }
        }
    }

    @ObjectHolder(value="enderrift")
    public static class EnderRiftItems {
        public static final Item RIFT_ORB = (Item)EnderRiftMod.access$000();
    }

    @ObjectHolder(value="enderrift")
    public static class EnderRiftBlocks {
        public static final Block RIFT = (Block)EnderRiftMod.access$000();
        public static final StructureBlock STRUCTURE = (StructureBlock)((Object)EnderRiftMod.access$000());
        public static final Block INTERFACE = (Block)EnderRiftMod.access$000();
        public static final Block GENERATOR = (Block)EnderRiftMod.access$000();
        public static final Block BROWSER = (Block)EnderRiftMod.access$000();
        public static final Block CRAFTING_BROWSER = (Block)EnderRiftMod.access$000();
        public static final Block PROXY = (Block)EnderRiftMod.access$000();
        public static final Block DRIVER = (Block)EnderRiftMod.access$000();
    }
}

