/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.automation;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyAggregator
implements IEnergyStorage {
    private final List<IEnergyStorage> buffers = Lists.newArrayList();

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int remaining = maxReceive;
        for (IEnergyStorage st : this.buffers) {
            if (!st.canReceive()) continue;
            remaining = st.receiveEnergy(remaining, simulate);
        }
        return remaining;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int remaining = maxExtract;
        for (IEnergyStorage st : this.buffers) {
            if (!st.canExtract()) continue;
            remaining = st.extractEnergy(remaining, simulate);
        }
        return remaining;
    }

    public int getEnergyStored() {
        int total = 0;
        for (IEnergyStorage st : this.buffers) {
            total += st.getEnergyStored();
        }
        return total;
    }

    public int getMaxEnergyStored() {
        int total = 0;
        for (IEnergyStorage st : this.buffers) {
            total += st.getMaxEnergyStored();
        }
        return total;
    }

    public boolean canExtract() {
        return this.buffers.stream().anyMatch(IEnergyStorage::canExtract);
    }

    public boolean canReceive() {
        return this.buffers.stream().anyMatch(IEnergyStorage::canReceive);
    }

    public void add(IEnergyStorage buffer) {
        this.buffers.add(buffer);
    }
}

