/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.automation.browser;

import com.google.common.collect.Lists;
import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.automation.AutomationHelper;
import gigaherz.enderRift.automation.browser.BrowserTileEntity;
import gigaherz.enderRift.automation.browser.SortMode;
import gigaherz.enderRift.common.slots.SlotFake;
import gigaherz.enderRift.network.SendSlotChanges;
import gigaherz.enderRift.network.SetVisibleSlots;
import gigaherz.enderRift.network.UpdatePowerStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import joptsimple.internal.Strings;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.ClickType;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.IContainerListener;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.StringUtils;

public class AbstractBrowserContainer
extends Container {
    public final IItemHandlerModifiable scrollInventory;
    public final boolean isClient;
    protected BrowserTileEntity tile;
    private int prevChangeCount;
    public int scroll;
    public SortMode sortMode = SortMode.StackSize;
    public String filterText = "";
    private ItemStack stackInCursor = ItemStack.field_190927_a;
    private final PlayerEntity player;
    private NonNullList<ItemStack> currentStacks = NonNullList.func_191196_a();
    protected static final int Left = 8;
    protected static final int Top = 18;
    protected static final int SlotWidth = 18;
    protected static final int SlotHeight = 18;
    protected static final int ScrollRows = 3;
    protected static final int ScrollColumns = 9;
    protected static final int ScrollSlots = 27;
    protected static final int PlayerRows = 4;
    protected static final int PlayerColumns = 9;
    protected static final int PlayerSlots = 36;
    private boolean isLowOnPowerPrev;

    public ClientScrollInventory getClient() {
        if (!this.isClient) {
            throw new IllegalStateException("Attempted to get client inventory on the server");
        }
        return (ClientScrollInventory)this.scrollInventory;
    }

    public ServerScrollInventory getServer() {
        if (this.isClient) {
            throw new IllegalStateException("Attempted to get server inventory on the client");
        }
        return (ServerScrollInventory)this.scrollInventory;
    }

    protected AbstractBrowserContainer(ContainerType<? extends AbstractBrowserContainer> type, int id, @Nullable BrowserTileEntity tileEntity, PlayerInventory playerInventory) {
        super(type, id);
        this.tile = tileEntity;
        this.player = playerInventory.field_70458_d;
        this.isClient = this.player.field_70170_p.field_72995_K;
        this.scrollInventory = this.isClient ? new ClientScrollInventory() : new ServerScrollInventory(Objects.requireNonNull(this.tile));
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a((Slot)new SlotFake((IItemHandler)this.scrollInventory, x + y * 9, 8 + x * 18, 18 + y * 18));
            }
        }
        this.bindPlayerInventory(playerInventory);
    }

    protected void bindPlayerInventory(PlayerInventory playerInventory) {
        this.bindPlayerInventory(playerInventory, 86);
    }

    protected void bindPlayerInventory(PlayerInventory playerInventory, int top) {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x + y * 9 + 9, 8 + x * 18, top + y * 18));
            }
        }
        top += 58;
        for (int x = 0; x < 9; ++x) {
            this.func_75146_a(new Slot((IInventory)playerInventory, x, 8 + x * 18, top));
        }
    }

    public boolean func_75145_c(PlayerEntity player) {
        return true;
    }

    public void func_75142_b() {
        int i;
        if (this.isClient) {
            return;
        }
        boolean isLowOnPowerNew = this.tile.isLowOnPower();
        if (this.isLowOnPowerPrev != isLowOnPowerNew) {
            for (IContainerListener crafter : this.field_75149_d) {
                if (!(crafter instanceof ServerPlayerEntity)) continue;
                EnderRiftMod.channel.sendTo((Object)new UpdatePowerStatus(this.field_75152_c, isLowOnPowerNew), ((ServerPlayerEntity)crafter).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
            this.isLowOnPowerPrev = isLowOnPowerNew;
        }
        ServerScrollInventory serverInv = this.getServer();
        if (this.prevChangeCount != this.tile.getChangeCount()) {
            serverInv.refresh();
            this.prevChangeCount = this.tile.getChangeCount();
        }
        int oldLength = this.currentStacks.size();
        ArrayList indicesChanged = Lists.newArrayList();
        ArrayList stacksChanged = Lists.newArrayList();
        int newLength = serverInv.getRealSizeInventory();
        if (newLength != oldLength) {
            this.changeSize(oldLength, newLength);
        }
        for (i = 0; i < newLength; ++i) {
            ItemStack newStack = serverInv.getStack(i);
            ItemStack current = (ItemStack)this.currentStacks.get(i);
            if (ItemStack.func_77989_b((ItemStack)current, (ItemStack)newStack)) continue;
            current = newStack.func_77946_l();
            this.currentStacks.set(i, (Object)current);
            indicesChanged.add(i);
            stacksChanged.add(current);
        }
        for (i = 27; i < this.field_75151_b.size(); ++i) {
            ItemStack inSlot = ((Slot)this.field_75151_b.get(i)).func_75211_c();
            ItemStack inCache = (ItemStack)this.field_75153_a.get(i);
            if (ItemStack.func_77989_b((ItemStack)inCache, (ItemStack)inSlot)) continue;
            inCache = inSlot.func_77946_l();
            this.field_75153_a.set(i, (Object)inCache);
            for (IContainerListener crafter : this.field_75149_d) {
                crafter.func_71111_a((Container)this, i, inCache);
            }
        }
        for (IContainerListener crafter : this.field_75149_d) {
            if (!(crafter instanceof ServerPlayerEntity)) continue;
            if (newLength != oldLength || indicesChanged.size() > 0) {
                EnderRiftMod.channel.sendTo((Object)new SendSlotChanges(this.field_75152_c, newLength, indicesChanged, stacksChanged), ((ServerPlayerEntity)crafter).field_71135_a.func_147298_b(), NetworkDirection.PLAY_TO_CLIENT);
            }
            ServerPlayerEntity player = (ServerPlayerEntity)crafter;
            ItemStack newStack = player.field_71071_by.func_70445_o();
            if (ItemStack.func_77989_b((ItemStack)this.stackInCursor, (ItemStack)newStack)) continue;
            this.sendStackInCursor(player, newStack);
        }
        if (newLength != oldLength || indicesChanged.size() > 0) {
            serverInv.resetVisible();
        }
    }

    private void changeSize(int oldLength, int newLength) {
        NonNullList<ItemStack> oldStacks = this.currentStacks;
        this.currentStacks = NonNullList.func_191197_a((int)newLength, (Object)ItemStack.field_190927_a);
        for (int i = 0; i < Math.min(newLength, oldLength); ++i) {
            this.currentStacks.set(i, oldStacks.get(i));
        }
    }

    private void sendStackInCursor(ServerPlayerEntity player, ItemStack newStack) {
        this.stackInCursor = newStack.func_77946_l();
        player.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(-1, -1, newStack));
    }

    public void slotsChanged(int slotCount, List<Integer> indices, List<ItemStack> stacks) {
        if (slotCount != this.currentStacks.size()) {
            this.changeSize(this.currentStacks.size(), slotCount);
        }
        for (int i = 0; i < indices.size(); ++i) {
            int slot = indices.get(i);
            ItemStack stack = stacks.get(i);
            this.currentStacks.set(slot, (Object)stack);
        }
        ClientScrollInventory clientInv = this.getClient();
        clientInv.setArray(this.currentStacks);
        this.setVisibleSlots(clientInv.getIndices());
    }

    public void func_190896_a(List<ItemStack> p_75131_1_) {
    }

    public void setVisibleSlots(int[] visible) {
        if (this.isClient) {
            EnderRiftMod.channel.sendToServer((Object)new SetVisibleSlots(this.field_75152_c, visible));
        } else {
            this.getServer().setVisible(visible);
        }
    }

    public void setScrollPos(int scroll) {
        this.scroll = scroll;
        this.setVisibleSlots(this.getClient().getIndices());
    }

    public void setSortMode(SortMode sortMode) {
        this.sortMode = sortMode;
        this.scroll = 0;
        ClientScrollInventory clientInv = this.getClient();
        clientInv.setArray(this.currentStacks);
        this.setVisibleSlots(clientInv.getIndices());
    }

    public void setFilterText(String text) {
        this.filterText = text.toLowerCase();
        this.scroll = 0;
        ClientScrollInventory clientInv = this.getClient();
        clientInv.setArray(this.currentStacks);
        this.setVisibleSlots(clientInv.getIndices());
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        super.func_75141_a(slotID, stack);
    }

    public ItemStack func_184996_a(int slotId, int clickedButton, ClickType mode, PlayerEntity playerIn) {
        PlayerInventory inventoryPlayer = playerIn.field_71071_by;
        if (slotId >= 0 && slotId < 27) {
            IItemHandler parent = this.getTileInventory();
            Slot slot = (Slot)this.field_75151_b.get(slotId);
            ItemStack existing = slot.func_75211_c();
            if (mode == ClickType.PICKUP) {
                ItemStack dropping = inventoryPlayer.func_70445_o();
                if (dropping.func_190916_E() > 0) {
                    if (clickedButton == 0) {
                        ItemStack remaining = this.insertItemsSided(parent, dropping);
                        if (remaining.func_190916_E() > 0) {
                            if (dropping.func_190916_E() != remaining.func_190916_E()) {
                                this.markTileDirty();
                            }
                            for (IContainerListener crafter : this.field_75149_d) {
                                if (!(crafter instanceof ServerPlayerEntity)) continue;
                                this.sendStackInCursor((ServerPlayerEntity)crafter, remaining);
                            }
                        } else {
                            this.markTileDirty();
                        }
                        inventoryPlayer.func_70437_b(remaining);
                    } else {
                        int amount = 1;
                        ItemStack push = dropping.func_77946_l();
                        push.func_190920_e(amount);
                        ItemStack remaining = this.insertItemsSided(parent, push);
                        dropping.func_190918_g(push.func_190916_E());
                        if (remaining.func_190916_E() > 0) {
                            if (push.func_190916_E() != remaining.func_190916_E()) {
                                this.markTileDirty();
                            }
                            dropping.func_190917_f(remaining.func_190916_E());
                            for (IContainerListener crafter : this.field_75149_d) {
                                if (!(crafter instanceof ServerPlayerEntity)) continue;
                                this.sendStackInCursor((ServerPlayerEntity)crafter, remaining);
                            }
                        } else {
                            this.markTileDirty();
                        }
                        if (dropping.func_190916_E() <= 0) {
                            dropping = ItemStack.field_190927_a;
                        }
                        inventoryPlayer.func_70437_b(dropping);
                    }
                } else if (existing.func_190916_E() > 0) {
                    int amount = clickedButton == 0 ? existing.func_77976_d() : existing.func_77976_d() / 2;
                    ItemStack extracted = this.extractItemsSided(parent, existing, amount, false);
                    if (extracted.func_190916_E() > 0) {
                        this.markTileDirty();
                    } else {
                        for (IContainerListener crafter : this.field_75149_d) {
                            if (!(crafter instanceof ServerPlayerEntity)) continue;
                            this.sendStackInCursor((ServerPlayerEntity)crafter, extracted);
                        }
                    }
                    inventoryPlayer.func_70437_b(extracted);
                }
                this.func_75142_b();
                return slot.func_75211_c();
            }
            if (mode == ClickType.QUICK_MOVE && existing.func_190916_E() > 0) {
                ItemStack finalExtract;
                int amount = existing.func_77976_d();
                if (clickedButton != 0 && amount > 1) {
                    amount /= 2;
                }
                if (amount == 0) {
                    return ItemStack.field_190927_a;
                }
                ItemStack remaining = this.simulateAddToPlayer(existing, amount);
                if (remaining.func_190916_E() > 0) {
                    amount -= remaining.func_190916_E();
                }
                if (amount > 0 && (finalExtract = this.extractItemsSided(parent, existing, amount, false)).func_190916_E() > 0) {
                    this.addToPlayer(finalExtract);
                    this.markTileDirty();
                    this.func_75142_b();
                }
            }
            if (mode != ClickType.CLONE) {
                return ItemStack.field_190927_a;
            }
        }
        return super.func_184996_a(slotId, clickedButton, mode, playerIn);
    }

    @Nullable
    private IItemHandler getTileInventory() {
        return this.isClient || this.tile == null ? null : this.tile.getCombinedInventory();
    }

    private void markTileDirty() {
        if (!this.isClient && this.tile != null) {
            this.tile.func_70296_d();
        }
    }

    private ItemStack extractItemsSided(@Nullable IItemHandler parent, ItemStack existing, int amount, boolean simulate) {
        if (this.isClient || parent == null) {
            return existing.func_77946_l();
        }
        return AutomationHelper.extractItems(parent, existing, amount, simulate);
    }

    private ItemStack insertItemsSided(@Nullable IItemHandler parent, ItemStack dropping) {
        if (this.isClient || parent == null) {
            return ItemStack.field_190927_a;
        }
        return AutomationHelper.insertItems(parent, dropping);
    }

    private ItemStack simulateAddToPlayer(ItemStack stack, int amount) {
        int startIndex = 27;
        int endIndex = startIndex + 36;
        ItemStack stackCopy = stack.func_77946_l();
        stackCopy.func_190920_e(amount);
        if (!this.simulateInsertStack(stackCopy, startIndex, endIndex)) {
            return stackCopy;
        }
        if (stackCopy.func_190916_E() <= 0) {
            return ItemStack.field_190927_a;
        }
        return stackCopy;
    }

    protected boolean simulateInsertStack(ItemStack stack, int startIndex, int endIndex) {
        ItemStack stackInSlot;
        Slot slot;
        int i;
        boolean canInsert = false;
        if (stack.func_77985_e()) {
            for (i = startIndex; stack.func_190916_E() > 0 && i < endIndex; ++i) {
                slot = (Slot)this.field_75151_b.get(i);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot.func_190916_E() >= stackInSlot.func_77976_d() || !ItemStack.func_179545_c((ItemStack)stackInSlot, (ItemStack)stack) || !ItemStack.func_77970_a((ItemStack)stack, (ItemStack)stackInSlot)) continue;
                int j = stackInSlot.func_190916_E() + stack.func_190916_E();
                if (j <= stack.func_77976_d()) {
                    stack.func_190920_e(0);
                    canInsert = true;
                    continue;
                }
                stack.func_190918_g(stack.func_77976_d() - stackInSlot.func_190916_E());
                canInsert = true;
            }
        }
        if (stack.func_190916_E() > 0) {
            for (i = startIndex; i < endIndex; ++i) {
                slot = (Slot)this.field_75151_b.get(i);
                stackInSlot = slot.func_75211_c();
                if (stackInSlot.func_190916_E() > 0 || !slot.func_75214_a(stack)) continue;
                stack.func_190920_e(0);
                canInsert = true;
                break;
            }
        }
        return canInsert;
    }

    public ItemStack addToPlayer(ItemStack stack) {
        int startIndex = 27;
        int endIndex = startIndex + 36;
        ItemStack stackCopy = stack.func_77946_l();
        if (!this.func_75135_a(stackCopy, startIndex, endIndex, false)) {
            return stackCopy;
        }
        if (stackCopy.func_190916_E() <= 0) {
            return ItemStack.field_190927_a;
        }
        return stackCopy;
    }

    public ItemStack func_82846_b(PlayerEntity player, int slotIndex) {
        Slot slot = (Slot)this.field_75151_b.get(slotIndex);
        if (slot == null || !slot.func_75216_d()) {
            return ItemStack.field_190927_a;
        }
        if (slotIndex < 27) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = slot.func_75211_c();
        ItemStack stackCopy = stack.func_77946_l();
        ItemStack remaining = this.insertItemsSided(this.getTileInventory(), stack);
        if (remaining.func_190916_E() > 0) {
            if (player instanceof IContainerListener) {
                ((IContainerListener)player).func_71111_a((Container)this, slotIndex, remaining);
            }
            if (remaining.func_190916_E() == stackCopy.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            this.markTileDirty();
            stack.func_190920_e(remaining.func_190916_E());
            slot.func_75218_e();
        } else {
            this.markTileDirty();
            stack.func_190920_e(0);
            slot.func_75215_d(ItemStack.field_190927_a);
        }
        slot.func_190901_a(player, stack);
        return stackCopy;
    }

    public int getActualSlotCount() {
        return this.scrollInventory.getSlots();
    }

    public boolean isLowOnPower() {
        return this.isLowOnPowerPrev;
    }

    public void updatePowerStatus(boolean status) {
        this.isLowOnPowerPrev = status;
    }

    public class ClientScrollInventory
    implements IItemHandlerModifiable {
        private int[] indices;
        private NonNullList<ItemStack> stacks;

        public void setArray(NonNullList<ItemStack> stacks) {
            this.stacks = stacks;
            ArrayList indices = Lists.newArrayList();
            ArrayList itemData = Lists.newArrayList();
            int indexx = 0;
            for (ItemStack invStack : stacks) {
                ItemStack stack = invStack.func_77946_l();
                boolean matchesSearch = true;
                if (!Strings.isNullOrEmpty((String)AbstractBrowserContainer.this.filterText)) {
                    itemData.clear();
                    Item item = invStack.func_77973_b();
                    itemData.add(stack.func_200301_q());
                    itemData.add(new StringTextComponent(ForgeRegistries.ITEMS.getKey((IForgeRegistryEntry)item).toString()));
                    item.func_77624_a(stack, ((AbstractBrowserContainer)AbstractBrowserContainer.this).player.field_70170_p, (List)itemData, (ITooltipFlag)ITooltipFlag.TooltipFlags.NORMAL);
                    matchesSearch = false;
                    for (ITextComponent s : itemData) {
                        if (!StringUtils.containsIgnoreCase((CharSequence)s.getString(), (CharSequence)AbstractBrowserContainer.this.filterText)) continue;
                        matchesSearch = true;
                        break;
                    }
                }
                if (matchesSearch) {
                    indices.add(indexx);
                }
                ++indexx;
            }
            if (AbstractBrowserContainer.this.sortMode != null) {
                switch (AbstractBrowserContainer.this.sortMode) {
                    case Alphabetic: {
                        indices.sort((ia, ib) -> {
                            ItemStack a = (ItemStack)stacks.get(ia.intValue());
                            ItemStack b = (ItemStack)stacks.get(ib.intValue());
                            return a.func_200301_q().getString().compareToIgnoreCase(b.func_200301_q().getString());
                        });
                        break;
                    }
                    case StackSize: {
                        indices.sort((ia, ib) -> {
                            ItemStack a = (ItemStack)stacks.get(ia.intValue());
                            ItemStack b = (ItemStack)stacks.get(ib.intValue());
                            int diff = a.func_190916_E() - b.func_190916_E();
                            if (diff > 0) {
                                return -1;
                            }
                            if (diff < 0) {
                                return 1;
                            }
                            return a.func_200301_q().getString().compareToIgnoreCase(b.func_200301_q().getString());
                        });
                    }
                }
            }
            this.indices = new int[indices.size()];
            for (int i = 0; i < this.indices.length; ++i) {
                this.indices[i] = (Integer)indices.get(i);
            }
        }

        public int getSlots() {
            return this.indices.length;
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot + AbstractBrowserContainer.this.scroll >= this.indices.length) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack = (ItemStack)this.stacks.get(this.indices[slot + AbstractBrowserContainer.this.scroll]);
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
            return stack;
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            if (slot + AbstractBrowserContainer.this.scroll < this.indices.length) {
                this.stacks.set(this.indices[slot + AbstractBrowserContainer.this.scroll], (Object)stack);
            }
        }

        public int getStackSizeForSlot(int slot) {
            if (slot + AbstractBrowserContainer.this.scroll >= this.indices.length) {
                return 0;
            }
            return ((ItemStack)this.stacks.get(this.indices[slot + AbstractBrowserContainer.this.scroll])).func_190916_E();
        }

        public int[] getIndices() {
            int from = Math.max(0, Math.min(AbstractBrowserContainer.this.scroll, this.indices.length - 1));
            int to = Math.min(from + 27, this.indices.length);
            return Arrays.copyOfRange(this.indices, from, to);
        }
    }

    public static class ServerScrollInventory
    implements IItemHandlerModifiable {
        final BrowserTileEntity tile;
        final List<ItemStack> slots = Lists.newArrayList();
        private int[] visible = new int[0];

        public ServerScrollInventory(BrowserTileEntity tile) {
            this.tile = tile;
        }

        public void setVisible(int[] visible) {
            this.visible = visible;
        }

        public void resetVisible() {
            this.visible = new int[0];
        }

        public void refresh() {
            IItemHandler inv = this.tile.getCombinedInventory();
            ArrayList slotsSeen = Lists.newArrayList();
            this.slots.clear();
            if (inv == null) {
                return;
            }
            int invSlots = inv.getSlots();
            for (int j = 0; j < invSlots; ++j) {
                ItemStack invStack = inv.getStackInSlot(j);
                if (invStack.func_190916_E() <= 0) continue;
                boolean found = false;
                for (ItemStack cachedStack : slotsSeen) {
                    if (!ItemStack.func_179545_c((ItemStack)cachedStack, (ItemStack)invStack) || !ItemStack.func_77970_a((ItemStack)cachedStack, (ItemStack)invStack)) continue;
                    cachedStack.func_190917_f(invStack.func_190916_E());
                    found = true;
                    break;
                }
                if (found) continue;
                ItemStack stack = invStack.func_77946_l();
                slotsSeen.add(stack);
                this.slots.add(stack);
            }
        }

        public int getRealSizeInventory() {
            return this.slots.size();
        }

        public int getSlots() {
            return this.visible.length;
        }

        public ItemStack getStackInSlot(int index) {
            if (index >= this.visible.length) {
                return ItemStack.field_190927_a;
            }
            int i = this.visible[index];
            if (i >= this.slots.size()) {
                return ItemStack.field_190927_a;
            }
            return this.slots.get(this.visible[index]);
        }

        public ItemStack getStack(int index) {
            return this.slots.get(index);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
        }
    }
}

