/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.automation.driver;

import com.google.common.collect.ImmutableMap;
import gigaherz.enderRift.automation.AggregatorBlock;
import gigaherz.enderRift.automation.AggregatorTileEntity;
import gigaherz.enderRift.automation.AutomationHelper;
import gigaherz.enderRift.automation.driver.DriverTileEntity;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;

public class DriverBlock
extends AggregatorBlock<DriverTileEntity> {
    public static final BooleanProperty NORTH = BlockStateProperties.field_208151_D;
    public static final BooleanProperty SOUTH = BlockStateProperties.field_208153_F;
    public static final BooleanProperty WEST = BlockStateProperties.field_208154_G;
    public static final BooleanProperty EAST = BlockStateProperties.field_208152_E;
    public static final BooleanProperty UP = BlockStateProperties.field_208149_B;
    public static final BooleanProperty DOWN = BlockStateProperties.field_208150_C;
    private static final VoxelShape BOUNDS = Block.func_208617_a((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
    private static final VoxelShape BOUNDS_NORTH = Block.func_208617_a((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape BOUNDS_SOUTH = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)16.0);
    private static final VoxelShape BOUNDS_EAST = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
    private static final VoxelShape BOUNDS_WEST = Block.func_208617_a((double)0.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final VoxelShape BOUNDS_UP = Block.func_208617_a((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
    private static final VoxelShape BOUNDS_DOWN = Block.func_208617_a((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
    private static final Map<BooleanProperty, VoxelShape> SIDES = ImmutableMap.builder().put((Object)NORTH, (Object)BOUNDS_NORTH).put((Object)SOUTH, (Object)BOUNDS_SOUTH).put((Object)WEST, (Object)BOUNDS_WEST).put((Object)EAST, (Object)BOUNDS_EAST).put((Object)UP, (Object)BOUNDS_UP).put((Object)DOWN, (Object)BOUNDS_DOWN).build();

    public DriverBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{NORTH, SOUTH, WEST, EAST, UP, DOWN});
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new DriverTileEntity();
    }

    @Deprecated
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return VoxelShapes.func_216384_a((VoxelShape)BOUNDS, (VoxelShape[])((VoxelShape[])SIDES.entrySet().stream().filter(kv -> (Boolean)state.func_177229_b((IProperty)kv.getKey())).map(Map.Entry::getValue).toArray(VoxelShape[]::new)));
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext ctx) {
        return this.getStateForConnections(this.func_176223_P(), (IWorld)ctx.func_195991_k(), ctx.func_195995_a());
    }

    @Deprecated
    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.getStateForConnections(stateIn, worldIn, currentPos);
    }

    private BlockState getStateForConnections(BlockState state, IWorld world, BlockPos pos) {
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.isConnectableAutomation((IBlockReader)world, pos, Direction.NORTH)))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.isConnectableAutomation((IBlockReader)world, pos, Direction.SOUTH)))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.isConnectableAutomation((IBlockReader)world, pos, Direction.WEST)))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.isConnectableAutomation((IBlockReader)world, pos, Direction.EAST)))).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(this.isConnectableAutomation((IBlockReader)world, pos, Direction.UP)))).func_206870_a((IProperty)DOWN, (Comparable)Boolean.valueOf(this.isConnectableAutomation((IBlockReader)world, pos, Direction.DOWN)));
    }

    @Override
    protected void recheckNeighbour(IBlockReader world, BlockPos pos, BlockPos neighbor) {
    }

    private boolean isConnectablePower(IBlockReader worldIn, BlockPos pos, Direction facing) {
        TileEntity te = worldIn.func_175625_s(pos.func_177972_a(facing));
        return te instanceof AggregatorTileEntity || te != null && AutomationHelper.isPowerSource(te, facing.func_176734_d());
    }
}

