/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.automation.iface;

import gigaherz.enderRift.automation.AggregatorTileEntity;
import gigaherz.enderRift.automation.AutomationHelper;
import gigaherz.enderRift.automation.iface.InterfaceBlock;
import gigaherz.enderRift.common.IPoweredAutomation;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ObjectHolder;

public class InterfaceTileEntity
extends AggregatorTileEntity
implements IPoweredAutomation {
    @ObjectHolder(value="enderrift:interface")
    public static TileEntityType<?> TYPE;
    private static final int FilterCount = 9;
    private FilterInventory filters = new FilterInventory(9);
    private ItemStackHandler outputs = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            InterfaceTileEntity.this.func_70296_d();
        }
    };
    public LazyOptional<IItemHandler> outputsProvider = LazyOptional.of(() -> this.outputs);
    private Direction facing = null;

    public InterfaceTileEntity() {
        super(TYPE);
    }

    @Nullable
    public Direction getFacing() {
        BlockState state;
        if (this.facing == null && this.field_145850_b != null && (state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_206869_a().contains(InterfaceBlock.FACING)) {
            this.facing = ((Direction)state.func_177229_b((IProperty)InterfaceBlock.FACING)).func_176734_d();
        }
        return this.facing;
    }

    public IItemHandler inventoryOutputs() {
        return this.outputs;
    }

    public IItemHandler inventoryFilter() {
        return this.filters;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (facing == this.getFacing() && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.outputsProvider.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void func_70296_d() {
        this.facing = null;
        super.func_70296_d();
    }

    @Override
    protected boolean canConnectSide(Direction side) {
        return side == this.getFacing().func_176734_d();
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.getCombinedInventory() == null) {
            return;
        }
        boolean anyChanged = false;
        for (int i = 0; i < 9; ++i) {
            int stackSize;
            ItemStack inFilter = this.filters.getStackInSlot(i);
            ItemStack inSlot = this.outputs.getStackInSlot(i);
            if (inFilter.func_190916_E() > 0) {
                int free;
                if (inSlot.func_190916_E() <= 0) {
                    free = 64;
                    inSlot = AutomationHelper.extractItems(this.getCombinedInventory(), inFilter, free, false);
                    this.outputs.setStackInSlot(i, inSlot);
                    if (inSlot.func_190916_E() <= 0) continue;
                    anyChanged = true;
                    continue;
                }
                if (ItemHandlerHelper.canItemStacksStack((ItemStack)inSlot, (ItemStack)inFilter)) {
                    ItemStack extracted;
                    free = inSlot.func_77976_d() - inSlot.func_190916_E();
                    if (free <= 0 || (extracted = AutomationHelper.extractItems(this.getCombinedInventory(), inFilter, free, false)).func_190916_E() <= 0) continue;
                    inSlot.func_190917_f(extracted.func_190916_E());
                    anyChanged = true;
                    continue;
                }
                stackSize = inSlot.func_190916_E();
                inSlot = AutomationHelper.insertItems(this.getCombinedInventory(), inSlot);
                this.outputs.setStackInSlot(i, inSlot);
                if (stackSize == inSlot.func_190916_E()) continue;
                anyChanged = true;
                continue;
            }
            if (inSlot.func_190916_E() <= 0) continue;
            stackSize = inSlot.func_190916_E();
            inSlot = AutomationHelper.insertItems(this.getCombinedInventory(), inSlot);
            this.outputs.setStackInSlot(i, inSlot);
            if (stackSize == inSlot.func_190916_E()) continue;
            anyChanged = true;
        }
        if (anyChanged) {
            this.func_70296_d();
        }
    }

    @Override
    protected void lazyDirty() {
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        ListNBT _filters = compound.func_150295_c("Filters", 10);
        for (int i = 0; i < _filters.size(); ++i) {
            CompoundNBT nbttagcompound = _filters.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.filters.getSlots()) continue;
            this.filters.setStackInSlot(j, ItemStack.func_199557_a((CompoundNBT)nbttagcompound));
        }
        ListNBT _outputs = compound.func_150295_c("Outputs", 10);
        for (int i = 0; i < _outputs.size(); ++i) {
            CompoundNBT slot = _outputs.func_150305_b(i);
            int j = slot.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.outputs.getSlots()) continue;
            this.outputs.setStackInSlot(j, ItemStack.func_199557_a((CompoundNBT)slot));
        }
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        ListNBT _filters = new ListNBT();
        for (int i = 0; i < this.filters.getSlots(); ++i) {
            ItemStack stack = this.filters.getStackInSlot(i);
            if (stack.func_190916_E() <= 0) continue;
            CompoundNBT nbttagcompound = new CompoundNBT();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(nbttagcompound);
            _filters.add((Object)nbttagcompound);
        }
        compound.func_218657_a("Filters", (INBT)_filters);
        ListNBT _outputs = new ListNBT();
        for (int i = 0; i < this.outputs.getSlots(); ++i) {
            ItemStack stack = this.outputs.getStackInSlot(i);
            if (stack.func_190916_E() <= 0) continue;
            CompoundNBT slot = new CompoundNBT();
            slot.func_74774_a("Slot", (byte)i);
            stack.func_77955_b(slot);
            _outputs.add((Object)slot);
        }
        compound.func_218657_a("Outputs", (INBT)_outputs);
        return compound;
    }

    public boolean isUseableByPlayer(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    private class FilterInventory
    implements IItemHandlerModifiable {
        final NonNullList<ItemStack> filters;

        public FilterInventory(int slotCount) {
            this.filters = NonNullList.func_191197_a((int)slotCount, (Object)ItemStack.field_190927_a);
        }

        public int getSlots() {
            return 9;
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot < 0 || slot >= this.filters.size()) {
                return ItemStack.field_190927_a;
            }
            return (ItemStack)this.filters.get(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot < 0 || slot >= this.filters.size()) {
                return stack;
            }
            if (!simulate) {
                ItemStack cp = stack.func_77946_l();
                cp.func_190920_e(1);
                this.filters.set(slot, (Object)cp);
            }
            return stack;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return true;
        }

        public void setStackInSlot(int index, ItemStack stack) {
            stack = stack.func_77946_l();
            stack.func_190920_e(1);
            this.filters.set(index, (Object)stack);
            InterfaceTileEntity.this.func_70296_d();
        }
    }
}

