/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.generator;

import gigaherz.enderRift.common.EnergyBuffer;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ObjectHolder;

public class GeneratorTileEntity
extends TileEntity
implements ITickableTileEntity {
    @ObjectHolder(value="enderrift:generator")
    public static TileEntityType<?> TYPE;
    public static final int SLOT_COUNT = 1;
    public static final int POWER_LIMIT = 100000;
    public static final int MIN_HEAT = 100;
    public static final int MAX_HEAT = 1000;
    public static final int POWERGEN_MIN = 20;
    public static final int POWERGEN_MAX = 200;
    public static final int HEAT_INTERVAL = 20;
    public static final int POWER_TRANSFER_MAX = 800;
    private final EnergyBuffer energyBuffer = new EnergyBuffer(100000);
    private final LazyOptional<EnergyBuffer> energyBufferGetter = LazyOptional.of(() -> this.energyBuffer);
    private final ItemStackHandler fuelSlot = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            GeneratorTileEntity.this.func_70296_d();
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (GeneratorTileEntity.this.getBurnTime(stack) <= 0) {
                return stack;
            }
            int[] x = new int[]{1, 2, 3, 4};
            return super.insertItem(slot, stack, simulate);
        }
    };
    public LazyOptional<IItemHandler> fuelSlotProvider = LazyOptional.of(() -> this.fuelSlot);
    public int heatLevel;
    public int burnTimeRemaining;
    public int currentItemBurnTime;
    public int timeInterval;

    public GeneratorTileEntity() {
        super(TYPE);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return this.energyBufferGetter.cast();
        }
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.fuelSlotProvider.cast();
        }
        return super.getCapability(cap, side);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        boolean anyChanged = this.updateGeneration();
        if (anyChanged |= this.transferPower()) {
            this.func_70296_d();
        }
    }

    private boolean updateGeneration() {
        ItemStack stack;
        boolean anyChanged = false;
        int minHeatLevel = 0;
        int heatInterval = 20;
        if (this.field_145850_b.func_180495_p(this.field_174879_c.func_177977_b()).func_177230_c() == Blocks.field_150353_l && this.heatLevel < (minHeatLevel = 99)) {
            heatInterval = Math.max(1, heatInterval / 2);
        }
        if (this.timeInterval < 20) {
            ++this.timeInterval;
        }
        if (this.burnTimeRemaining > 0) {
            this.burnTimeRemaining -= Math.max(1, this.heatLevel / 100);
            if (this.burnTimeRemaining <= 0) {
                this.timeInterval = 0;
            }
            if (this.timeInterval >= heatInterval && this.heatLevel < 1000) {
                this.timeInterval = 0;
                ++this.heatLevel;
                anyChanged = true;
            }
        } else if (this.heatLevel > minHeatLevel) {
            if (this.timeInterval >= 20) {
                this.timeInterval = 0;
                --this.heatLevel;
                anyChanged = true;
            }
        } else if (minHeatLevel > 0 && this.heatLevel < minHeatLevel && this.timeInterval >= 20) {
            this.timeInterval = 0;
            ++this.heatLevel;
            anyChanged = true;
        }
        if (this.heatLevel >= 100 && this.energyBuffer.getEnergyStored() < 100000) {
            int powerGen = this.getGenerationPower();
            this.energyBuffer.setEnergy(Math.min(this.energyBuffer.getEnergyStored() + powerGen, 100000));
            anyChanged = true;
        }
        if (this.burnTimeRemaining <= 0 && this.energyBuffer.getEnergyStored() < 100000 && (stack = this.fuelSlot.getStackInSlot(0)).func_190916_E() > 0) {
            this.currentItemBurnTime = this.burnTimeRemaining = this.getBurnTime(this.fuelSlot.getStackInSlot(0));
            this.timeInterval = 0;
            stack.func_190918_g(1);
            if (stack.func_190916_E() <= 0) {
                this.fuelSlot.setStackInSlot(0, stack.func_77973_b().getContainerItem(stack));
            }
            anyChanged = true;
        }
        return anyChanged;
    }

    private boolean transferPower() {
        boolean anyChanged = false;
        int sendPower = Math.min(800, this.energyBuffer.getEnergyStored());
        if (sendPower > 0) {
            IEnergyStorage[] handlers = new IEnergyStorage[6];
            int[] wantedSide = new int[6];
            int accepted = 0;
            for (Direction neighbor : Direction.values()) {
                int wanted;
                TileEntity e = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(neighbor));
                Direction from = neighbor.func_176734_d();
                if (e == null) continue;
                IEnergyStorage handler = null;
                LazyOptional opt = e.getCapability(CapabilityEnergy.ENERGY, from);
                if (opt.isPresent() && !(handler = (IEnergyStorage)opt.orElse(null)).canReceive()) {
                    handler = null;
                }
                if (handler == null) continue;
                handlers[from.ordinal()] = handler;
                wantedSide[from.ordinal()] = wanted = handler.receiveEnergy(sendPower, true);
                accepted += wanted;
            }
            if (accepted > 0) {
                for (Direction from : Direction.values()) {
                    IEnergyStorage handler = handlers[from.ordinal()];
                    int wanted = wantedSide[from.ordinal()];
                    if (handler == null || wanted == 0) continue;
                    int given = Math.min(Math.min(this.energyBuffer.getEnergyStored(), wanted), wanted * accepted / sendPower);
                    int received = Math.min(given, handler.receiveEnergy(given, false));
                    this.energyBuffer.setEnergy(this.energyBuffer.getEnergyStored() - received);
                    if (this.energyBuffer.getEnergyStored() <= 0) break;
                }
                anyChanged = true;
            }
        }
        return anyChanged;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.heatLevel = compound.func_74762_e("heatLevel");
        this.burnTimeRemaining = compound.func_74762_e("burnTimeRemaining");
        this.currentItemBurnTime = compound.func_74762_e("currentItemBurnTime");
        this.timeInterval = compound.func_74762_e("timeInterval");
        CapabilityEnergy.ENERGY.readNBT((Object)this.energyBuffer, null, compound.func_74781_a("storedEnergy"));
        CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.fuelSlot, null, compound.func_74781_a("fuelSlot"));
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        compound.func_74768_a("heatLevel", this.heatLevel);
        compound.func_74768_a("burnTimeRemaining", this.burnTimeRemaining);
        compound.func_74768_a("currentItemBurnTime", this.currentItemBurnTime);
        compound.func_74768_a("timeInterval", this.timeInterval);
        compound.func_218657_a("storedEnergy", CapabilityEnergy.ENERGY.writeNBT((Object)this.energyBuffer, null));
        compound.func_218657_a("fuelSlot", CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.fuelSlot, null));
        return compound;
    }

    public void handleUpdateTag(CompoundNBT tag) {
        super.func_145839_a(tag);
    }

    public boolean isUseableByPlayer(PlayerEntity player) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public int[] getFields() {
        return new int[]{this.burnTimeRemaining, this.currentItemBurnTime, this.energyBuffer.getEnergyStored(), this.heatLevel};
    }

    public void setFields(int[] values) {
        this.burnTimeRemaining = values[0];
        this.currentItemBurnTime = values[1];
        this.energyBuffer.setEnergy(values[2]);
        this.heatLevel = values[3];
    }

    public boolean isBurning() {
        return this.burnTimeRemaining > 0;
    }

    public int getHeatValue() {
        return this.heatLevel;
    }

    public int getGenerationPower() {
        if (this.heatLevel < 100) {
            return 0;
        }
        return Math.max(0, Math.round(20.0f + (float)(180 * (this.heatLevel - 100)) / 900.0f));
    }

    public int getContainedEnergy() {
        return this.energyBuffer.getEnergyStored();
    }

    public IItemHandler inventory() {
        return this.fuelSlot;
    }

    public int getCurrentItemBurnTime() {
        return this.currentItemBurnTime;
    }

    public int getBurnTimeRemaining() {
        return this.burnTimeRemaining;
    }

    public int getBurnTime(ItemStack itemStack) {
        return ForgeHooks.getBurnTime((ItemStack)itemStack);
    }
}

