/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.network;

import com.google.common.collect.Lists;
import gigaherz.enderRift.client.ClientHelper;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.fml.network.NetworkEvent;

public class SendSlotChanges {
    public int windowId;
    public int slotCount;
    public List<Integer> indices;
    public List<ItemStack> stacks;

    public SendSlotChanges(int windowId, int slotCount, List<Integer> indices, List<ItemStack> stacks) {
        this.windowId = windowId;
        this.slotCount = slotCount;
        this.indices = indices;
        this.stacks = stacks;
    }

    public SendSlotChanges(PacketBuffer buf) {
        this.indices = Lists.newArrayList();
        this.stacks = Lists.newArrayList();
        this.windowId = buf.readInt();
        this.slotCount = buf.readInt();
        int count = buf.readInt();
        while (count-- > 0) {
            this.indices.add(buf.readInt());
            this.stacks.add(SendSlotChanges.readLargeItemStack(buf));
        }
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.windowId);
        buf.writeInt(this.slotCount);
        buf.writeInt(this.indices.size());
        for (int i = 0; i < this.indices.size(); ++i) {
            buf.writeInt(this.indices.get(i).intValue());
            SendSlotChanges.writeLargeItemStack(buf, this.stacks.get(i));
        }
    }

    public boolean handle(Supplier<NetworkEvent.Context> context) {
        ClientHelper.handleSendSlotChanges(this);
        return true;
    }

    public static ItemStack readLargeItemStack(PacketBuffer buf) {
        ItemStack itemstack = ItemStack.field_190927_a;
        int itemId = buf.func_150792_a();
        if (itemId >= 0) {
            int count = buf.func_150792_a();
            itemstack = new ItemStack((IItemProvider)Item.func_150899_d((int)itemId), count);
            itemstack.readShareTag(buf.func_150793_b());
        }
        return itemstack;
    }

    public static void writeLargeItemStack(PacketBuffer buf, ItemStack stack) {
        if (stack.func_190916_E() <= 0) {
            buf.func_150787_b(-1);
        } else {
            buf.func_150787_b(Item.func_150891_b((Item)stack.func_77973_b()));
            buf.func_150787_b(stack.func_190916_E());
            CompoundNBT nbttagcompound = null;
            if (stack.func_77984_f() || stack.func_77973_b().func_77651_p()) {
                nbttagcompound = stack.getShareTag();
            }
            buf.func_150786_a(nbttagcompound);
        }
    }
}

