/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.rift;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.rift.RiftBlock;
import gigaherz.enderRift.rift.RiftTileEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.state.IProperty;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class RiftTileEntityRenderer
extends TileEntityRenderer<RiftTileEntity> {
    private final RenderType renderType = RenderType.func_228645_f_();
    private final Random random = new Random();
    private static final List<Direction> DIRECTIONS_AND_NULL = Lists.newArrayList((Object[])Direction.values());

    public RiftTileEntityRenderer(TileEntityRendererDispatcher dispatcher) {
        super(dispatcher);
        DIRECTIONS_AND_NULL.add(null);
    }

    public void render(RiftTileEntity te, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer iRenderTypeBuffer, int combinedLightIn, int combinedOverlayIn) {
        if (!((Boolean)te.func_195044_w().func_177229_b((IProperty)RiftBlock.ASSEMBLED)).booleanValue()) {
            return;
        }
        float lastPoweringState = te.getLastPoweringState();
        float nextPoweringState = te.getPoweringState();
        float poweringState = this.lerp(lastPoweringState, nextPoweringState, partialTicks);
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        Vec3d eyePosition = player.func_174824_e(partialTicks);
        BlockPos tePos = te.func_174877_v();
        double ty = eyePosition.func_82617_b() - ((double)tePos.func_177956_o() + 0.5);
        double tx = eyePosition.func_82615_a() - ((double)tePos.func_177958_n() + 0.5);
        double tz = eyePosition.func_82616_c() - ((double)tePos.func_177952_p() + 0.5);
        float yaw = (float)Math.atan2(tz, tx);
        float xz = (float)Math.sqrt(tx * tx + tz * tz);
        float pitch = (float)Math.atan2(ty, xz);
        matrixStack.func_227860_a_();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_(-yaw));
        matrixStack.func_227863_a_(Vector3f.field_229183_f_.func_229193_c_(pitch));
        matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
        int step_time = 20;
        int steps = 5;
        int time_loop = step_time * steps;
        long time = te.func_145831_w().func_82737_E();
        int tm = (int)(time % (long)step_time);
        float c0 = 1.0f / (float)steps;
        float c1 = 1.0f / (1.0f - c0);
        IVertexBuilder buffer = iRenderTypeBuffer.getBuffer(this.renderType);
        IBakedModel model = Minecraft.func_71410_x().func_209506_al().getModel(EnderRiftMod.location("block/sphere"));
        for (int i = 0; i < steps; ++i) {
            float progress0 = ((float)((tm + i * step_time) % time_loop) + partialTicks) / (float)time_loop;
            float progress1 = (progress0 - c0) * c1;
            float scale = 1.0f + poweringState + (0.6f + poweringState) * progress0;
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.5, 0.5, 0.5);
            matrixStack.func_227862_a_(scale, scale, scale);
            matrixStack.func_227861_a_(-0.5, -0.5, -0.5);
            float a = MathHelper.func_76131_a((float)(1.0f - progress1), (float)0.0f, (float)1.0f);
            float rgb = MathHelper.func_76131_a((float)progress1, (float)0.0f, (float)1.0f);
            for (Direction d : DIRECTIONS_AND_NULL) {
                for (BakedQuad quad : model.getQuads(null, d, this.random, (IModelData)EmptyModelData.INSTANCE)) {
                    buffer.addVertexData(matrixStack.func_227866_c_(), quad, rgb, rgb, rgb, a, 0xF000F0, OverlayTexture.field_229196_a_, true);
                }
            }
            matrixStack.func_227865_b_();
        }
        matrixStack.func_227865_b_();
    }

    private float lerp(float a, float b, float p) {
        return a + p * (b - a);
    }
}

