/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.enderRift.rift;

import gigaherz.enderRift.EnderRiftMod;
import gigaherz.enderRift.automation.AggregatorTileEntity;
import gigaherz.enderRift.rift.RiftTileEntity;
import gigaherz.enderRift.rift.StructureBlock;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.registries.ObjectHolder;

public class StructureTileEntity
extends AggregatorTileEntity {
    @ObjectHolder(value="enderrift:structure")
    public static TileEntityType<?> TYPE;
    RiftTileEntity energyParent;
    LazyOptional<IEnergyStorage> bufferProvider = LazyOptional.of(() -> this.getEnergyBuffer().orElse(null));

    public StructureTileEntity() {
        super(TYPE);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return this.bufferProvider.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public Optional<IEnergyStorage> getEnergyBuffer() {
        return this.getInternalBuffer();
    }

    @Override
    public Optional<IEnergyStorage> getInternalBuffer() {
        return this.getParent().flatMap(RiftTileEntity::getEnergyBuffer);
    }

    @Override
    protected void lazyDirty() {
    }

    @Override
    protected boolean canConnectSide(Direction side) {
        return false;
    }

    public Optional<RiftTileEntity> getParent() {
        if (this.energyParent == null) {
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() != EnderRiftMod.EnderRiftBlocks.STRUCTURE) {
                return Optional.empty();
            }
            TileEntity te = this.field_145850_b.func_175625_s(StructureTileEntity.getRiftFromCorner(state, this.field_174879_c));
            if (te instanceof RiftTileEntity) {
                this.energyParent = (RiftTileEntity)te;
            } else {
                return Optional.empty();
            }
        }
        return Optional.of(this.energyParent);
    }

    private static BlockPos getRiftFromCorner(BlockState state, BlockPos pos) {
        boolean base = (Boolean)state.func_177229_b((IProperty)StructureBlock.BASE);
        StructureBlock.Corner corner = (StructureBlock.Corner)((Object)state.func_177229_b(StructureBlock.CORNER));
        int xParent = pos.func_177958_n();
        int yParent = pos.func_177956_o() + (base ? 1 : -1);
        int zParent = pos.func_177952_p();
        switch (corner) {
            case NE: {
                --xParent;
                ++zParent;
                break;
            }
            case NW: {
                ++xParent;
                ++zParent;
                break;
            }
            case SE: {
                --xParent;
                --zParent;
                break;
            }
            case SW: {
                ++xParent;
                --zParent;
            }
        }
        return new BlockPos(xParent, yParent, zParent);
    }
}

