/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.logging.log4j.Logger;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.blocks.BlockDecorChair;
import wile.engineersdecor.blocks.BlockDecorCraftingTable;
import wile.engineersdecor.blocks.BlockDecorDropper;
import wile.engineersdecor.blocks.BlockDecorFurnace;
import wile.engineersdecor.blocks.BlockDecorFurnaceElectrical;
import wile.engineersdecor.blocks.BlockDecorHopper;
import wile.engineersdecor.blocks.BlockDecorLabeledCrate;
import wile.engineersdecor.blocks.BlockDecorLadder;
import wile.engineersdecor.blocks.BlockDecorPlacer;
import wile.engineersdecor.blocks.BlockDecorWasteIncinerator;
import wile.engineersdecor.detail.BlockCategories;
import wile.engineersdecor.detail.ExtItems;
import wile.engineersdecor.detail.ModConfig;
import wile.engineersdecor.detail.ModRecipes;
import wile.engineersdecor.detail.Networking;
import wile.engineersdecor.detail.RecipeCondModSpecific;
import wile.engineersdecor.detail.TreeCutting;

@Mod(modid="engineersdecor", name="Engineer's Decor", version="1.1.0-b2", dependencies="required-after:forge@[14.23.5.2768,);before:immersiveengineering", useMetadata=true, updateJSON="https://raw.githubusercontent.com/stfwi/engineers-decor/develop/meta/update.json", certificateFingerprint="ed58ed655893ced6280650866985abcae2bf7559", acceptedMinecraftVersions="[1.12.2]")
public class ModEngineersDecor {
    public static final String MODID = "engineersdecor";
    public static final String MODNAME = "Engineer's Decor";
    public static final String MODVERSION = "1.1.0-b2";
    public static final String MODMCVERSION = "1.12.2";
    public static final String MODFINGERPRINT = "ed58ed655893ced6280650866985abcae2bf7559";
    public static final String MODBUILDID = "#e8f32e2";
    public static Logger logger;
    @Mod.Instance
    public static ModEngineersDecor instance;
    @SidedProxy(clientSide="wile.engineersdecor.detail.ClientProxy", serverSide="wile.engineersdecor.detail.ServerProxy")
    public static IProxy proxy;
    public static final CreativeTabs CREATIVE_TAB_ENGINEERSDECOR;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        logger.info("Engineer's Decor: Version 1.12.2-1.1.0-b2 #e8f32e2.");
        logger.info("Engineer's Decor: Found valid fingerprint ed58ed655893ced6280650866985abcae2bf7559.");
        proxy.preInit(event);
        MinecraftForge.EVENT_BUS.register((Object)new PlayerEventHandler());
        Networking.init();
        ModConfig.onPreInit();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MODID, "chair_entity"), BlockDecorChair.EntityChair.class, (String)"DecorChair", (int)0, (Object)this, (int)80, (int)1, (boolean)false);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ModConfig.onPostInit(event);
        proxy.postInit(event);
        if (RecipeCondModSpecific.num_skipped > 0) {
            logger.info("Excluded " + RecipeCondModSpecific.num_skipped + " recipes due to config opt-out.");
        }
        if (ModConfig.zmisc.with_experimental) {
            logger.info("Included experimental features due to mod config.");
        }
        ExtItems.onPostInit();
        BlockCategories.reload();
        TreeCutting.reload();
    }

    static {
        CREATIVE_TAB_ENGINEERSDECOR = new CreativeTabs("tabengineersdecor"){

            @SideOnly(value=Side.CLIENT)
            @Nonnull
            public ItemStack func_78016_d() {
                return new ItemStack((Block)ModContent.SIGN_MODLOGO);
            }
        };
    }

    @Mod.EventBusSubscriber
    public static class PlayerEventHandler {
        @SubscribeEvent
        public void update(LivingEvent.LivingUpdateEvent event) {
            if (!(event.getEntity() instanceof EntityPlayer)) {
                return;
            }
            EntityPlayer player = (EntityPlayer)event.getEntity();
            if (player.field_70170_p == null) {
                return;
            }
            if (player.func_70617_f_()) {
                BlockDecorLadder.onPlayerUpdateEvent(player);
            }
        }
    }

    public static final class GuiHandler
    implements IGuiHandler {
        public static final int GUIID_CRAFTING_TABLE = 213101;
        public static final int GUIID_SMALL_LAB_FURNACE = 213102;
        public static final int GUIID_ELECTRICAL_LAB_FURNACE = 213103;
        public static final int GUIID_SMALL_WASTE_INCINERATOR = 213104;
        public static final int GUIID_FACTORY_DROPPER = 213105;
        public static final int GUIID_FACTORY_HOPPER = 213106;
        public static final int GUIID_FACTORY_PLACER = 213107;
        public static final int GUIID_LABELED_CRATE = 213108;

        public Object getServerGuiElement(int guiid, EntityPlayer player, World world, int x, int y, int z) {
            BlockPos pos = new BlockPos(x, y, z);
            TileEntity te = world.func_175625_s(pos);
            switch (guiid) {
                case 213101: {
                    return BlockDecorCraftingTable.getServerGuiElement(player, world, pos, te);
                }
                case 213102: {
                    return BlockDecorFurnace.getServerGuiElement(player, world, pos, te);
                }
                case 213103: {
                    return BlockDecorFurnaceElectrical.getServerGuiElement(player, world, pos, te);
                }
                case 213104: {
                    return BlockDecorWasteIncinerator.getServerGuiElement(player, world, pos, te);
                }
                case 213105: {
                    return BlockDecorDropper.getServerGuiElement(player, world, pos, te);
                }
                case 213106: {
                    return BlockDecorHopper.getServerGuiElement(player, world, pos, te);
                }
                case 213107: {
                    return BlockDecorPlacer.getServerGuiElement(player, world, pos, te);
                }
                case 213108: {
                    return BlockDecorLabeledCrate.getServerGuiElement(player, world, pos, te);
                }
            }
            return null;
        }

        @SideOnly(value=Side.CLIENT)
        public Object getClientGuiElement(int guiid, EntityPlayer player, World world, int x, int y, int z) {
            BlockPos pos = new BlockPos(x, y, z);
            TileEntity te = world instanceof WorldClient ? world.func_175625_s(pos) : null;
            switch (guiid) {
                case 213101: {
                    return BlockDecorCraftingTable.getClientGuiElement(player, world, pos, te);
                }
                case 213102: {
                    return BlockDecorFurnace.getClientGuiElement(player, world, pos, te);
                }
                case 213103: {
                    return BlockDecorFurnaceElectrical.getClientGuiElement(player, world, pos, te);
                }
                case 213104: {
                    return BlockDecorWasteIncinerator.getClientGuiElement(player, world, pos, te);
                }
                case 213105: {
                    return BlockDecorDropper.getClientGuiElement(player, world, pos, te);
                }
                case 213106: {
                    return BlockDecorHopper.getClientGuiElement(player, world, pos, te);
                }
                case 213107: {
                    return BlockDecorPlacer.getClientGuiElement(player, world, pos, te);
                }
                case 213108: {
                    return BlockDecorLabeledCrate.getClientGuiElement(player, world, pos, te);
                }
            }
            return null;
        }
    }

    @Mod.EventBusSubscriber
    public static final class RegistrationSubscriptions {
        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            ModContent.registerBlocks(event);
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            ModContent.registerItemBlocks(event);
            ModContent.registerItems(event);
        }

        @SubscribeEvent
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            ModRecipes.registerRecipes(event);
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public static void registerModels(ModelRegistryEvent event) {
            ModContent.initModels();
        }
    }

    public static interface IProxy {
        default public void preInit(FMLPreInitializationEvent e) {
        }

        default public void init(FMLInitializationEvent e) {
        }

        default public void postInit(FMLPostInitializationEvent e) {
        }

        default public World getWorlClientSide() {
            return null;
        }

        default public EntityPlayer getPlayerClientSide() {
            return null;
        }
    }
}

