/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.EnumPushReaction;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.detail.ModAuxiliaries;

public class BlockDecor
extends Block {
    public final long config;
    public static final long CFG_DEFAULT = 0L;
    public static final long CFG_CUTOUT = 1L;
    public static final long CFG_HORIZIONTAL = 2L;
    public static final long CFG_LOOK_PLACEMENT = 4L;
    public static final long CFG_FACING_PLACEMENT = 8L;
    public static final long CFG_OPPOSITE_PLACEMENT = 16L;
    public static final long CFG_FLIP_PLACEMENT_IF_SAME = 32L;
    public static final long CFG_FLIP_PLACEMENT_SHIFTCLICK = 64L;
    public static final long CFG_TRANSLUCENT = 128L;
    public static final long CFG_LIGHT_VALUE_MASK = 3840L;
    public static final long CFG_LIGHT_VALUE_SHIFT = 8L;
    public static final long CFG_ELECTRICAL = 65536L;
    public static final long CFG_REDSTONE_CONTROLLED = 131072L;
    public static final long CFG_ANALOG = 262144L;
    public static final long CFG_HARD_IE_DEPENDENT = Long.MIN_VALUE;
    protected final AxisAlignedBB[] aabb;

    public BlockDecor(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound) {
        this(registryName, config, material, hardness, resistance, sound, new AxisAlignedBB[]{field_185505_j});
    }

    public BlockDecor(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound, @Nullable AxisAlignedBB boundingbox) {
        AxisAlignedBB[] axisAlignedBBArray;
        if (boundingbox == null) {
            AxisAlignedBB[] axisAlignedBBArray2 = new AxisAlignedBB[1];
            axisAlignedBBArray = axisAlignedBBArray2;
            axisAlignedBBArray2[0] = field_185505_j;
        } else {
            AxisAlignedBB[] axisAlignedBBArray3 = new AxisAlignedBB[1];
            axisAlignedBBArray = axisAlignedBBArray3;
            axisAlignedBBArray3[0] = boundingbox;
        }
        this(registryName, config, material, hardness, resistance, sound, axisAlignedBBArray);
    }

    public BlockDecor(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound, @Nonnull AxisAlignedBB[] boundingboxes) {
        super(material != null ? material : Material.field_151573_f);
        this.func_149647_a(ModEngineersDecor.CREATIVE_TAB_ENGINEERSDECOR);
        this.setRegistryName("engineersdecor", registryName);
        this.func_149663_c("engineersdecor." + registryName);
        this.func_149675_a(false);
        this.func_149711_c(hardness > 0.0f ? hardness : 5.0f);
        this.func_149752_b(resistance > 0.0f ? resistance : 10.0f);
        this.func_149672_a(sound == null ? SoundType.field_185851_d : sound);
        if ((config & 0x81L) != 0L) {
            this.func_149713_g(0);
        }
        if ((config & 0x80L) != 0L) {
            this.field_149785_s = true;
        }
        this.config = config;
        this.aabb = boundingboxes;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        ModAuxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return (this.config & 1L) != 0L ? BlockRenderLayer.CUTOUT : ((this.config & 0x80L) != 0L ? BlockRenderLayer.TRANSLUCENT : BlockRenderLayer.SOLID);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.SOLID;
    }

    public boolean func_149686_d(IBlockState state) {
        return (this.config & 1L) == 0L;
    }

    public boolean func_149721_r(IBlockState state) {
        return (this.config & 0x81L) == 0L;
    }

    public boolean func_149662_c(IBlockState state) {
        return (this.config & 0x81L) == 0L;
    }

    public boolean func_181623_g() {
        return false;
    }

    public boolean canHarvestBlock(IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return true;
    }

    public EnumPushReaction func_149656_h(IBlockState state) {
        return EnumPushReaction.NORMAL;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P();
    }

    public int func_176201_c(IBlockState state) {
        return 0;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[0]);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state;
    }

    public IBlockState func_185499_a(IBlockState state, Rotation rot) {
        return state;
    }

    public IBlockState func_185471_a(IBlockState state, Mirror mirrorIn) {
        return state;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return this.func_185496_a(state, world, pos);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return this.aabb[0];
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return state.func_185900_c((IBlockAccess)world, pos).func_186670_a(pos);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean isActualState) {
        BlockDecor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.func_185496_a(state, (IBlockAccess)world, pos));
        for (int i = 1; i < this.aabb.length; ++i) {
            BlockDecor.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)this.aabb[i]);
        }
    }

    public boolean hasTileEntity(IBlockState state) {
        return false;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
    }
}

