/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotFurnaceFuel;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.BlockDecorDirected;
import wile.engineersdecor.detail.ExtItems;

public class BlockDecorFurnace
extends BlockDecorDirected {
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");

    public BlockDecorFurnace(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound, @Nonnull AxisAlignedBB unrotatedAABB) {
        super(registryName, config, material, hardness, resistance, sound, unrotatedAABB);
        this.func_149713_g(0);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, LIT});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() & 3 | ((Boolean)state.func_177229_b((IProperty)LIT) != false ? 4 : 0);
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(false));
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BTileEntity();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (world.field_72995_K) {
            return;
        }
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("inventory")) {
            return;
        }
        NBTTagCompound inventory_nbt = stack.func_77978_p().func_74775_l("inventory");
        if (inventory_nbt.func_82582_d()) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        ((BTileEntity)te).readnbt(inventory_nbt);
        ((BTileEntity)te).func_70296_d();
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return super.removedByPlayer(state, world, pos, player, willHarvest);
        }
        ItemStack stack = new ItemStack((Block)this, 1);
        NBTTagCompound inventory_nbt = new NBTTagCompound();
        ItemStackHelper.func_191281_a((NBTTagCompound)inventory_nbt, ((BTileEntity)te).stacks_, (boolean)false);
        if (!inventory_nbt.func_82582_d()) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74782_a("inventory", (NBTBase)inventory_nbt);
            stack.func_77982_d(nbt);
        }
        world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, stack));
        world.func_175698_g(pos);
        world.func_175713_t(pos);
        return false;
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        if (world.field_72995_K) {
            return;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return;
        }
        for (ItemStack stack : ((BTileEntity)te).stacks_) {
            if (stack.func_190926_b()) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack));
        }
        ((BTileEntity)te).reset();
        super.onBlockExploded(world, pos, explosion);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        player.openGui((Object)ModEngineersDecor.instance, 213102, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        player.func_71029_a(StatList.field_188061_aa);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rnd) {
        if (state.func_177230_c() != this || !((Boolean)state.func_177229_b((IProperty)LIT)).booleanValue()) {
            return;
        }
        double rv = rnd.nextDouble();
        if (rv > 0.5) {
            return;
        }
        double x = 0.5 + (double)pos.func_177958_n();
        double y = 0.5 + (double)pos.func_177956_o();
        double z = 0.5 + (double)pos.func_177952_p();
        double xc = 0.52;
        double xr = rnd.nextDouble() * 0.4 - 0.2;
        double yr = y - 0.3 + rnd.nextDouble() * 0.2;
        if (rv < 0.1) {
            world.func_184134_a(x, y, z, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 0.4f, 0.5f, false);
        }
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case WEST: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x - 0.52, yr, z + xr, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case EAST: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + 0.52, yr, z + xr, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case NORTH: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + xr, yr, z - 0.52, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            default: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + xr, yr, z + 0.52, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public static Object getServerGuiElement(EntityPlayer player, World world, BlockPos pos, TileEntity te) {
        return te instanceof BTileEntity ? new BContainer(player.field_71071_by, world, pos, (BTileEntity)te) : null;
    }

    public static Object getClientGuiElement(EntityPlayer player, World world, BlockPos pos, TileEntity te) {
        return te instanceof BTileEntity ? new BGui(player.field_71071_by, world, pos, (BTileEntity)te) : null;
    }

    public static class BRecipes {
        private static final BRecipes RECIPPE_OVERRIDES = new BRecipes();
        private final Map<ItemStack, ItemStack> recipes_ = Maps.newHashMap();
        private final Map<ItemStack, Float> experiences_ = Maps.newHashMap();

        public static BRecipes instance() {
            return RECIPPE_OVERRIDES;
        }

        private BRecipes() {
        }

        public Map<ItemStack, ItemStack> getRecipes() {
            return this.recipes_;
        }

        public void reset() {
            this.recipes_.clear();
            this.experiences_.clear();
        }

        public ItemStack getSmeltingResult(ItemStack stack) {
            ItemStack res = this.override_result(stack);
            if (res.func_190926_b()) {
                res = FurnaceRecipes.func_77602_a().func_151395_a(stack);
            }
            return res;
        }

        public float getSmeltingExperience(ItemStack stack) {
            float ret = stack.func_77973_b().getSmeltingExperience(stack);
            if (ret != -1.0f) {
                return ret;
            }
            for (Map.Entry<ItemStack, Float> e : this.experiences_.entrySet()) {
                if (!this.compare(stack, e.getKey())) continue;
                return e.getValue().floatValue();
            }
            return FurnaceRecipes.func_77602_a().func_151398_b(stack);
        }

        public void add(Block input, ItemStack stack, float experience) {
            this.add(Item.func_150898_a((Block)input), stack, experience);
        }

        public void add(Item input, ItemStack stack, float experience) {
            this.add(new ItemStack(input, 1, Short.MAX_VALUE), stack, experience);
        }

        public void add(ItemStack input, ItemStack stack, float xp) {
            if (input == ItemStack.field_190927_a) {
                return;
            }
            if (this.recipes_.containsKey(input)) {
                this.recipes_.remove(input);
            }
            if (this.experiences_.containsKey(input)) {
                this.experiences_.remove(input);
            }
            if (stack == null || stack == ItemStack.field_190927_a) {
                return;
            }
            this.recipes_.put(input, stack);
            this.experiences_.put(stack, Float.valueOf(xp));
        }

        public ItemStack override_result(ItemStack stack) {
            for (Map.Entry<ItemStack, ItemStack> e : this.recipes_.entrySet()) {
                if (!this.compare(stack, e.getKey())) continue;
                return e.getValue();
            }
            return ItemStack.field_190927_a;
        }

        private boolean compare(ItemStack stack1, ItemStack stack2) {
            return stack2.func_77973_b() == stack1.func_77973_b() && (stack2.func_77960_j() == Short.MAX_VALUE || stack2.func_77960_j() == stack1.func_77960_j());
        }
    }

    public static class BTileEntity
    extends TileEntity
    implements ITickable,
    ISidedInventory,
    IEnergyStorage {
        public static final int TICK_INTERVAL = 4;
        public static final int FIFO_INTERVAL = 20;
        public static final int MAX_BURNTIME = Short.MAX_VALUE;
        public static final int DEFAULT_BOOST_ENERGY = 32;
        public static final int VANILLA_FURNACE_SPEED_INTERVAL = 200;
        public static final int DEFAULT_SPEED_INTERVAL = 150;
        public static final int NUM_OF_SLOTS = 11;
        public static final int SMELTING_INPUT_SLOT_NO = 0;
        public static final int SMELTING_FUEL_SLOT_NO = 1;
        public static final int SMELTING_OUTPUT_SLOT_NO = 2;
        public static final int FIFO_INPUT_0_SLOT_NO = 3;
        public static final int FIFO_INPUT_1_SLOT_NO = 4;
        public static final int FIFO_FUEL_0_SLOT_NO = 5;
        public static final int FIFO_FUEL_1_SLOT_NO = 6;
        public static final int FIFO_OUTPUT_0_SLOT_NO = 7;
        public static final int FIFO_OUTPUT_1_SLOT_NO = 8;
        public static final int AUX_0_SLOT_NO = 9;
        public static final int AUX_1_SLOT_NO = 10;
        private static double proc_fuel_efficiency_ = 1.0;
        private static int proc_speed_interval_ = 150;
        private static int boost_energy_consumption = 128;
        private int tick_timer_;
        private int fifo_timer_;
        private int burntime_left_;
        private int fuel_burntime_;
        private int proc_time_elapsed_;
        private int proc_time_needed_;
        private int boost_energy_;
        private boolean heater_inserted_ = false;
        protected ItemStack current_smelting_input_stack_ = ItemStack.field_190927_a;
        protected NonNullList<ItemStack> stacks_;
        private static final int[] SLOTS_TOP = new int[]{4};
        private static final int[] SLOTS_BOTTOM = new int[]{8};
        private static final int[] SLOTS_SIDES = new int[]{6};
        private final IItemHandler sided_itemhandler_top_ = new SidedInvWrapper((ISidedInventory)this, EnumFacing.UP);
        private final IItemHandler sided_itemhandler_down_ = new SidedInvWrapper((ISidedInventory)this, EnumFacing.DOWN);
        private final IItemHandler sided_itemhandler_sides_ = new SidedInvWrapper((ISidedInventory)this, EnumFacing.WEST);

        public static void on_config(int speed_percent, int fuel_efficiency_percent, int boost_energy_per_tick) {
            double ratio = 100.0 / (double)MathHelper.func_76125_a((int)speed_percent, (int)10, (int)500);
            proc_speed_interval_ = MathHelper.func_76125_a((int)((int)(ratio * 200.0)), (int)20, (int)400);
            proc_fuel_efficiency_ = (double)MathHelper.func_76125_a((int)fuel_efficiency_percent, (int)10, (int)500) / 100.0;
            boost_energy_consumption = 4 * MathHelper.func_76125_a((int)boost_energy_per_tick, (int)16, (int)512);
            ModEngineersDecor.logger.info("Config lab furnace interval:" + proc_speed_interval_ + ", efficiency:" + proc_fuel_efficiency_);
        }

        public BTileEntity() {
            this.reset();
        }

        protected void reset() {
            this.stacks_ = NonNullList.func_191197_a((int)11, (Object)ItemStack.field_190927_a);
            this.current_smelting_input_stack_ = ItemStack.field_190927_a;
            this.proc_time_elapsed_ = 0;
            this.proc_time_needed_ = 0;
            this.burntime_left_ = 0;
            this.fuel_burntime_ = -1;
            this.fifo_timer_ = 0;
            this.tick_timer_ = 0;
        }

        public void readnbt(NBTTagCompound compound) {
            this.reset();
            ItemStackHelper.func_191283_b((NBTTagCompound)compound, this.stacks_);
            while (this.stacks_.size() < 11) {
                this.stacks_.add((Object)ItemStack.field_190927_a);
            }
            this.burntime_left_ = compound.func_74762_e("BurnTime");
            this.proc_time_needed_ = MathHelper.func_76125_a((int)compound.func_74762_e("CookTimeTotal"), (int)10, (int)65535);
            this.proc_time_elapsed_ = MathHelper.func_76125_a((int)compound.func_74762_e("CookTime"), (int)0, (int)this.proc_time_needed_);
            this.fuel_burntime_ = compound.func_74762_e("FuelBurnTime");
        }

        protected void writenbt(NBTTagCompound compound) {
            compound.func_74768_a("BurnTime", MathHelper.func_76125_a((int)this.burntime_left_, (int)0, (int)Short.MAX_VALUE));
            compound.func_74768_a("CookTime", MathHelper.func_76125_a((int)this.proc_time_elapsed_, (int)0, (int)Short.MAX_VALUE));
            compound.func_74768_a("CookTimeTotal", MathHelper.func_76125_a((int)this.proc_time_needed_, (int)10, (int)Short.MAX_VALUE));
            compound.func_74768_a("FuelBurnTime", MathHelper.func_76125_a((int)this.fuel_burntime_, (int)0, (int)Short.MAX_VALUE));
            ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.stacks_);
        }

        public boolean shouldRefresh(World world, BlockPos pos, IBlockState os, IBlockState ns) {
            return os.func_177230_c() != ns.func_177230_c() || !(ns.func_177230_c() instanceof BlockDecorFurnace);
        }

        public void func_145839_a(NBTTagCompound compound) {
            super.func_145839_a(compound);
            this.readnbt(compound);
        }

        public NBTTagCompound func_189515_b(NBTTagCompound compound) {
            super.func_189515_b(compound);
            this.writenbt(compound);
            return compound;
        }

        public String func_70005_c_() {
            Block block = this.func_145838_q();
            return block != null ? block.func_149739_a() + ".name" : "";
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_145748_c_() {
            return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
        }

        public int func_70302_i_() {
            return this.stacks_.size();
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stacks_) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index < this.func_70302_i_() ? (ItemStack)this.stacks_.get(index) : ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int index, int count) {
            return ItemStackHelper.func_188382_a(this.stacks_, (int)index, (int)count);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stacks_, (int)index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            ItemStack slot_stack = (ItemStack)this.stacks_.get(index);
            boolean already_in_slot = !stack.func_190926_b() && stack.func_77969_a(slot_stack) && ItemStack.func_77970_a((ItemStack)stack, (ItemStack)slot_stack);
            this.stacks_.set(index, (Object)stack);
            if (stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            if (index == 0 && !already_in_slot) {
                this.proc_time_needed_ = this.getCookTime(stack);
                this.proc_time_elapsed_ = 0;
                this.func_70296_d();
            }
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            super.func_70296_d();
        }

        public boolean func_70300_a(EntityPlayer player) {
            return this.field_145850_b.func_175625_s(this.field_174879_c) == this && player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
        }

        public void func_174889_b(EntityPlayer player) {
        }

        public void func_174886_c(EntityPlayer player) {
            this.func_70296_d();
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            switch (index) {
                case 2: 
                case 7: 
                case 8: {
                    return false;
                }
                case 0: 
                case 3: 
                case 4: {
                    return true;
                }
                case 9: 
                case 10: {
                    return true;
                }
            }
            ItemStack slot_stack = (ItemStack)this.stacks_.get(6);
            return BTileEntity.isItemFuel(stack) || SlotFurnaceFuel.func_178173_c_((ItemStack)stack) && slot_stack.func_77973_b() != Items.field_151133_ar;
        }

        public int func_174887_a_(int id) {
            switch (id) {
                case 0: {
                    return this.burntime_left_;
                }
                case 1: {
                    return this.fuel_burntime_;
                }
                case 2: {
                    return this.proc_time_elapsed_;
                }
                case 3: {
                    return this.proc_time_needed_;
                }
            }
            return 0;
        }

        public void func_174885_b(int id, int value) {
            switch (id) {
                case 0: {
                    this.burntime_left_ = value;
                    break;
                }
                case 1: {
                    this.fuel_burntime_ = value;
                    break;
                }
                case 2: {
                    this.proc_time_elapsed_ = value;
                    break;
                }
                case 3: {
                    this.proc_time_needed_ = value;
                }
            }
        }

        public int func_174890_g() {
            return 4;
        }

        public void func_174888_l() {
            this.stacks_.clear();
        }

        public boolean isBurning() {
            return this.burntime_left_ > 0;
        }

        @SideOnly(value=Side.CLIENT)
        public static boolean isBurning(IInventory inventory) {
            return inventory.func_174887_a_(0) > 0;
        }

        public int getCookTime(ItemStack stack) {
            return proc_speed_interval_ < 10 ? 10 : proc_speed_interval_;
        }

        private boolean transferItems(int index_from, int index_to, int count) {
            ItemStack from = (ItemStack)this.stacks_.get(index_from);
            if (from.func_190926_b()) {
                return false;
            }
            ItemStack to = (ItemStack)this.stacks_.get(index_to);
            if (from.func_190916_E() < count) {
                count = from.func_190916_E();
            }
            if (count <= 0) {
                return false;
            }
            boolean changed = true;
            if (to.func_190926_b()) {
                this.stacks_.set(index_to, (Object)from.func_77979_a(count));
            } else if (to.func_190916_E() >= to.func_77976_d()) {
                changed = false;
            } else if (!from.func_77969_a(to) || !ItemStack.func_77970_a((ItemStack)from, (ItemStack)to)) {
                changed = false;
            } else if (to.func_190916_E() + count >= to.func_77976_d()) {
                from.func_190918_g(to.func_77976_d() - to.func_190916_E());
                to.func_190920_e(to.func_77976_d());
            } else {
                from.func_190918_g(count);
                to.func_190917_f(count);
            }
            if (from.func_190926_b() && from != ItemStack.field_190927_a) {
                this.stacks_.set(index_from, (Object)ItemStack.field_190927_a);
                changed = true;
            }
            return changed;
        }

        protected boolean canSmelt() {
            ItemStack in_stack = (ItemStack)this.stacks_.get(0);
            if (in_stack.func_190926_b()) {
                return false;
            }
            ItemStack recipe_result_items = BRecipes.instance().getSmeltingResult(in_stack);
            if (recipe_result_items.func_190926_b()) {
                return false;
            }
            ItemStack result_stack = (ItemStack)this.stacks_.get(2);
            if (result_stack.func_190926_b()) {
                return true;
            }
            if (!result_stack.func_77969_a(recipe_result_items)) {
                return false;
            }
            if (result_stack.func_190916_E() + recipe_result_items.func_190916_E() <= this.func_70297_j_() && result_stack.func_190916_E() + recipe_result_items.func_190916_E() <= result_stack.func_77976_d()) {
                return true;
            }
            return result_stack.func_190916_E() + recipe_result_items.func_190916_E() <= recipe_result_items.func_77976_d();
        }

        public void smeltItem() {
            if (!this.canSmelt()) {
                return;
            }
            ItemStack smelting_input_stack = (ItemStack)this.stacks_.get(0);
            ItemStack recipe_result_items = BRecipes.instance().getSmeltingResult(smelting_input_stack);
            ItemStack smelting_output_stack = (ItemStack)this.stacks_.get(2);
            if (smelting_output_stack.func_190926_b()) {
                this.stacks_.set(2, (Object)recipe_result_items.func_77946_l());
            } else if (smelting_output_stack.func_77973_b() == recipe_result_items.func_77973_b()) {
                smelting_output_stack.func_190917_f(recipe_result_items.func_190916_E());
            }
            smelting_input_stack.func_190918_g(1);
        }

        public static int getItemBurnTime(ItemStack stack) {
            return TileEntityFurnace.func_145952_a((ItemStack)stack);
        }

        public static boolean isItemFuel(ItemStack stack) {
            return TileEntityFurnace.func_145954_b((ItemStack)stack);
        }

        public int[] func_180463_a(EnumFacing side) {
            if (side == EnumFacing.DOWN) {
                return SLOTS_BOTTOM;
            }
            if (side == EnumFacing.UP) {
                return SLOTS_TOP;
            }
            return SLOTS_SIDES;
        }

        public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
            return this.func_94041_b(index, itemStackIn);
        }

        public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
            if (direction != EnumFacing.DOWN || index != 1 && index != 5 && index != 6) {
                return true;
            }
            return stack.func_77973_b() == Items.field_151133_ar;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public int getMaxEnergyStored() {
            return boost_energy_consumption;
        }

        public int getEnergyStored() {
            return this.boost_energy_;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (this.boost_energy_ >= boost_energy_consumption || maxReceive < boost_energy_consumption) {
                return 0;
            }
            if (!simulate) {
                this.boost_energy_ = boost_energy_consumption;
            }
            return boost_energy_consumption;
        }

        public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
            return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || cap == CapabilityEnergy.ENERGY || super.hasCapability(cap, facing);
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (facing != null && capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                if (facing == EnumFacing.DOWN) {
                    return (T)this.sided_itemhandler_down_;
                }
                if (facing == EnumFacing.UP) {
                    return (T)this.sided_itemhandler_top_;
                }
                return (T)this.sided_itemhandler_sides_;
            }
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)((Object)this);
            }
            return (T)super.getCapability(capability, facing);
        }

        public void func_73660_a() {
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 4;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof BlockDecorFurnace)) {
                return;
            }
            boolean was_burning = this.isBurning();
            if (was_burning) {
                this.burntime_left_ -= 4;
            }
            if (this.fuel_burntime_ < 0) {
                this.fuel_burntime_ = BTileEntity.getItemBurnTime((ItemStack)this.stacks_.get(1));
            }
            if (this.burntime_left_ < 0) {
                this.burntime_left_ = 0;
            }
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            boolean dirty = false;
            if (--this.fifo_timer_ <= 0) {
                this.fifo_timer_ = 5;
                if (this.transferItems(7, 8, 1)) {
                    dirty = true;
                }
                if (this.transferItems(2, 7, 1)) {
                    dirty = true;
                }
                if (this.transferItems(5, 1, 1)) {
                    dirty = true;
                }
                if (this.transferItems(6, 5, 1)) {
                    dirty = true;
                }
                if (this.transferItems(3, 0, 1)) {
                    dirty = true;
                }
                if (this.transferItems(4, 3, 1)) {
                    dirty = true;
                }
                this.heater_inserted_ = ExtItems.IE_EXTERNAL_HEATER == null || ((ItemStack)this.stacks_.get(9)).func_77973_b() == ExtItems.IE_EXTERNAL_HEATER || ((ItemStack)this.stacks_.get(10)).func_77973_b() == ExtItems.IE_EXTERNAL_HEATER;
            }
            ItemStack fuel = (ItemStack)this.stacks_.get(1);
            ItemStack last_inp_stack = this.current_smelting_input_stack_;
            this.current_smelting_input_stack_ = (ItemStack)this.stacks_.get(0);
            if (this.isBurning() || !fuel.func_190926_b() && !this.current_smelting_input_stack_.func_190926_b()) {
                boolean can_smelt;
                if (!this.current_smelting_input_stack_.func_77969_a(last_inp_stack)) {
                    this.proc_time_elapsed_ = 0;
                    this.proc_time_needed_ = this.getCookTime(this.current_smelting_input_stack_);
                }
                if ((can_smelt = this.canSmelt()) && this.burntime_left_ <= 0) {
                    this.burntime_left_ = (int)MathHelper.func_151237_a((double)(proc_fuel_efficiency_ * (double)BTileEntity.getItemBurnTime(fuel)), (double)0.0, (double)32767.0);
                    this.fuel_burntime_ = this.burntime_left_ * proc_speed_interval_ / 200;
                    if (this.isBurning()) {
                        dirty = true;
                        if (!fuel.func_190926_b()) {
                            Item fuel_item = fuel.func_77973_b();
                            fuel.func_190918_g(1);
                            if (fuel.func_190926_b()) {
                                this.stacks_.set(1, (Object)fuel_item.getContainerItem(fuel));
                            }
                        }
                    }
                }
                if (this.burntime_left_ > 0 && can_smelt) {
                    this.proc_time_elapsed_ += 4;
                    if (this.heater_inserted_ && this.boost_energy_ >= boost_energy_consumption) {
                        this.boost_energy_ = 0;
                        this.proc_time_elapsed_ += 4;
                    }
                    if (this.proc_time_elapsed_ >= this.proc_time_needed_) {
                        this.proc_time_elapsed_ = 0;
                        this.proc_time_needed_ = this.getCookTime(this.current_smelting_input_stack_);
                        this.smeltItem();
                        dirty = true;
                    }
                } else {
                    this.proc_time_elapsed_ = MathHelper.func_76125_a((int)(this.proc_time_elapsed_ - 2), (int)0, (int)this.proc_time_needed_);
                }
            } else if (!this.isBurning() && this.proc_time_elapsed_ > 0) {
                this.proc_time_elapsed_ = MathHelper.func_76125_a((int)(this.proc_time_elapsed_ - 2), (int)0, (int)this.proc_time_needed_);
            }
            if (was_burning != this.isBurning()) {
                dirty = true;
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf(this.isBurning())));
            }
            if (dirty) {
                this.func_70296_d();
            }
        }
    }

    public static class BContainer
    extends Container {
        private static final int PLAYER_INV_START_SLOTNO = 11;
        private final World world;
        private final BlockPos pos;
        private final EntityPlayer player;
        private final BTileEntity te;
        private int proc_time_elapsed_;
        private int burntime_left_;
        private int fuel_burntime_;
        private int proc_time_needed_;

        public BContainer(InventoryPlayer playerInventory, World world, BlockPos pos, BTileEntity te) {
            this.player = playerInventory.field_70458_d;
            this.world = world;
            this.pos = pos;
            this.te = te;
            this.func_75146_a(new Slot((IInventory)te, 0, 59, 17));
            this.func_75146_a((Slot)new SlotFurnaceFuel((IInventory)te, 1, 59, 53));
            this.func_75146_a(new BSlotResult(playerInventory.field_70458_d, te, 2, 101, 35));
            this.func_75146_a(new BSlotInpFifo((IInventory)te, 3, 34, 17));
            this.func_75146_a(new BSlotInpFifo((IInventory)te, 4, 16, 17));
            this.func_75146_a(new BSlotFuelFifo((IInventory)te, 5, 34, 53));
            this.func_75146_a(new BSlotFuelFifo((IInventory)te, 6, 16, 53));
            this.func_75146_a(new BSlotOutFifo(playerInventory.field_70458_d, te, 7, 126, 35));
            this.func_75146_a(new BSlotOutFifo(playerInventory.field_70458_d, te, 8, 144, 35));
            this.func_75146_a(new Slot((IInventory)te, 9, 126, 61));
            this.func_75146_a(new Slot((IInventory)te, 10, 144, 61));
            for (int x = 0; x < 9; ++x) {
                this.func_75146_a(new Slot((IInventory)playerInventory, x, 8 + x * 18, 144));
            }
            for (int y = 0; y < 3; ++y) {
                for (int x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)playerInventory, x + y * 9 + 9, 8 + x * 18, 86 + y * 18));
                }
            }
        }

        public void func_75132_a(IContainerListener listener) {
            super.func_75132_a(listener);
            listener.func_175173_a((Container)this, (IInventory)this.te);
        }

        public void func_75142_b() {
            super.func_75142_b();
            for (int i = 0; i < this.field_75149_d.size(); ++i) {
                IContainerListener lis = (IContainerListener)this.field_75149_d.get(i);
                if (this.proc_time_elapsed_ != this.te.func_174887_a_(2)) {
                    lis.func_71112_a((Container)this, 2, this.te.func_174887_a_(2));
                }
                if (this.burntime_left_ != this.te.func_174887_a_(0)) {
                    lis.func_71112_a((Container)this, 0, this.te.func_174887_a_(0));
                }
                if (this.fuel_burntime_ != this.te.func_174887_a_(1)) {
                    lis.func_71112_a((Container)this, 1, this.te.func_174887_a_(1));
                }
                if (this.proc_time_needed_ == this.te.func_174887_a_(3)) continue;
                lis.func_71112_a((Container)this, 3, this.te.func_174887_a_(3));
            }
            this.proc_time_elapsed_ = this.te.func_174887_a_(2);
            this.burntime_left_ = this.te.func_174887_a_(0);
            this.fuel_burntime_ = this.te.func_174887_a_(1);
            this.proc_time_needed_ = this.te.func_174887_a_(3);
        }

        @SideOnly(value=Side.CLIENT)
        public void func_75137_b(int id, int data) {
            this.te.func_174885_b(id, data);
        }

        public boolean func_75145_c(EntityPlayer player) {
            return this.world.func_180495_p(this.pos).func_177230_c() instanceof BlockDecorFurnace && player.func_174818_b(this.pos) <= 64.0;
        }

        public ItemStack func_82846_b(EntityPlayer player, int index) {
            Slot slot = (Slot)this.field_75151_b.get(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slot_stack = slot.func_75211_c();
            ItemStack transferred = slot_stack.func_77946_l();
            if (index == 2 || index == 7 || index == 8) {
                if (!this.func_75135_a(slot_stack, 11, 47, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(slot_stack, transferred);
            } else if (index == 0 || index == 3 || index == 4) {
                if (!this.func_75135_a(slot_stack, 11, 47, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index == 1 || index == 5 || index == 6) {
                if (!this.func_75135_a(slot_stack, 11, 47, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index == 9 || index == 10) {
                if (!this.func_75135_a(slot_stack, 11, 47, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 11 && index <= 47) {
                if (!BRecipes.instance().getSmeltingResult(slot_stack).func_190926_b() ? !this.func_75135_a(slot_stack, 0, 1, false) && !this.func_75135_a(slot_stack, 3, 4, false) && !this.func_75135_a(slot_stack, 4, 5, false) : (TileEntityFurnace.func_145954_b((ItemStack)slot_stack) ? !this.func_75135_a(slot_stack, 1, 2, false) && !this.func_75135_a(slot_stack, 5, 6, false) && !this.func_75135_a(slot_stack, 6, 7, false) : (index >= 11 && index < 38 ? !this.func_75135_a(slot_stack, 38, 47, false) : index >= 38 && index < 47 && !this.func_75135_a(slot_stack, 11, 38, false)))) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (slot_stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slot_stack);
            return transferred;
        }
    }

    public static class BSlotResult
    extends Slot {
        private final EntityPlayer player;
        private int removeCount = 0;

        public BSlotResult(EntityPlayer player, BTileEntity te, int index, int xpos, int ypos) {
            super((IInventory)te, index, xpos, ypos);
            this.player = player;
        }

        public boolean func_75214_a(ItemStack stack) {
            return false;
        }

        public ItemStack func_75209_a(int amount) {
            this.removeCount += this.func_75216_d() ? Math.min(amount, this.func_75211_c().func_190916_E()) : 0;
            return super.func_75209_a(amount);
        }

        public ItemStack func_190901_a(EntityPlayer thePlayer, ItemStack stack) {
            this.func_75208_c(stack);
            super.func_190901_a(thePlayer, stack);
            return stack;
        }

        protected void func_75210_a(ItemStack stack, int amount) {
            this.removeCount += amount;
            this.func_75208_c(stack);
        }

        protected void func_75208_c(ItemStack stack) {
            stack.func_77980_a(this.player.field_70170_p, this.player, this.removeCount);
            if (!this.player.field_70170_p.field_72995_K) {
                int xp = this.removeCount;
                float sxp = BRecipes.instance().getSmeltingExperience(stack);
                if (sxp == 0.0f) {
                    xp = 0;
                } else if ((double)sxp < 1.0) {
                    xp = (int)(sxp * (float)xp + (float)Math.round(Math.random() + 0.75));
                }
                while (xp > 0) {
                    int k = EntityXPOrb.func_70527_a((int)xp);
                    xp -= k;
                    this.player.field_70170_p.func_72838_d((Entity)new EntityXPOrb(this.player.field_70170_p, this.player.field_70165_t, this.player.field_70163_u + 0.5, this.player.field_70161_v + 0.5, k));
                }
            }
            this.removeCount = 0;
            FMLCommonHandler.instance().firePlayerSmeltedEvent(this.player, stack);
        }
    }

    public static class BSlotOutFifo
    extends BSlotResult {
        public BSlotOutFifo(EntityPlayer player, BTileEntity te, int index, int xpos, int ypos) {
            super(player, te, index, xpos, ypos);
        }
    }

    public static class BSlotFuelFifo
    extends Slot {
        public BSlotFuelFifo(IInventory inv, int index, int xpos, int ypos) {
            super(inv, index, xpos, ypos);
        }
    }

    public static class BSlotInpFifo
    extends Slot {
        public BSlotInpFifo(IInventory inv, int index, int xpos, int ypos) {
            super(inv, index, xpos, ypos);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private static class BGui
    extends GuiContainer {
        private final BTileEntity te;

        public BGui(InventoryPlayer playerInventory, World world, BlockPos pos, BTileEntity te) {
            super((Container)new BContainer(playerInventory, world, pos, te));
            this.te = te;
        }

        public void func_73866_w_() {
            super.func_73866_w_();
        }

        public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
            this.func_146276_q_();
            super.func_73863_a(mouseX, mouseY, partialTicks);
            this.func_191948_b(mouseX, mouseY);
        }

        protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.field_146297_k.func_110434_K().func_110577_a(new ResourceLocation("engineersdecor", "textures/gui/small_lab_furnace_gui.png"));
            int x0 = (this.field_146294_l - this.field_146999_f) / 2;
            int y0 = (this.field_146295_m - this.field_147000_g) / 2;
            int w = this.field_146999_f;
            int h = this.field_147000_g;
            this.func_73729_b(x0, y0, 0, 0, w, h);
            if (BTileEntity.isBurning((IInventory)this.te)) {
                int k = this.flame_px(13);
                this.func_73729_b(x0 + 59, y0 + 36 + 12 - k, 176, 12 - k, 14, k + 1);
            }
            this.func_73729_b(x0 + 79, y0 + 36, 176, 15, 1 + this.progress_px(17), 15);
        }

        private int progress_px(int pixels) {
            int tc = this.te.func_174887_a_(2);
            int T = this.te.func_174887_a_(3);
            return T > 0 && tc > 0 ? tc * pixels / T : 0;
        }

        private int flame_px(int pixels) {
            int ibt = this.te.func_174887_a_(1);
            return this.te.func_174887_a_(0) * pixels / (ibt > 0 ? ibt : BTileEntity.proc_speed_interval_);
        }
    }
}

