/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.BlockDecor;
import wile.engineersdecor.detail.ModAuxiliaries;

public class BlockDecorSolarPanel
extends BlockDecor {
    public static final PropertyInteger EXPOSITION = PropertyInteger.func_177719_a((String)"exposition", (int)0, (int)4);

    public BlockDecorSolarPanel(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound, @Nonnull AxisAlignedBB unrotatedAABB) {
        super(registryName, config, material, hardness, resistance, sound, unrotatedAABB);
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return 0;
    }

    @Override
    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)EXPOSITION, (Comparable)Integer.valueOf(meta & 7));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)EXPOSITION);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{EXPOSITION});
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        return super.func_176198_a(world, pos, side);
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)EXPOSITION, (Comparable)Integer.valueOf(0));
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BTileEntity();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return true;
        }
        ((BTileEntity)te).state_message(player);
        return true;
    }

    public static class BTileEntity
    extends TileEntity
    implements ITickable {
        public static final int DEFAULT_PEAK_POWER = 32;
        public static final int TICK_INTERVAL = 8;
        public static final int ACCUMULATION_INTERVAL = 4;
        private static final EnumFacing[] transfer_directions_ = new EnumFacing[]{EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.NORTH};
        private static int peak_power_per_tick_ = 32;
        private static int max_power_storage_ = 10000;
        private static int max_feed_power = 128;
        private int current_production_ = 0;
        private int tick_timer_ = 0;
        private int recalc_timer_ = 0;
        private int accumulated_power_ = 0;
        private int current_feedin_ = 0;

        public static void on_config(int peak_power_per_tick) {
            peak_power_per_tick_ = peak_power_per_tick;
            ModEngineersDecor.logger.info("Config small solar panel: Peak production:" + peak_power_per_tick_ + "/tick");
        }

        public void readnbt(NBTTagCompound nbt, boolean update_packet) {
            this.accumulated_power_ = nbt.func_74762_e("energy");
        }

        protected void writenbt(NBTTagCompound nbt, boolean update_packet) {
            nbt.func_74768_a("energy", this.accumulated_power_);
        }

        public void state_message(EntityPlayer player) {
            String soc = Integer.toString(MathHelper.func_76125_a((int)(this.accumulated_power_ * 100 / max_power_storage_), (int)0, (int)100));
            ModAuxiliaries.playerChatMessage(player, soc + "%%/" + max_power_storage_ + "RF | +" + this.current_production_ + "RF/t | -" + this.current_feedin_ + "RF/t");
        }

        public boolean shouldRefresh(World world, BlockPos pos, IBlockState os, IBlockState ns) {
            return os.func_177230_c() != ns.func_177230_c() || !(ns.func_177230_c() instanceof BlockDecorSolarPanel);
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.readnbt(nbt, false);
        }

        public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt, false);
            return nbt;
        }

        public void func_73660_a() {
            if (this.field_145850_b.field_72995_K || --this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 8;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof BlockDecorSolarPanel)) {
                return;
            }
            this.current_feedin_ = 0;
            if (this.accumulated_power_ > 0) {
                for (int i = 0; i < transfer_directions_.length && this.accumulated_power_ > 0; ++i) {
                    IEnergyStorage es;
                    EnumFacing f = transfer_directions_[i];
                    TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(f));
                    if (te == null || !te.hasCapability(CapabilityEnergy.ENERGY, f.func_176734_d()) || !(es = (IEnergyStorage)te.getCapability(CapabilityEnergy.ENERGY, f.func_176734_d())).canReceive()) continue;
                    int fed = es.receiveEnergy(max_feed_power * 8, false);
                    this.accumulated_power_ = MathHelper.func_76125_a((int)(this.accumulated_power_ - fed), (int)0, (int)this.accumulated_power_);
                    this.current_feedin_ += fed;
                }
            }
            this.current_feedin_ /= 8;
            if (!this.field_145850_b.func_175678_i(this.field_174879_c)) {
                this.tick_timer_ = 40;
                this.current_production_ = 0;
                if ((Integer)state.func_177229_b((IProperty)EXPOSITION) != 2) {
                    this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)EXPOSITION, (Comparable)Integer.valueOf(2)));
                }
                return;
            }
            if (--this.recalc_timer_ > 0) {
                return;
            }
            this.recalc_timer_ = 4 + (int)(Math.random() + 0.5);
            int theta = ((int)((double)this.field_145850_b.func_72929_e(1.0f) * 57.29577951308232) + 90) % 360;
            int e = 2;
            if (theta > 340) {
                e = 2;
            } else if (theta < 45) {
                e = 0;
            } else if (theta < 80) {
                e = 1;
            } else if (theta < 100) {
                e = 2;
            } else if (theta < 135) {
                e = 3;
            } else if (theta < 190) {
                e = 4;
            }
            IBlockState nstate = state.func_177226_a((IProperty)EXPOSITION, (Comparable)Integer.valueOf(e));
            if (nstate != state) {
                this.field_145850_b.func_180501_a(this.field_174879_c, nstate, 3);
            }
            double eff = 1.0 - ((double)this.field_145850_b.func_72867_j(1.0f) * 0.6 + (double)this.field_145850_b.func_72819_i(1.0f) * 0.3);
            double rf = Math.sin(1.5707963267948966 * Math.sqrt((double)(theta < 0 || theta > 180 ? 0 : (theta > 90 ? 180 - theta : theta)) / 90.0));
            this.current_production_ = (int)(Math.min(rf * rf * eff, 1.0) * (double)peak_power_per_tick_);
            this.accumulated_power_ = Math.min(this.accumulated_power_ + this.current_production_ * 32, max_power_storage_);
        }
    }
}

