/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.BlockDecorDirectedHorizontal;
import wile.engineersdecor.detail.ModAuxiliaries;
import wile.engineersdecor.detail.TreeCutting;

public class BlockDecorTreeCutter
extends BlockDecorDirectedHorizontal {
    public static final PropertyBool ACTIVE = PropertyBool.func_177716_a((String)"active");

    public BlockDecorTreeCutter(@Nonnull String registryName, long config, @Nullable Material material, float hardness, float resistance, @Nullable SoundType sound, @Nonnull AxisAlignedBB unrotatedAABB) {
        super(registryName, config, material, hardness, resistance, sound, unrotatedAABB);
        this.func_149713_g(0);
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, ACTIVE});
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)(meta & 3))).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf((meta & 4) != 0));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176736_b() & 3 | ((Boolean)state.func_177229_b((IProperty)ACTIVE) != false ? 4 : 0);
    }

    @Override
    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new BTileEntity();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rnd) {
        if (state.func_177230_c() != this || !((Boolean)state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
            return;
        }
        double rv = rnd.nextDouble();
        if (rv > 0.8) {
            return;
        }
        double x = 0.5 + (double)pos.func_177958_n();
        double y = 0.5 + (double)pos.func_177956_o();
        double z = 0.5 + (double)pos.func_177952_p();
        double xc = 0.52;
        double xr = rnd.nextDouble() * 0.4 - 0.2;
        double yr = y - 0.3 + rnd.nextDouble() * 0.2;
        switch ((EnumFacing)state.func_177229_b((IProperty)FACING)) {
            case WEST: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x - 0.52, yr, z + xr, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case EAST: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + 0.52, yr, z + xr, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case NORTH: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + xr, yr, z - 0.52, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            default: {
                world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + xr, yr, z + 0.52, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof BTileEntity)) {
            return true;
        }
        ((BTileEntity)te).state_message(player);
        return true;
    }

    public static class BTileEntity
    extends TileEntity
    implements ITickable,
    IEnergyStorage {
        public static final int IDLE_TICK_INTERVAL = 40;
        public static final int TICK_INTERVAL = 5;
        public static final int BOOST_FACTOR = 6;
        public static final int DEFAULT_BOOST_ENERGY = 64;
        public static final int DEFAULT_CUTTING_TIME_NEEDED = 60;
        private static int energy_max = 1280;
        private static int boost_energy_consumption = 64;
        private static int cutting_time_needed = 1200;
        private static boolean requires_power = false;
        private int tick_timer_;
        private int active_timer_;
        private int proc_time_elapsed_;
        private int energy_;

        public static void on_config(int boost_energy_per_tick, int cutting_time_seconds, boolean power_required) {
            boost_energy_consumption = 5 * MathHelper.func_76125_a((int)boost_energy_per_tick, (int)16, (int)512);
            energy_max = Math.max(boost_energy_consumption * 10, 10000);
            cutting_time_needed = 20 * MathHelper.func_76125_a((int)cutting_time_seconds, (int)10, (int)240);
            requires_power = power_required;
            ModEngineersDecor.logger.info("Config tree cutter: Boost energy consumption:" + boost_energy_consumption + "rf/t" + (requires_power ? " (power required for operation) " : "") + ", cutting time " + cutting_time_needed + "t.");
        }

        public void state_message(EntityPlayer player) {
            String soc = Integer.toString(MathHelper.func_76125_a((int)(this.energy_ * 100 / energy_max), (int)0, (int)100));
            String progress = "";
            if (this.active_timer_ > 0 && cutting_time_needed > 0) {
                progress = " | " + Integer.toString((int)MathHelper.func_151237_a((double)((double)this.proc_time_elapsed_ / (double)cutting_time_needed * 100.0), (double)0.0, (double)100.0)) + "%%";
            }
            ModAuxiliaries.playerChatMessage(player, soc + "%%/" + energy_max + "RF" + progress);
        }

        public void readnbt(NBTTagCompound nbt) {
            this.energy_ = nbt.func_74762_e("energy");
        }

        private void writenbt(NBTTagCompound nbt) {
            nbt.func_74768_a("energy", this.energy_);
        }

        public boolean shouldRefresh(World world, BlockPos pos, IBlockState os, IBlockState ns) {
            return os.func_177230_c() != ns.func_177230_c() || !(ns.func_177230_c() instanceof BlockDecorTreeCutter);
        }

        public void func_145839_a(NBTTagCompound nbt) {
            super.func_145839_a(nbt);
            this.readnbt(nbt);
        }

        public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt);
            return nbt;
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return true;
        }

        public int getMaxEnergyStored() {
            return boost_energy_consumption * 2;
        }

        public int getEnergyStored() {
            return this.energy_;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int receiveEnergy(int maxReceive, boolean simulate) {
            maxReceive = MathHelper.func_76125_a((int)maxReceive, (int)0, (int)Math.max(energy_max - this.energy_, 0));
            if (!simulate) {
                this.energy_ += maxReceive;
            }
            return maxReceive;
        }

        public boolean hasCapability(Capability<?> cap, EnumFacing facing) {
            return cap == CapabilityEnergy.ENERGY || super.hasCapability(cap, facing);
        }

        @Nullable
        public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)((Object)this);
            }
            return (T)super.getCapability(capability, facing);
        }

        public void func_73660_a() {
            if (--this.tick_timer_ > 0) {
                return;
            }
            IBlockState device_state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(device_state.func_177230_c() instanceof BlockDecorTreeCutter)) {
                this.tick_timer_ = 5;
                return;
            }
            if (this.field_145850_b.field_72995_K) {
                if (!((Boolean)device_state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
                    this.tick_timer_ = 5;
                } else {
                    this.tick_timer_ = 1;
                    this.field_145850_b.func_184134_a((double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187889_gU, SoundCategory.BLOCKS, 0.1f, 1.0f, false);
                }
            } else {
                boolean active;
                this.tick_timer_ = 5;
                BlockPos tree_pos = this.field_174879_c.func_177972_a((EnumFacing)device_state.func_177229_b((IProperty)BlockDecorDirectedHorizontal.FACING));
                IBlockState tree_state = this.field_145850_b.func_180495_p(tree_pos);
                if (!TreeCutting.canChop(tree_state) || this.field_145850_b.func_175640_z(this.field_174879_c)) {
                    if (((Boolean)device_state.func_177229_b((IProperty)ACTIVE)).booleanValue()) {
                        this.field_145850_b.func_180501_a(this.field_174879_c, device_state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(false)), 3);
                    }
                    this.proc_time_elapsed_ = 0;
                    this.active_timer_ = 0;
                    this.tick_timer_ = 40;
                    return;
                }
                this.proc_time_elapsed_ += 5;
                if (this.energy_ >= boost_energy_consumption) {
                    this.energy_ -= boost_energy_consumption;
                    this.proc_time_elapsed_ += 30;
                    this.active_timer_ = 2;
                } else if (!requires_power) {
                    this.active_timer_ = 1024;
                } else if (this.active_timer_ > 0) {
                    --this.active_timer_;
                }
                boolean bl = active = this.active_timer_ > 0;
                if (requires_power && !active) {
                    this.proc_time_elapsed_ = Math.max(0, this.proc_time_elapsed_ - 10);
                }
                if (this.proc_time_elapsed_ >= cutting_time_needed) {
                    this.proc_time_elapsed_ = 0;
                    TreeCutting.chopTree(this.field_145850_b, tree_state, tree_pos, 2048, false);
                    this.field_145850_b.func_184148_a(null, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), SoundEvents.field_187881_gQ, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    active = false;
                }
                if ((Boolean)device_state.func_177229_b((IProperty)ACTIVE) != active) {
                    this.field_145850_b.func_180501_a(this.field_174879_c, device_state.func_177226_a((IProperty)ACTIVE, (Comparable)Boolean.valueOf(active)), 3);
                }
            }
        }
    }
}

