/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.blocks;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IIntArray;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.INameable;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.IntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import wile.engineersdecor.ModContent;
import wile.engineersdecor.ModEngineersDecor;
import wile.engineersdecor.blocks.IDecorBlock;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.detail.Networking;
import wile.engineersdecor.libmc.detail.TooltipDisplay;

public class EdPlacer {

    @OnlyIn(value=Dist.CLIENT)
    public static class PlacerGui
    extends ContainerScreen<PlacerContainer> {
        protected final PlayerEntity player_;
        protected final TooltipDisplay tooltip_ = new TooltipDisplay();

        public PlacerGui(PlacerContainer container, PlayerInventory player_inventory, ITextComponent title) {
            super((Container)container, player_inventory, title);
            this.player_ = player_inventory.field_70458_d;
        }

        public void init() {
            super.init();
            String prefix = ModContent.FACTORY_PLACER.func_149739_a() + ".tooltips.";
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            this.tooltip_.init(new TooltipDisplay.TipRange(x0 + 133, y0 + 49, 9, 9, (ITextComponent)new TranslationTextComponent(prefix + "rssignal", new Object[0])), new TooltipDisplay.TipRange(x0 + 145, y0 + 49, 9, 9, (ITextComponent)new TranslationTextComponent(prefix + "inversion", new Object[0])), new TooltipDisplay.TipRange(x0 + 159, y0 + 49, 9, 9, (ITextComponent)new TranslationTextComponent(prefix + "triggermode", new Object[0])));
        }

        public void render(int mouseX, int mouseY, float partialTicks) {
            this.renderBackground();
            super.render(mouseX, mouseY, partialTicks);
            if (!this.tooltip_.render(this, mouseX, mouseY)) {
                this.func_191948_b(mouseX, mouseY);
            }
        }

        public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
            this.tooltip_.resetTimer();
            PlacerContainer container = (PlacerContainer)this.func_212873_a_();
            int mx = (int)(mouseX - (double)this.getGuiLeft() + 0.5);
            int my = (int)(mouseY - (double)this.getGuiTop() + 0.5);
            if (!this.func_195359_a(126, 1, 49, 60, mouseX, mouseY)) {
                return super.mouseClicked(mouseX, mouseY, mouseButton);
            }
            if (this.func_195359_a(133, 49, 9, 9, mouseX, mouseY)) {
                container.onGuiAction("manual_trigger", 1);
            } else if (this.func_195359_a(145, 49, 9, 9, mouseX, mouseY)) {
                container.onGuiAction("logic", container.field(0) ^ 1);
            } else if (this.func_195359_a(159, 49, 7, 9, mouseX, mouseY)) {
                container.onGuiAction("logic", container.field(0) ^ 2);
            }
            return true;
        }

        protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.minecraft.func_110434_K().func_110577_a(new ResourceLocation("engineersdecor", "textures/gui/factory_placer_gui.png"));
            int x0 = this.getGuiLeft();
            int y0 = this.getGuiTop();
            int w = this.getXSize();
            int h = this.getYSize();
            this.blit(x0, y0, 0, 0, w, h);
            PlacerContainer container = (PlacerContainer)this.func_212873_a_();
            int slot_index = container.field(2);
            if (slot_index < 0 || slot_index >= 18) {
                slot_index = 0;
            }
            int x = x0 + 10 + slot_index % 6 * 18;
            int y = y0 + 8 + slot_index / 6 * 17;
            this.blit(x, y, 200, 8, 18, 18);
            if (container.field(1) != 0) {
                this.blit(x0 + 133, y0 + 49, 217, 49, 9, 9);
            }
            int inverter_offset = (container.field(0) & 1) != 0 ? 11 : 0;
            this.blit(x0 + 145, y0 + 49, 177 + inverter_offset, 49, 9, 9);
            int pulse_mode_offset = (container.field(0) & 2) != 0 ? 9 : 0;
            this.blit(x0 + 159, y0 + 49, 199 + pulse_mode_offset, 49, 9, 9);
        }
    }

    public static class PlacerContainer
    extends Container
    implements Networking.INetworkSynchronisableContainer {
        private static final int PLAYER_INV_START_SLOTNO = 18;
        private final PlayerEntity player_;
        private final IInventory inventory_;
        private final IWorldPosCallable wpc_;
        private final IIntArray fields_;

        public final int field(int index) {
            return this.fields_.func_221476_a(index);
        }

        public PlacerContainer(int cid, PlayerInventory player_inventory) {
            this(cid, player_inventory, (IInventory)new Inventory(18), IWorldPosCallable.field_221489_a, (IIntArray)new IntArray(3));
        }

        private PlacerContainer(int cid, PlayerInventory player_inventory, IInventory block_inventory, IWorldPosCallable wpc, IIntArray fields) {
            super(ModContent.CT_FACTORY_PLACER, cid);
            int x;
            int y;
            this.fields_ = fields;
            this.wpc_ = wpc;
            this.player_ = player_inventory.field_70458_d;
            this.inventory_ = block_inventory;
            int i = -1;
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 6; ++x) {
                    int xpos = 11 + x * 18;
                    int ypos = 9 + y * 17;
                    this.func_75146_a(new Slot(this.inventory_, ++i, xpos, ypos));
                }
            }
            for (int x2 = 0; x2 < 9; ++x2) {
                this.func_75146_a(new Slot((IInventory)player_inventory, x2, 9 + x2 * 18, 129));
            }
            for (y = 0; y < 3; ++y) {
                for (x = 0; x < 9; ++x) {
                    this.func_75146_a(new Slot((IInventory)player_inventory, x + y * 9 + 9, 9 + x * 18, 71 + y * 18));
                }
            }
            this.func_216961_a(this.fields_);
        }

        public boolean func_75145_c(PlayerEntity player) {
            return this.inventory_.func_70300_a(player);
        }

        public ItemStack func_82846_b(PlayerEntity player, int index) {
            Slot slot = this.func_75139_a(index);
            if (slot == null || !slot.func_75216_d()) {
                return ItemStack.field_190927_a;
            }
            ItemStack slot_stack = slot.func_75211_c();
            ItemStack transferred = slot_stack.func_77946_l();
            if (index >= 0 && index < 18) {
                if (!this.func_75135_a(slot_stack, 18, 54, false)) {
                    return ItemStack.field_190927_a;
                }
            } else if (index >= 18 && index <= 54) {
                if (!this.func_75135_a(slot_stack, 0, 18, false)) {
                    return ItemStack.field_190927_a;
                }
            } else {
                return ItemStack.field_190927_a;
            }
            if (slot_stack.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (slot_stack.func_190916_E() == transferred.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            slot.func_190901_a(player, slot_stack);
            return transferred;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(CompoundNBT nbt) {
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void onGuiAction(String key, int value) {
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74768_a(key, value);
            Networking.PacketContainerSyncClientToServer.sendToServer(this.field_75152_c, nbt);
        }

        @Override
        public void onServerPacketReceived(int windowId, CompoundNBT nbt) {
        }

        @Override
        public void onClientPacketReceived(int windowId, PlayerEntity player, CompoundNBT nbt) {
            if (!(this.inventory_ instanceof PlacerTileEntity)) {
                return;
            }
            PlacerTileEntity te = (PlacerTileEntity)this.inventory_;
            if (nbt.func_74764_b("logic")) {
                te.logic_ = nbt.func_74762_e("logic");
            }
            if (nbt.func_74764_b("manual_trigger") && nbt.func_74762_e("manual_trigger") != 0) {
                te.block_power_signal_ = true;
                te.block_power_updated_ = true;
                te.tick_timer_ = 1;
            }
            te.func_70296_d();
        }
    }

    public static class PlacerTileEntity
    extends TileEntity
    implements ITickableTileEntity,
    INameable,
    IInventory,
    INamedContainerProvider,
    ISidedInventory {
        public static final int TICK_INTERVAL = 40;
        public static final int NUM_OF_SLOTS = 18;
        public static final int NUM_OF_FIELDS = 3;
        public static final int LOGIC_INVERTED = 1;
        public static final int LOGIC_CONTINUOUS = 2;
        private boolean block_power_signal_ = false;
        private boolean block_power_updated_ = false;
        private int logic_ = 3;
        private int current_slot_index_ = 0;
        private int tick_timer_ = 0;
        protected NonNullList<ItemStack> stacks_;
        protected final IIntArray fields = new IntArray(3){

            public int func_221476_a(int id) {
                switch (id) {
                    case 0: {
                        return logic_;
                    }
                    case 1: {
                        return block_power_signal_ ? 1 : 0;
                    }
                    case 2: {
                        return MathHelper.func_76125_a((int)current_slot_index_, (int)0, (int)17);
                    }
                }
                return 0;
            }

            public void func_221477_a(int id, int value) {
                switch (id) {
                    case 0: {
                        logic_ = value;
                        return;
                    }
                    case 1: {
                        block_power_signal_ = value != 0;
                        return;
                    }
                    case 2: {
                        current_slot_index_ = MathHelper.func_76125_a((int)value, (int)0, (int)17);
                        return;
                    }
                }
            }
        };
        LazyOptional<? extends IItemHandler>[] item_handlers = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP});
        private static final int[] SIDED_INV_SLOTS = new int[18];

        public static void on_config(int cooldown_ticks) {
        }

        public PlacerTileEntity() {
            this(ModContent.TET_FACTORY_PLACER);
        }

        public PlacerTileEntity(TileEntityType<?> te_type) {
            super(te_type);
            this.stacks_ = NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);
            this.reset_rtstate();
        }

        public CompoundNBT clear_getnbt() {
            CompoundNBT nbt = new CompoundNBT();
            this.writenbt(nbt, false);
            for (int i = 0; i < this.stacks_.size(); ++i) {
                this.stacks_.set(i, (Object)ItemStack.field_190927_a);
            }
            this.reset_rtstate();
            this.block_power_updated_ = false;
            return nbt;
        }

        public void reset_rtstate() {
            this.block_power_signal_ = false;
            this.block_power_updated_ = false;
        }

        public void readnbt(CompoundNBT nbt, boolean update_packet) {
            this.stacks_ = NonNullList.func_191197_a((int)18, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.stacks_);
            while (this.stacks_.size() < 18) {
                this.stacks_.add((Object)ItemStack.field_190927_a);
            }
            this.block_power_signal_ = nbt.func_74767_n("powered");
            this.current_slot_index_ = nbt.func_74762_e("act_slot_index");
            this.logic_ = nbt.func_74762_e("logic");
        }

        protected void writenbt(CompoundNBT nbt, boolean update_packet) {
            ItemStackHelper.func_191282_a((CompoundNBT)nbt, this.stacks_);
            nbt.func_74757_a("powered", this.block_power_signal_);
            nbt.func_74768_a("act_slot_index", this.current_slot_index_);
            nbt.func_74768_a("logic", this.logic_);
        }

        public void block_updated() {
            boolean powered = this.field_145850_b.func_175640_z(this.field_174879_c);
            if (this.block_power_signal_ != powered) {
                this.block_power_updated_ = true;
            }
            this.block_power_signal_ = powered;
            if (this.block_power_updated_) {
                this.tick_timer_ = 1;
            } else if (this.tick_timer_ > 4) {
                this.tick_timer_ = 4;
            }
        }

        public boolean is_input_slot(int index) {
            return index >= 0 && index < 18;
        }

        public void func_145839_a(CompoundNBT nbt) {
            super.func_145839_a(nbt);
            this.readnbt(nbt, false);
        }

        public CompoundNBT func_189515_b(CompoundNBT nbt) {
            super.func_189515_b(nbt);
            this.writenbt(nbt, false);
            return nbt;
        }

        public void func_145843_s() {
            super.func_145843_s();
            Arrays.stream(this.item_handlers).forEach(LazyOptional::invalidate);
        }

        public ITextComponent func_200200_C_() {
            Block block = this.func_195044_w().func_177230_c();
            return new StringTextComponent(block != null ? block.func_149739_a() : "Factory placer");
        }

        public boolean func_145818_k_() {
            return false;
        }

        public ITextComponent func_200201_e() {
            return this.func_200200_C_();
        }

        public ITextComponent func_145748_c_() {
            return super.func_145748_c_();
        }

        public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
            return new PlacerContainer(id, inventory, this, IWorldPosCallable.func_221488_a((World)this.field_145850_b, (BlockPos)this.field_174879_c), this.fields);
        }

        public int func_70302_i_() {
            return this.stacks_.size();
        }

        public boolean func_191420_l() {
            for (ItemStack stack : this.stacks_) {
                if (stack.func_190926_b()) continue;
                return false;
            }
            return true;
        }

        public ItemStack func_70301_a(int index) {
            return index < this.func_70302_i_() ? (ItemStack)this.stacks_.get(index) : ItemStack.field_190927_a;
        }

        public ItemStack func_70298_a(int index, int count) {
            return ItemStackHelper.func_188382_a(this.stacks_, (int)index, (int)count);
        }

        public ItemStack func_70304_b(int index) {
            return ItemStackHelper.func_188383_a(this.stacks_, (int)index);
        }

        public void func_70299_a(int index, ItemStack stack) {
            if (index < 0 || index >= 18) {
                return;
            }
            this.stacks_.set(index, (Object)stack);
            if (stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
            if (this.tick_timer_ > 8) {
                this.tick_timer_ = 8;
            }
            this.func_70296_d();
        }

        public int func_70297_j_() {
            return 64;
        }

        public void func_70296_d() {
            super.func_70296_d();
        }

        public boolean func_70300_a(PlayerEntity player) {
            return this.func_174877_v().func_177951_i((Vec3i)player.func_180425_c()) < 36.0;
        }

        public void func_174889_b(PlayerEntity player) {
        }

        public void func_174886_c(PlayerEntity player) {
            this.func_70296_d();
        }

        public boolean func_94041_b(int index, ItemStack stack) {
            return index >= 0 && index < 18;
        }

        public void func_174888_l() {
            for (int i = 0; i < this.stacks_.size(); ++i) {
                this.stacks_.set(i, (Object)ItemStack.field_190927_a);
            }
        }

        public int[] func_180463_a(Direction side) {
            return SIDED_INV_SLOTS;
        }

        public boolean func_180462_a(int index, ItemStack stack, Direction direction) {
            return this.is_input_slot(index) && this.func_94041_b(index, stack);
        }

        public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
            return false;
        }

        public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return this.item_handlers[0].cast();
            }
            return super.getCapability(capability, facing);
        }

        private static int next_slot(int i) {
            return i < 17 ? i + 1 : 0;
        }

        private boolean spit_out(Direction facing) {
            return this.spit_out(facing, false);
        }

        private boolean spit_out(Direction facing, boolean all) {
            ItemStack stack = (ItemStack)this.stacks_.get(this.current_slot_index_);
            ItemStack drop = stack.func_77946_l();
            if (!all) {
                stack.func_190918_g(1);
                this.stacks_.set(this.current_slot_index_, (Object)stack);
                drop.func_190920_e(1);
            } else {
                this.stacks_.set(this.current_slot_index_, (Object)ItemStack.field_190927_a);
            }
            for (int i = 0; i < 8; ++i) {
                BlockPos p = this.field_174879_c.func_177967_a(facing, i);
                if (!this.field_145850_b.func_175623_d(p)) continue;
                this.field_145850_b.func_217376_c((Entity)new ItemEntity(this.field_145850_b, (double)p.func_177958_n() + 0.5, (double)p.func_177956_o() + 0.5, (double)p.func_177952_p() + 0.5, drop));
                this.field_145850_b.func_184133_a(null, p, SoundEvents.field_187638_cR, SoundCategory.BLOCKS, 0.7f, 0.8f);
                break;
            }
            return true;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private boolean try_place(Direction facing) {
            if (this.field_145850_b.field_72995_K) {
                return false;
            }
            BlockPos placement_pos = this.field_174879_c.func_177972_a(facing);
            if (this.field_145850_b.func_175625_s(placement_pos) != null) {
                return false;
            }
            ItemStack current_stack = ItemStack.field_190927_a;
            for (int i = 0; i < 18; ++i) {
                if (this.current_slot_index_ >= 18) {
                    this.current_slot_index_ = 0;
                }
                if (!(current_stack = (ItemStack)this.stacks_.get(this.current_slot_index_)).func_190926_b()) break;
                this.current_slot_index_ = PlacerTileEntity.next_slot(this.current_slot_index_);
            }
            if (current_stack.func_190926_b()) {
                this.current_slot_index_ = 0;
                return false;
            }
            boolean no_space = false;
            Item item = current_stack.func_77973_b();
            Block block = Block.func_149634_a((Item)item);
            if (block == Blocks.field_150350_a) {
                if (item != null) {
                    return this.spit_out(facing);
                }
            } else if (block instanceof IPlantable) {
                BlockState soilstate;
                if (this.field_145850_b.func_175623_d(placement_pos)) {
                    soilstate = this.field_145850_b.func_180495_p(placement_pos.func_177977_b());
                    if (!soilstate.func_177230_c().canSustainPlant(soilstate, (IBlockReader)this.field_145850_b, this.field_174879_c, Direction.UP, (IPlantable)block)) {
                        block = Blocks.field_150350_a;
                    }
                } else {
                    soilstate = this.field_145850_b.func_180495_p(placement_pos);
                    if (soilstate.func_177230_c() == block) {
                        block = Blocks.field_150350_a;
                        no_space = true;
                    } else if (!this.field_145850_b.func_175623_d(placement_pos.func_177984_a())) {
                        block = Blocks.field_150350_a;
                        no_space = true;
                    } else if (!soilstate.func_177230_c().canSustainPlant(soilstate, (IBlockReader)this.field_145850_b, this.field_174879_c, Direction.UP, (IPlantable)block)) {
                        block = Blocks.field_150350_a;
                    } else {
                        placement_pos = placement_pos.func_177984_a();
                    }
                }
            } else if (!this.field_145850_b.func_180495_p(placement_pos).func_185904_a().func_76222_j() || !this.field_145850_b.func_175647_a(Entity.class, new AxisAlignedBB(placement_pos), Entity::func_70067_L).isEmpty()) {
                block = Blocks.field_150350_a;
                no_space = true;
            }
            if (block != Blocks.field_150350_a) {
                try {
                    SoundType stype;
                    BlockState placement_state;
                    BlockItemUseContext use_context = null;
                    FakePlayer placer = FakePlayerFactory.getMinecraft((ServerWorld)((ServerWorld)this.field_145850_b));
                    if (placer != null) {
                        ItemStack placement_stack = current_stack.func_77946_l();
                        placement_stack.func_190920_e(1);
                        ItemStack held = placer.func_184586_b(Hand.MAIN_HAND);
                        placer.func_184611_a(Hand.MAIN_HAND, placement_stack);
                        use_context = new BlockItemUseContext(new ItemUseContext((PlayerEntity)placer, Hand.MAIN_HAND, new BlockRayTraceResult(new Vec3d(0.5, 0.0, 0.5), Direction.DOWN, placement_pos, false)));
                        placer.func_184611_a(Hand.MAIN_HAND, held);
                    }
                    BlockState blockState = placement_state = use_context == null ? block.func_176223_P() : block.func_196258_a(use_context);
                    if (placement_state == null) {
                        return this.spit_out(facing);
                    }
                    if (use_context != null && item instanceof BlockItem) {
                        if (((BlockItem)item).func_195942_a(use_context) == ActionResultType.SUCCESS) {
                            stype = block.getSoundType(placement_state, (IWorldReader)this.field_145850_b, this.field_174879_c, null);
                            if (stype != null) {
                                this.field_145850_b.func_184133_a(null, placement_pos, stype.func_185841_e(), SoundCategory.BLOCKS, stype.func_185843_a() * 0.6f, stype.func_185847_b());
                            }
                        } else {
                            if (!(block instanceof IPlantable)) return this.spit_out(facing);
                            if (this.field_145850_b.func_180501_a(placement_pos, placement_state, 11) && (stype = block.getSoundType(placement_state, (IWorldReader)this.field_145850_b, this.field_174879_c, null)) != null) {
                                this.field_145850_b.func_184133_a(null, placement_pos, stype.func_185841_e(), SoundCategory.BLOCKS, stype.func_185843_a() * 0.6f, stype.func_185847_b());
                            }
                        }
                    } else if (this.field_145850_b.func_180501_a(placement_pos, placement_state, 11) && (stype = block.getSoundType(placement_state, (IWorldReader)this.field_145850_b, this.field_174879_c, null)) != null) {
                        this.field_145850_b.func_184133_a(null, placement_pos, stype.func_185841_e(), SoundCategory.BLOCKS, stype.func_185843_a() * 0.6f, stype.func_185847_b());
                    }
                    current_stack.func_190918_g(1);
                    this.stacks_.set(this.current_slot_index_, (Object)current_stack);
                    return true;
                }
                catch (Throwable e) {
                    ModEngineersDecor.logger().error("Exception while trying to place " + (block == null ? "" : "" + block) + ", spitting out. Exception is: " + e);
                    this.field_145850_b.func_217377_a(placement_pos, false);
                    return this.spit_out(facing, true);
                }
            }
            if (no_space || current_stack.func_190926_b()) return false;
            for (int i = 0; i < 18; ++i) {
                this.current_slot_index_ = PlacerTileEntity.next_slot(this.current_slot_index_);
                if (!((ItemStack)this.stacks_.get(this.current_slot_index_)).func_190926_b()) return false;
            }
            return false;
        }

        public void func_73660_a() {
            if (this.field_145850_b.field_72995_K) {
                return;
            }
            if (--this.tick_timer_ > 0) {
                return;
            }
            this.tick_timer_ = 40;
            BlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (!(state.func_177230_c() instanceof PlacerBlock)) {
                this.block_power_signal_ = false;
                return;
            }
            boolean dirty = this.block_power_updated_;
            boolean rssignal = (this.logic_ & 1) != 0 == !this.block_power_signal_;
            boolean trigger = rssignal && (this.block_power_updated_ || (this.logic_ & 2) != 0);
            Direction placer_facing = (Direction)state.func_177229_b((IProperty)PlacerBlock.FACING);
            boolean tr = this.field_145850_b.func_175640_z(this.field_174879_c);
            this.block_power_updated_ = this.block_power_signal_ != tr;
            this.block_power_signal_ = tr;
            if (this.block_power_updated_) {
                dirty = true;
            }
            if (trigger && this.try_place(placer_facing)) {
                dirty = true;
            }
            if (dirty) {
                this.func_70296_d();
            }
            if (trigger && this.tick_timer_ > 40) {
                this.tick_timer_ = 40;
            }
        }

        static {
            for (int i = 0; i < 18; ++i) {
                PlacerTileEntity.SIDED_INV_SLOTS[i] = i;
            }
        }
    }

    public static class PlacerBlock
    extends StandardBlocks.Directed
    implements IDecorBlock {
        public PlacerBlock(long config, Block.Properties builder, AxisAlignedBB[] unrotatedAABB) {
            super(config, builder, unrotatedAABB);
        }

        @Override
        public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
            return VoxelShapes.func_197868_b();
        }

        public boolean func_149740_M(BlockState state) {
            return true;
        }

        public int func_180641_l(BlockState blockState, World world, BlockPos pos) {
            return Container.func_178144_a((TileEntity)world.func_175625_s(pos));
        }

        public boolean hasTileEntity(BlockState state) {
            return true;
        }

        @Nullable
        public TileEntity createTileEntity(BlockState state, IBlockReader world) {
            return new PlacerTileEntity();
        }

        public void func_180633_a(World world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
            if (world.field_72995_K) {
                return;
            }
            if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b("tedata")) {
                return;
            }
            CompoundNBT te_nbt = stack.func_77978_p().func_74775_l("tedata");
            if (te_nbt.isEmpty()) {
                return;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof PlacerTileEntity)) {
                return;
            }
            ((PlacerTileEntity)te).readnbt(te_nbt, false);
            ((PlacerTileEntity)te).reset_rtstate();
            ((PlacerTileEntity)te).func_70296_d();
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, World world, BlockPos pos, TileEntity te, boolean explosion) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            if (world.field_72995_K) {
                return stacks;
            }
            if (!(te instanceof PlacerTileEntity)) {
                return stacks;
            }
            if (!explosion) {
                ItemStack stack = new ItemStack((IItemProvider)this, 1);
                CompoundNBT te_nbt = ((PlacerTileEntity)te).clear_getnbt();
                if (!te_nbt.isEmpty()) {
                    CompoundNBT nbt = new CompoundNBT();
                    nbt.func_218657_a("tedata", (INBT)te_nbt);
                    stack.func_77982_d(nbt);
                }
                stacks.add(stack);
            } else {
                for (ItemStack stack : ((PlacerTileEntity)te).stacks_) {
                    if (stack.func_190926_b()) continue;
                    stacks.add(stack);
                }
                ((PlacerTileEntity)te).reset_rtstate();
            }
            return stacks;
        }

        public boolean func_220051_a(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
            if (world.field_72995_K) {
                return true;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof PlacerTileEntity)) {
                return true;
            }
            if (!(player instanceof ServerPlayerEntity) && !(player instanceof FakePlayer)) {
                return true;
            }
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)((INamedContainerProvider)te));
            return true;
        }

        public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean unused) {
            if (!(world instanceof World) || world.field_72995_K) {
                return;
            }
            TileEntity te = world.func_175625_s(pos);
            if (!(te instanceof PlacerTileEntity)) {
                return;
            }
            ((PlacerTileEntity)te).block_updated();
        }

        public boolean func_149744_f(BlockState state) {
            return true;
        }

        public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
            return 0;
        }

        public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
            return 0;
        }
    }
}

