/*
 * Decompiled with CFR 0.152.
 */
package wile.engineersdecor.libmc.blocks;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.WallBlock;
import net.minecraft.block.material.PushReaction;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.Fluids;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.engineersdecor.libmc.blocks.StandardBlocks;
import wile.engineersdecor.libmc.detail.Auxiliaries;

public class VariantWallBlock
extends WallBlock
implements StandardBlocks.IStandardBlock {
    private final VoxelShape[] shape_voxels_with_pole;
    private final VoxelShape[] shape_voxels_without_pole;
    private final VoxelShape[] collision_shape_voxels;
    public static final IntegerProperty TEXTURE_VARIANT = IntegerProperty.func_177719_a((String)"tvariant", (int)0, (int)3);

    public VariantWallBlock(long config, Block.Properties builder) {
        this(config, builder, 4.0f, 16.0f, 3.0f, 0.0f, 14.0f);
    }

    public VariantWallBlock(long config, Block.Properties builder, float pole_width, float pole_max_y, float side_width, float side_min_y, float side_max_y) {
        super(builder);
        pole_width = MathHelper.func_76131_a((float)pole_width, (float)2.0f, (float)8.0f);
        pole_max_y = MathHelper.func_76131_a((float)pole_max_y, (float)2.0f, (float)16.0f);
        side_width = MathHelper.func_76131_a((float)side_width, (float)2.0f, (float)8.0f);
        side_min_y = MathHelper.func_76131_a((float)side_min_y, (float)0.0f, (float)16.0f);
        side_max_y = MathHelper.func_76131_a((float)side_max_y, (float)1.0f, (float)16.0f);
        if (side_max_y <= side_min_y) {
            side_min_y = 0.0f;
            side_max_y = 16.0f;
        }
        this.shape_voxels_with_pole = this.buildWallShapes(pole_width, side_width, pole_max_y, side_min_y, side_max_y);
        this.shape_voxels_without_pole = this.buildWallShapes(side_width, side_width, side_max_y, side_min_y, side_max_y);
        this.collision_shape_voxels = this.buildWallShapes(pole_width, side_width, 24.0f, side_min_y, 24.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        Auxiliaries.Tooltip.addInformation(stack, world, tooltip, flag, true);
    }

    protected VoxelShape[] buildWallShapes(float pole_width, float side_width, float pole_height, float side_min_y, float side_max_y) {
        return super.func_196408_a(pole_width, side_width, pole_height, side_min_y, side_max_y);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return (Boolean)state.func_177229_b((IProperty)field_176256_a) != false ? this.shape_voxels_with_pole[this.func_196406_i(state)] : this.shape_voxels_without_pole[this.func_196406_i(state)];
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext selectionContext) {
        return this.collision_shape_voxels[this.func_196406_i(state)];
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{TEXTURE_VARIANT});
    }

    private boolean attachesTo(BlockState facingState, IWorldReader world, BlockPos facingPos, Direction side) {
        Block block = facingState.func_177230_c();
        if (block instanceof FenceGateBlock || block instanceof WallBlock) {
            return true;
        }
        BlockState oppositeState = world.func_180495_p(facingPos.func_177967_a(side, 2));
        if (!(oppositeState.func_177230_c() instanceof VariantWallBlock)) {
            return false;
        }
        return facingState.func_215686_e((IBlockReader)world, facingPos) && VariantWallBlock.func_220056_d((BlockState)facingState, (IBlockReader)world, (BlockPos)facingPos, (Direction)side);
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        IFluidState fs = context.func_195991_k().func_204610_c(context.func_195995_a());
        boolean n = this.attachesTo(world.func_180495_p(pos.func_177978_c()), (IWorldReader)world, pos.func_177978_c(), Direction.SOUTH);
        boolean e = this.attachesTo(world.func_180495_p(pos.func_177974_f()), (IWorldReader)world, pos.func_177974_f(), Direction.WEST);
        boolean s = this.attachesTo(world.func_180495_p(pos.func_177968_d()), (IWorldReader)world, pos.func_177968_d(), Direction.NORTH);
        boolean w = this.attachesTo(world.func_180495_p(pos.func_177976_e()), (IWorldReader)world, pos.func_177976_e(), Direction.EAST);
        boolean not_straight = !(n && s && !e && !w || !n && !s && e && w);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a((IProperty)field_176256_a, (Comparable)Boolean.valueOf(not_straight))).func_206870_a((IProperty)field_196409_a, (Comparable)Boolean.valueOf(n))).func_206870_a((IProperty)field_196411_b, (Comparable)Boolean.valueOf(e))).func_206870_a((IProperty)field_196413_c, (Comparable)Boolean.valueOf(s))).func_206870_a((IProperty)field_196414_y, (Comparable)Boolean.valueOf(w))).func_206870_a((IProperty)field_204514_u, (Comparable)Boolean.valueOf(fs.func_206886_c() == Fluids.field_204546_a));
    }

    public BlockState func_196271_a(BlockState state, Direction side, BlockState facingState, IWorld world, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)state.func_177229_b((IProperty)field_204514_u)).booleanValue()) {
            world.func_205219_F_().func_205360_a(currentPos, (Object)Fluids.field_204546_a, Fluids.field_204546_a.func_205569_a((IWorldReader)world));
        }
        if (side == Direction.DOWN) {
            return super.func_196271_a(state, side, facingState, world, currentPos, facingPos);
        }
        boolean n = side == Direction.NORTH ? this.attachesTo(facingState, (IWorldReader)world, facingPos, side) : ((Boolean)state.func_177229_b((IProperty)field_196409_a)).booleanValue();
        boolean e = side == Direction.EAST ? this.attachesTo(facingState, (IWorldReader)world, facingPos, side) : ((Boolean)state.func_177229_b((IProperty)field_196411_b)).booleanValue();
        boolean s = side == Direction.SOUTH ? this.attachesTo(facingState, (IWorldReader)world, facingPos, side) : ((Boolean)state.func_177229_b((IProperty)field_196413_c)).booleanValue();
        boolean w = side == Direction.WEST ? this.attachesTo(facingState, (IWorldReader)world, facingPos, side) : ((Boolean)state.func_177229_b((IProperty)field_196414_y)).booleanValue();
        boolean not_straight = !(n && s && !e && !w || !n && !s && e && w);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a((IProperty)field_176256_a, (Comparable)Boolean.valueOf(not_straight))).func_206870_a((IProperty)field_196409_a, (Comparable)Boolean.valueOf(n))).func_206870_a((IProperty)field_196411_b, (Comparable)Boolean.valueOf(e))).func_206870_a((IProperty)field_196413_c, (Comparable)Boolean.valueOf(s))).func_206870_a((IProperty)field_196414_y, (Comparable)Boolean.valueOf(w))).func_206870_a((IProperty)TEXTURE_VARIANT, (Comparable)Integer.valueOf((int)MathHelper.func_180186_a((Vec3i)currentPos) & 3));
    }

    public boolean func_220067_a(BlockState state, IBlockReader world, BlockPos pos, EntityType<?> entityType) {
        return false;
    }

    public boolean func_181623_g() {
        return false;
    }

    public PushReaction func_149656_h(BlockState state) {
        return PushReaction.NORMAL;
    }
}

