/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.api.type;

import com.creativemd.creativecore.common.config.api.CreativeConfig;
import com.creativemd.creativecore.common.config.api.ICreativeConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.vecmath.Color3b;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualCategory;

public abstract class VisualType
implements ICreativeConfig {
    private static List<VisualType> types = new ArrayList<VisualType>();
    @CreativeConfig
    public boolean enabled;
    @CreativeConfig
    @CreativeConfig.DecimalRange(max=1.0, min=0.0)
    public float opacity = 1.0f;
    public final String name;
    public final VisualCategory cat;

    public static Collection<VisualType> getTypes() {
        return types;
    }

    public VisualType(String name, VisualCategory cat) {
        this.name = name;
        this.cat = cat;
        types.add(this);
    }

    public boolean isAffectedByWater() {
        return this.cat.isAffectedByWater();
    }

    @SideOnly(value=Side.CLIENT)
    public abstract void loadResources(IResourceManager var1);

    @SideOnly(value=Side.CLIENT)
    public abstract void render(Visual var1, TextureManager var2, int var3, int var4, float var5);

    public void configured() {
    }

    @SideOnly(value=Side.CLIENT)
    public int getVariantAmount() {
        return 1;
    }

    public boolean supportsColor() {
        return false;
    }

    public Color3b getColor() {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void resize(Framebuffer buffer) {
    }

    public boolean isVisible(Visual visual) {
        return visual.opacity > 0.0f;
    }

    public int getWidth(int screenWidth) {
        return screenWidth;
    }

    public int getHeight(int screenHeight) {
        return screenHeight;
    }
}

