/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.addon.simpledifficulty;

import com.charles445.simpledifficulty.api.SDCapabilities;
import com.charles445.simpledifficulty.api.temperature.ITemperatureCapability;
import com.charles445.simpledifficulty.api.temperature.TemperatureEnum;
import com.charles445.simpledifficulty.api.temperature.TemperatureUtil;
import com.creativemd.creativecore.common.config.api.CreativeConfig;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeOverlay;
import team.creative.enhancedvisuals.client.VisualManager;

public class TemperatureHandler
extends VisualHandler {
    @CreativeConfig
    public double defaultIntensity = 0.0;
    @CreativeConfig
    public double mediumIntensity = 0.2;
    @CreativeConfig
    public double maxIntensity = 0.4;
    @CreativeConfig
    public double fadeFactor = 0.005;
    @CreativeConfig
    public VisualType freeze = new VisualTypeOverlay("freeze");
    public Visual freezeVisual;
    @CreativeConfig
    public VisualType heat = new VisualTypeOverlay("heat");
    public Visual heatVisual;

    @Override
    public void tick(@Nullable EntityPlayer player) {
        if (this.freezeVisual == null) {
            this.freezeVisual = new Visual(this.freeze, 0);
            this.freezeVisual.opacity = 0.0f;
            VisualManager.add(this.freezeVisual);
            this.heatVisual = new Visual(this.heat, 0);
            this.heatVisual.opacity = 0.0f;
            VisualManager.add(this.heatVisual);
        }
        double aimedHeat = this.defaultIntensity;
        double aimedFreeze = this.defaultIntensity;
        int temp = 12;
        if (player != null) {
            temp = ((ITemperatureCapability)player.getCapability(SDCapabilities.TEMPERATURE, null)).getTemperatureLevel();
        }
        TemperatureEnum enumRange = TemperatureUtil.getTemperatureEnum((int)temp);
        switch (enumRange) {
            case FREEZING: {
                aimedHeat = 0.0;
                aimedFreeze = this.maxIntensity;
                break;
            }
            case COLD: {
                aimedHeat = 0.0;
                aimedFreeze = this.mediumIntensity * (double)TemperatureHandler.getRangeModifier(temp, enumRange, true);
                break;
            }
            case NORMAL: {
                aimedHeat = this.defaultIntensity;
                aimedFreeze = this.defaultIntensity;
                break;
            }
            case HOT: {
                aimedHeat = this.mediumIntensity * (double)TemperatureHandler.getRangeModifier(temp, enumRange, false);
                aimedFreeze = 0.0;
                break;
            }
            case BURNING: {
                aimedHeat = this.maxIntensity;
                aimedFreeze = 0.0;
            }
        }
        if ((double)this.freezeVisual.opacity < aimedFreeze) {
            this.freezeVisual.opacity = (float)Math.min((double)this.freezeVisual.opacity + this.fadeFactor, aimedFreeze);
        } else if ((double)this.freezeVisual.opacity > aimedFreeze) {
            this.freezeVisual.opacity = (float)Math.max((double)this.freezeVisual.opacity - this.fadeFactor, aimedFreeze);
        }
        if ((double)this.heatVisual.opacity < aimedHeat) {
            this.heatVisual.opacity = (float)Math.min((double)this.heatVisual.opacity + this.fadeFactor, aimedHeat);
        } else if ((double)this.heatVisual.opacity > aimedHeat) {
            this.heatVisual.opacity = (float)Math.max((double)this.heatVisual.opacity - this.fadeFactor, aimedHeat);
        }
    }

    private static float getRangeModifier(int temp, TemperatureEnum enumRange, boolean cold) {
        int lowerBound = enumRange.getLowerBound();
        int upperBound = enumRange.getUpperBound();
        int range = upperBound - lowerBound;
        if (cold) {
            if (temp == lowerBound) {
                return 1.0f;
            }
            if (temp == upperBound) {
                return 0.0f;
            }
            float returnable = 1 - (temp - lowerBound) / range;
            return returnable;
        }
        if (temp == lowerBound) {
            return 0.0f;
        }
        if (temp == upperBound) {
            return 1.0f;
        }
        float returnable = (temp - lowerBound) / range;
        return returnable;
    }
}

