/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.packet;

import com.creativemd.creativecore.common.packet.CreativeCorePacket;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import team.creative.enhancedvisuals.common.handler.DamageHandler;
import team.creative.enhancedvisuals.common.handler.VisualHandlers;

public class DamagePacket
extends CreativeCorePacket {
    public String attackerClass;
    public ItemStack stack;
    public float damage;
    public float distance;
    public DamageHandler.EnhancedDamageSource source;

    public DamagePacket(LivingDamageEvent event) {
        this.damage = event.getAmount();
        Entity attacker = event.getSource().func_76364_f();
        if (attacker instanceof EntityLiving || attacker instanceof EntityArrow) {
            this.attackerClass = attacker.getClass().getName().toLowerCase();
            this.source = DamageHandler.EnhancedDamageSource.ATTACKER;
            if (attacker instanceof EntityLiving && ((EntityLiving)attacker).func_184614_ca() != null) {
                this.stack = ((EntityLiving)attacker).func_184614_ca();
            }
        } else {
            this.source = event.getSource() == DamageSource.field_76367_g ? DamageHandler.EnhancedDamageSource.CACTUS : (event.getSource() == DamageSource.field_76379_h || event.getSource() == DamageSource.field_82729_p ? DamageHandler.EnhancedDamageSource.FALL : (event.getSource().equals(DamageSource.field_76369_e) ? DamageHandler.EnhancedDamageSource.DROWN : (event.getSource().func_76347_k() || event.getSource() == DamageSource.field_76370_b ? DamageHandler.EnhancedDamageSource.FIRE : DamageHandler.EnhancedDamageSource.UNKOWN)));
        }
    }

    public DamagePacket() {
    }

    public void writeBytes(ByteBuf buf) {
        if (this.attackerClass != null) {
            buf.writeBoolean(true);
            DamagePacket.writeString((ByteBuf)buf, (String)this.attackerClass);
        } else {
            buf.writeBoolean(false);
        }
        if (this.stack != null) {
            buf.writeBoolean(true);
            DamagePacket.writeItemStack((ByteBuf)buf, (ItemStack)this.stack);
        } else {
            buf.writeBoolean(false);
        }
        buf.writeFloat(this.damage);
        buf.writeFloat(this.distance);
        buf.writeInt(this.source.ordinal());
    }

    public void readBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.attackerClass = DamagePacket.readString((ByteBuf)buf);
        }
        if (buf.readBoolean()) {
            this.stack = DamagePacket.readItemStack((ByteBuf)buf);
        }
        this.damage = buf.readFloat();
        this.distance = buf.readFloat();
        this.source = DamageHandler.EnhancedDamageSource.values()[buf.readInt()];
    }

    public void executeClient(EntityPlayer player) {
        if (VisualHandlers.DAMAGE.isEnabled(player)) {
            VisualHandlers.DAMAGE.playerDamaged(player, this);
        }
    }

    public void executeServer(EntityPlayer player) {
    }
}

