/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.DeathScreen;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import team.creative.enhancedvisuals.EnhancedVisuals;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualCategory;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.client.EVClient;
import team.creative.enhancedvisuals.client.VisualManager;

public class EVRenderer {
    private static Minecraft mc = Minecraft.func_71410_x();
    private static String lastRenderedMessage;
    private static int framebufferWidth;
    private static int framebufferHeight;
    public static boolean reloadResources;

    @SubscribeEvent
    public static void render(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.END && EVClient.shouldRender()) {
            if (reloadResources) {
                for (VisualType type : VisualType.getTypes()) {
                    type.loadResources(mc.func_195551_G());
                }
                reloadResources = false;
            }
            if (!(EVRenderer.mc.field_71462_r instanceof DeathScreen)) {
                if (EVRenderer.mc.func_147110_a().field_147621_c != framebufferWidth || EVRenderer.mc.func_147110_a().field_147618_d != framebufferHeight) {
                    for (VisualType type : VisualType.getTypes()) {
                        type.resize(mc.func_147110_a());
                    }
                    framebufferWidth = EVRenderer.mc.func_147110_a().field_147621_c;
                    framebufferHeight = EVRenderer.mc.func_147110_a().field_147618_d;
                }
                int screenWidth = mc.func_228018_at_().func_198107_o();
                int screenHeight = mc.func_228018_at_().func_198087_p();
                RenderSystem.pushMatrix();
                TextureManager manager = mc.func_110434_K();
                float partialTicks = event.renderTickTime;
                RenderSystem.disableLighting();
                RenderSystem.clear((int)256, (boolean)false);
                RenderSystem.matrixMode((int)5889);
                RenderSystem.loadIdentity();
                RenderSystem.ortho((double)0.0, (double)mc.func_228018_at_().func_198107_o(), (double)mc.func_228018_at_().func_198087_p(), (double)0.0, (double)1000.0, (double)3000.0);
                RenderSystem.matrixMode((int)5888);
                RenderSystem.loadIdentity();
                RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-2000.0f);
                RenderSystem.enableBlend();
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.disableAlphaTest();
                RenderSystem.enableBlend();
                EVRenderer.renderVisuals(VisualManager.visuals(VisualCategory.overlay), manager, screenWidth, screenHeight, partialTicks);
                EVRenderer.renderVisuals(VisualManager.visuals(VisualCategory.particle), manager, screenWidth, screenHeight, partialTicks);
                RenderSystem.disableBlend();
                RenderSystem.disableDepthTest();
                RenderSystem.disableAlphaTest();
                RenderSystem.enableTexture();
                RenderSystem.matrixMode((int)5890);
                RenderSystem.pushMatrix();
                RenderSystem.loadIdentity();
                EVRenderer.renderVisuals(VisualManager.visuals(VisualCategory.shader), manager, screenWidth, screenHeight, partialTicks);
                RenderSystem.popMatrix();
                RenderSystem.depthMask((boolean)true);
                RenderSystem.enableDepthTest();
                RenderSystem.enableAlphaTest();
                RenderSystem.enableBlend();
                RenderSystem.disableLighting();
                mc.func_147110_a().func_147610_a(true);
                RenderSystem.matrixMode((int)5888);
                RenderSystem.popMatrix();
            } else if (EnhancedVisuals.MESSAGES.enabled) {
                if (lastRenderedMessage == null) {
                    lastRenderedMessage = EnhancedVisuals.MESSAGES.pickRandomDeathMessage();
                }
                if (lastRenderedMessage != null) {
                    EVRenderer.mc.field_71466_p.func_211126_b("\"" + lastRenderedMessage + "\"", (float)(EVRenderer.mc.field_71462_r.width / 2 - EVRenderer.mc.field_71466_p.func_78256_a(lastRenderedMessage) / 2), 114.0f, 0xFFFFFF);
                }
            }
        }
    }

    private static void renderVisuals(Collection<Visual> visuals, TextureManager manager, int screenWidth, int screenHeight, float partialTicks) {
        if (visuals == null || visuals.isEmpty()) {
            return;
        }
        try {
            for (Visual visual : visuals) {
                if (!visual.isVisible()) continue;
                RenderSystem.pushMatrix();
                visual.render(manager, screenWidth, screenHeight, partialTicks);
                RenderSystem.popMatrix();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static {
        reloadResources = false;
    }
}

