/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.addon.survive;

import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeOverlay;
import team.creative.enhancedvisuals.client.VisualManager;

public class TemperatureHandler
extends VisualHandler {
    @CreativeConfig
    public double defaultIntensity = 0.0;
    @CreativeConfig
    public double mediumIntensity = 0.2;
    @CreativeConfig
    public double maxIntensity = 0.3;
    @CreativeConfig
    public double fadeFactor = 0.005;
    @CreativeConfig
    public VisualType freeze = new VisualTypeOverlay("freeze");
    public Visual freezeVisual;
    @CreativeConfig
    public VisualType heat = new VisualTypeOverlay("heat");
    public Visual heatVisual;
    @CreativeConfig
    public double coldestTemperature = 33.0;
    @CreativeConfig
    public double hypotheremiaTemperature = 35.0;
    @CreativeConfig
    public double coldTemperature = 36.0;
    @CreativeConfig
    public double defaultTemperature = 37.0;
    @CreativeConfig
    public double warmTemperature = 38.0;
    @CreativeConfig
    public double hyperthermiaTemperature = 39.0;
    @CreativeConfig
    public double hottestTemperature = 41.0;

    public double getTemperature(PlayerEntity player) {
        return player.getPersistentData().func_74769_h("survive:Temperature");
    }

    @Override
    public void tick(@Nullable PlayerEntity player) {
        if (this.freezeVisual == null) {
            this.freezeVisual = new Visual(this.freeze, 0);
            this.freezeVisual.opacity = 0.0f;
            VisualManager.add(this.freezeVisual);
            this.heatVisual = new Visual(this.heat, 0);
            this.heatVisual.opacity = 0.0f;
            VisualManager.add(this.heatVisual);
        }
        double aimedHeat = this.defaultIntensity;
        double aimedFreeze = this.defaultIntensity;
        double temp = this.defaultTemperature;
        if (player != null) {
            temp = this.getTemperature(player);
        }
        if (temp <= this.coldestTemperature) {
            aimedHeat = 0.0;
            aimedFreeze = this.maxIntensity;
        } else if (temp < this.hypotheremiaTemperature) {
            aimedHeat = 0.0;
            aimedFreeze = (1.0 - (temp - this.coldestTemperature) / (this.hypotheremiaTemperature - this.coldestTemperature)) * (this.maxIntensity - this.mediumIntensity) + this.mediumIntensity;
        } else if (temp < this.coldTemperature) {
            aimedHeat = 0.0;
            aimedFreeze = (1.0 - (temp - this.hypotheremiaTemperature) / (this.coldTemperature - this.hypotheremiaTemperature)) * this.mediumIntensity;
        } else if (temp >= this.hottestTemperature) {
            aimedHeat = this.maxIntensity;
            aimedFreeze = 0.0;
        } else if (temp > this.hyperthermiaTemperature) {
            aimedHeat = (this.hottestTemperature - temp) / (this.hottestTemperature - this.hyperthermiaTemperature) * (this.maxIntensity - this.mediumIntensity) + this.mediumIntensity;
            aimedFreeze = 0.0;
        } else if (temp > this.warmTemperature) {
            aimedHeat = (this.hyperthermiaTemperature - temp) / (this.hyperthermiaTemperature - this.warmTemperature) * this.mediumIntensity;
            aimedFreeze = 0.0;
        } else {
            aimedHeat = 0.0;
            aimedFreeze = 0.0;
        }
        if ((double)this.freezeVisual.opacity < aimedFreeze) {
            this.freezeVisual.opacity = (float)Math.min((double)this.freezeVisual.opacity + this.fadeFactor, aimedFreeze);
        } else if ((double)this.freezeVisual.opacity > aimedFreeze) {
            this.freezeVisual.opacity = (float)Math.max((double)this.freezeVisual.opacity - this.fadeFactor, aimedFreeze);
        }
        if ((double)this.heatVisual.opacity < aimedHeat) {
            this.heatVisual.opacity = (float)Math.min((double)this.heatVisual.opacity + this.fadeFactor, aimedHeat);
        } else if ((double)this.heatVisual.opacity > aimedHeat) {
            this.heatVisual.opacity = (float)Math.max((double)this.heatVisual.opacity - this.fadeFactor, aimedHeat);
        }
    }
}

