/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.addon.survive;

import javax.annotation.Nullable;
import net.minecraft.client.shader.Shader;
import net.minecraft.client.shader.ShaderDefault;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.premade.IntMinMax;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeShader;
import team.creative.enhancedvisuals.client.VisualManager;

public class ThirstHandler
extends VisualHandler {
    @CreativeConfig
    public double defaultIntensity = 0.0;
    @CreativeConfig
    public double maxIntensity = 5.0;
    @CreativeConfig
    public double fadeFactor = 0.05f;
    @CreativeConfig
    public IntMinMax thirstLevel = new IntMinMax(2, 8);
    @CreativeConfig
    public VisualType focus = new VisualTypeShader("focus", new ResourceLocation("shaders/post/blobs2.json")){

        @Override
        public void changeProperties(float intensity) {
            for (Shader mcShader : this.shaderGroup.getShaders()) {
                ShaderDefault shaderuniform = mcShader.func_217624_b().func_216538_b("Radius");
                if (shaderuniform == null) continue;
                shaderuniform.func_148090_a(intensity);
            }
        }
    };
    public Visual focusVisual;

    public double getThirst(PlayerEntity player) {
        return player.getPersistentData().func_74769_h("survive:Thirst");
    }

    @Override
    public void tick(@Nullable PlayerEntity player) {
        if (this.focusVisual == null) {
            this.focusVisual = new Visual(this.focus, 0);
            VisualManager.add(this.focusVisual);
        }
        double aimedSaturation = this.defaultIntensity;
        if (player != null) {
            double thirst = this.getThirst(player);
            if (thirst <= (double)this.thirstLevel.max) {
                double leftFoodInSpan = thirst - (double)this.thirstLevel.min;
                double spanLength = this.thirstLevel.spanLength();
                aimedSaturation = (1.0 - leftFoodInSpan / spanLength) * this.maxIntensity;
            }
            if ((double)this.focusVisual.opacity < aimedSaturation) {
                this.focusVisual.opacity = (float)Math.min((double)this.focusVisual.opacity + this.fadeFactor, aimedSaturation);
            } else if ((double)this.focusVisual.opacity > aimedSaturation) {
                this.focusVisual.opacity = (float)Math.max((double)this.focusVisual.opacity - this.fadeFactor, aimedSaturation);
            }
        }
    }
}

