/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.handler;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.creativecore.common.config.premade.curve.Curve;
import team.creative.creativecore.common.config.premade.curve.DecimalCurve;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeBlur;
import team.creative.enhancedvisuals.api.type.VisualTypeOverlay;
import team.creative.enhancedvisuals.client.VisualManager;

public class HeartbeatHandler
extends VisualHandler {
    @CreativeConfig
    public boolean useHealthPercentage = false;
    @CreativeConfig
    public int maxHealth = 6;
    @CreativeConfig
    public float maxHealthPercentage = 0.3f;
    @CreativeConfig
    public float heartbeatIntensity = 50.0f;
    @CreativeConfig
    public int heartbeatDuration = 5;
    @CreativeConfig
    public int minHeartbeatLength = 15;
    @CreativeConfig
    public float heartbeatTimeFactor = 100.0f;
    @CreativeConfig
    public float heartbeatVolume = 1.0f;
    @CreativeConfig
    public VisualType lowhealth = new VisualTypeOverlay("lowhealth");
    @CreativeConfig
    public VisualType blur = new VisualTypeBlur("blur");
    public int effectBufferTicks;

    @Override
    public void tick(@Nullable PlayerEntity player) {
        if (this.shouldHeartbeatTrigger(player)) {
            if (this.effectBufferTicks <= 0) {
                float intensity = this.getIntensity(player);
                this.resetBufferTicks(player);
                VisualManager.addVisualFadeOut(this.lowhealth, (Curve)new DecimalCurve(0.0, (double)Math.min(0.7f, intensity), (double)this.effectBufferTicks, 0.0));
                VisualManager.addVisualFadeOut(this.blur, (Curve)new DecimalCurve(0.0, (double)(Math.min(0.7f, intensity) * this.heartbeatIntensity), (double)this.heartbeatDuration, 0.0));
                this.playSound(new ResourceLocation("enhancedvisuals", "heartbeatout"), this.heartbeatVolume);
            } else if (this.effectBufferTicks == 5) {
                float intensity = this.getIntensity(player);
                this.playSound(new ResourceLocation("enhancedvisuals", "heartbeatin"), this.heartbeatVolume);
                VisualManager.addVisualFadeOut(this.blur, (Curve)new DecimalCurve(0.0, (double)(Math.min(0.7f, intensity) * this.heartbeatIntensity), (double)this.heartbeatDuration, 0.0));
            }
        }
        --this.effectBufferTicks;
    }

    private void resetBufferTicks(@Nonnull PlayerEntity player) {
        float percentHealthLeft = player.func_110143_aJ() / player.func_110138_aP();
        this.effectBufferTicks = (int)(percentHealthLeft * this.heartbeatTimeFactor + (float)this.minHeartbeatLength);
    }

    private float getIntensity(@Nonnull PlayerEntity player) {
        float percentHealthLeft = player.func_110143_aJ() / player.func_110138_aP();
        if (this.useHealthPercentage) {
            return (this.maxHealthPercentage - percentHealthLeft) * 2.0f;
        }
        return ((float)this.maxHealth - player.func_110143_aJ()) / player.func_110138_aP() * 2.0f;
    }

    private boolean shouldHeartbeatTrigger(@Nullable PlayerEntity player) {
        if (player != null) {
            if (this.useHealthPercentage) {
                float percentageHealth = player.func_110143_aJ() / player.func_110138_aP();
                return percentageHealth < this.maxHealthPercentage;
            }
            return player.func_110143_aJ() < (float)this.maxHealth;
        }
        return false;
    }
}

