/*
 * Decompiled with CFR 0.152.
 */
package team.creative.enhancedvisuals.common.handler;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityPredicate;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.monster.EndermanEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import team.creative.creativecore.common.config.api.CreativeConfig;
import team.creative.enhancedvisuals.api.Visual;
import team.creative.enhancedvisuals.api.VisualHandler;
import team.creative.enhancedvisuals.api.event.SelectEndermanEvent;
import team.creative.enhancedvisuals.api.type.VisualType;
import team.creative.enhancedvisuals.api.type.VisualTypeOverlay;
import team.creative.enhancedvisuals.client.VisualManager;

public class SlenderHandler
extends VisualHandler {
    @CreativeConfig
    public double defaultIntensity = 0.0;
    @CreativeConfig
    public double maxIntensity = 0.3;
    @CreativeConfig
    public double distanceFactor = 0.25;
    @CreativeConfig
    public VisualType slender = new VisualTypeOverlay("slender", 50);
    public Visual slenderVisual;
    public Class mutantEnderman = this.loadMutantEnderman();

    private Class loadMutantEnderman() {
        try {
            return Class.forName("chumbanotz.mutantbeasts.entity.mutant.MutantEndermanEntity");
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public void tick(@Nullable PlayerEntity player) {
        if (this.slenderVisual == null) {
            this.slenderVisual = new Visual(this.slender, 0);
            VisualManager.add(this.slenderVisual);
        }
        float intensity = (float)this.defaultIntensity;
        if (player != null) {
            float modifier = 0.0f;
            double d0 = player.func_226277_ct_();
            double d1 = player.func_226278_cu_();
            double d2 = player.func_226281_cx_();
            AxisAlignedBB box = player.func_174813_aQ();
            box = box.func_72314_b(16.0, 16.0, 16.0);
            SelectEndermanEvent event = new SelectEndermanEvent(new EntityPredicate());
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (!event.isCanceled()) {
                LivingEntity mob = player.field_70170_p.func_217360_a(EndermanEntity.class, event.predicate, (LivingEntity)player, d0, d1, d2, box);
                if (this.mutantEnderman != null) {
                    mob = player.field_70170_p.func_217360_a(this.mutantEnderman, EntityPredicate.field_221016_a, (LivingEntity)player, d0, d1, d2, box);
                }
                if (mob != null) {
                    float distModifier = (float)(1.0 / Math.pow(Math.sqrt(Math.pow(d0 - mob.func_226277_ct_(), 2.0) + Math.pow(d1 - mob.func_226278_cu_(), 2.0) + Math.pow(d2 - mob.func_226281_cx_(), 2.0)) / 3.0, 2.0));
                    if (distModifier > modifier && (modifier = distModifier) > 3.5f) {
                        modifier = 3.5f;
                    }
                    intensity = (float)Math.max(this.defaultIntensity, Math.min(this.maxIntensity, this.distanceFactor * (double)modifier));
                }
            }
        }
        this.slenderVisual.opacity = intensity;
    }
}

