/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.blocks;

import com.mcmoddev.golems.blocks.BlockUtility;
import com.mcmoddev.golems.entity.base.GolemBase;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockUtilityPower
extends BlockUtility {
    public static final IntegerProperty POWER_LEVEL = IntegerProperty.func_177719_a((String)"power", (int)0, (int)15);
    public static final int UPDATE_TICKS = 4;

    public BlockUtilityPower(int powerLevel, int tickRate) {
        super(Block.Properties.func_200945_a((Material)Material.field_151592_s).func_200944_c(), tickRate);
        this.func_180632_j((BlockState)this.func_176223_P().func_206870_a((IProperty)POWER_LEVEL, (Comparable)Integer.valueOf(powerLevel)));
    }

    public void func_225534_a_(BlockState state, ServerWorld worldIn, BlockPos pos, Random random) {
        boolean hasPowerGolem;
        AxisAlignedBB toCheck = new AxisAlignedBB(pos).func_186662_g(0.25);
        List list = worldIn.func_217357_a(GolemBase.class, toCheck);
        boolean bl = hasPowerGolem = list != null && !list.isEmpty() && BlockUtilityPower.hasPowerGolem(list);
        if (hasPowerGolem) {
            worldIn.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)worldIn));
        } else {
            this.remove((World)worldIn, state, pos, 3);
        }
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new IProperty[]{POWER_LEVEL});
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Integer)blockState.func_177229_b((IProperty)POWER_LEVEL);
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return (Integer)blockState.func_177229_b((IProperty)POWER_LEVEL);
    }

    public static boolean hasPowerGolem(List<GolemBase> golems) {
        for (GolemBase g : golems) {
            if (!g.isProvidingPower()) continue;
            return true;
        }
        return false;
    }
}

