/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;

public final class HoneyGolem
extends GolemBase {
    public static final String ALLOW_HONEY = "Allow Special: Honey";
    public static final String SPLITTING_CHILDREN = "Splitting Factor";
    private boolean allowHoney = this.getConfigBool("Allow Special: Honey");

    public HoneyGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world);
    }

    @Override
    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                this.applyHoney((LivingEntity)entityIn);
            }
            return true;
        }
        return false;
    }

    protected void func_70665_d(DamageSource source, float amount) {
        if (!this.func_180431_b(source)) {
            super.func_70665_d(source, amount);
            if (source.func_76364_f() instanceof LivingEntity) {
                this.applyHoney((LivingEntity)source.func_76364_f());
            }
        }
    }

    public void func_70645_a(DamageSource source) {
        int children = this.getConfigInt(SPLITTING_CHILDREN);
        if (children > 0) {
            this.trySpawnChildren(children);
        }
        super.func_70645_a(source);
    }

    @Override
    public void setChild(boolean isChild) {
        super.setChild(isChild);
        if (isChild) {
            this.allowHoney = false;
        }
    }

    private boolean applyHoney(LivingEntity entity) {
        if (!this.func_70631_g_() && this.allowHoney) {
            int len = 20 * (3 + this.field_70146_Z.nextInt(3));
            int amp = 3 + this.field_70146_Z.nextInt(2);
            return entity.func_195064_c(new EffectInstance(Effects.field_76421_d, len, amp));
        }
        return false;
    }
}

