/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.events.IceGolemFreezeEvent;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public final class IceGolem
extends GolemBase {
    public static final String AOE = "Area of Effect";
    public static final String FROST = "Use Frosted Ice";

    public IceGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(2, (Goal)new FreezeBlocksGoal(this, this.getConfigInt(AOE), this.getConfigBool(FROST)));
    }

    public void func_70636_d() {
        super.func_70636_d();
        BlockPos pos = this.func_180425_c();
        if (this.field_70170_p.func_226691_t_(pos).func_225486_c(pos) > 1.0f) {
            this.func_70097_a(DamageSource.field_76370_b, 1.0f);
        }
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (entity.func_70027_ad()) {
                this.func_70097_a(DamageSource.field_76377_j, 0.5f);
            }
            return true;
        }
        return false;
    }

    public static class FreezeBlocksGoal
    extends Goal {
        protected final GolemBase golem;
        protected final int range;
        protected final boolean frosted;

        public FreezeBlocksGoal(GolemBase golemIn, int rangeIn, boolean useFrost) {
            this.golem = golemIn;
            this.range = rangeIn;
            this.frosted = useFrost;
        }

        public boolean func_75250_a() {
            return this.golem.field_70173_aa % 2 == 0;
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75249_e() {
            IceGolemFreezeEvent event;
            BlockPos below = this.golem.getBlockBelow();
            if (this.range > 0 && !MinecraftForge.EVENT_BUS.post((Event)(event = new IceGolemFreezeEvent(this.golem, below, this.range, this.frosted))) && event.getResult() != Event.Result.DENY) {
                this.freezeBlocks(event.getAffectedPositions(), event.getFunction(), event.updateFlag);
            }
        }

        public boolean freezeBlocks(List<BlockPos> positions, Function<BlockState, BlockState> function, int updateFlag) {
            boolean flag = true;
            for (BlockPos pos : positions) {
                flag &= this.golem.func_130014_f_().func_180501_a(pos, function.apply(this.golem.func_130014_f_().func_180495_p(pos)), updateFlag);
            }
            return flag;
        }
    }
}

