/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public final class SlimeGolem
extends GolemBase {
    public static final String ALLOW_SPECIAL = "Allow Special: Extra Knockback";
    public static final String SPLITTING_CHILDREN = "Splitting Factor";
    public static final String KNOCKBACK = "Knockback Factor";
    private boolean allowKnockback = this.getConfigBool("Allow Special: Extra Knockback");
    private double knockbackAmount = this.getConfigDouble("Knockback Factor");

    public SlimeGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (super.func_70652_k(entity)) {
            if (!this.func_70631_g_() && this.allowKnockback && !(entity instanceof SlimeEntity)) {
                this.applyKnockback(entity, this.knockbackAmount);
            }
            return true;
        }
        return false;
    }

    protected void func_70665_d(DamageSource source, float amount) {
        if (!this.func_180431_b(source)) {
            super.func_70665_d(source, amount);
            if (this.allowKnockback && !this.func_70631_g_() && source.func_76364_f() != null) {
                this.applyKnockback(source.func_76364_f(), this.getConfigDouble(KNOCKBACK));
            }
        }
    }

    @Override
    public void setChild(boolean isChild) {
        super.setChild(isChild);
        if (isChild) {
            this.allowKnockback = false;
        }
    }

    public void func_70645_a(DamageSource source) {
        int children = this.getConfigInt(SPLITTING_CHILDREN);
        if (children > 0) {
            this.trySpawnChildren(children);
        }
        super.func_70645_a(source);
    }

    private void applyKnockback(Entity entity, double knockbackFactor) {
        Vec3d myPos = this.func_213303_ch();
        Vec3d ePos = entity.func_213303_ch();
        double dX = Math.signum(ePos.field_72450_a - myPos.field_72450_a) * knockbackFactor;
        double dZ = Math.signum(ePos.field_72449_c - myPos.field_72449_c) * knockbackFactor;
        entity.func_70024_g(dX, knockbackFactor / 2.0, dZ);
        entity.field_70133_I = true;
    }
}

