/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.items.ItemBedrockGolem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;

public class TNTGolem
extends GolemBase {
    protected static final DataParameter<Boolean> DATA_IGNITED = EntityDataManager.func_187226_a(TNTGolem.class, (IDataSerializer)DataSerializers.field_187198_h);
    public static final String ALLOW_SPECIAL = "Allow Special: Explode";
    protected final int minExplosionRad;
    protected final int maxExplosionRad;
    protected final int fuseLen;
    protected final int chanceToExplodeWhenAttacking;
    protected boolean allowedToExplode = false;
    protected boolean willExplode;
    protected int fuseTimer;

    public TNTGolem(EntityType<? extends GolemBase> entityType, World world) {
        this(entityType, world, 6, 10, 50, 10);
        this.allowedToExplode = this.getConfigBool(ALLOW_SPECIAL);
    }

    public TNTGolem(EntityType<? extends GolemBase> entityType, World world, int minExplosionRange, int maxExplosionRange, int minFuseLength, int randomExplosionChance) {
        super(entityType, world);
        this.minExplosionRad = minExplosionRange;
        this.maxExplosionRad = maxExplosionRange;
        this.fuseLen = minFuseLength;
        this.chanceToExplodeWhenAttacking = randomExplosionChance;
        this.resetIgnite();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_IGNITED, (Object)false);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70027_ad()) {
            this.ignite();
        }
        if (this.func_70026_G() || this.func_70638_az() != null && this.func_70068_e((Entity)this.func_70638_az()) > (double)(this.minExplosionRad * this.maxExplosionRad)) {
            this.resetIgnite();
        }
        if (this.isIgnited()) {
            this.func_213293_j(0.0, this.func_213322_ci().func_82617_b(), 0.0);
            --this.fuseTimer;
            Vec3d pos = this.func_213303_ch();
            ItemBedrockGolem.spawnParticles(this.field_70170_p, pos.field_72450_a, pos.field_72448_b + 1.0, pos.field_72449_c, 0.21, (IParticleData)ParticleTypes.field_197601_L, 6);
            if (this.fuseTimer <= 0) {
                this.willExplode = true;
            }
        }
        if (this.willExplode) {
            this.explode();
        }
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
        this.explode();
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean flag = super.func_70652_k(entity);
        if (flag && entity.func_70089_S() && this.field_70146_Z.nextInt(100) < this.chanceToExplodeWhenAttacking && this.func_70068_e(entity) <= (double)(this.minExplosionRad * this.minExplosionRad)) {
            this.ignite();
        }
        return flag;
    }

    @Override
    protected boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!itemstack.func_190926_b() && itemstack.func_77973_b() == Items.field_151033_d) {
            Vec3d pos = this.func_213303_ch();
            this.field_70170_p.func_184148_a(player, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.field_187649_bu, this.func_184176_by(), 1.0f, this.field_70146_Z.nextFloat() * 0.4f + 0.8f);
            player.func_184609_a(hand);
            if (!this.field_70170_p.field_72995_K) {
                this.func_70015_d(Math.floorDiv(this.fuseLen, 20));
                this.ignite();
                itemstack.func_222118_a(1, (LivingEntity)player, c -> c.func_213334_d(hand));
            }
        }
        return super.func_184645_a(player, hand);
    }

    protected void resetFuse() {
        this.fuseTimer = this.fuseLen + this.field_70146_Z.nextInt(Math.floorDiv(this.fuseLen, 2) + 1);
    }

    protected void setIgnited(boolean toSet) {
        this.func_184212_Q().func_187227_b(DATA_IGNITED, (Object)toSet);
    }

    protected boolean isIgnited() {
        return (Boolean)this.func_184212_Q().func_187225_a(DATA_IGNITED);
    }

    protected void ignite() {
        if (!this.isIgnited()) {
            this.setIgnited(true);
            this.resetFuse();
            if (!this.func_70026_G()) {
                this.func_184185_a(SoundEvents.field_187572_ar, 0.9f, this.field_70146_Z.nextFloat());
            }
        }
    }

    protected void resetIgnite() {
        this.setIgnited(false);
        this.resetFuse();
        this.willExplode = false;
    }

    protected void explode() {
        if (this.allowedToExplode) {
            if (!this.field_70170_p.field_72995_K) {
                boolean flag = this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b);
                float range = this.maxExplosionRad > this.minExplosionRad ? (float)(this.minExplosionRad + this.field_70146_Z.nextInt(this.maxExplosionRad - this.minExplosionRad)) : (float)this.minExplosionRad;
                Vec3d pos = this.func_213303_ch();
                this.field_70170_p.func_217385_a((Entity)this, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, range, flag ? Explosion.Mode.BREAK : Explosion.Mode.NONE);
                this.func_70106_y();
            }
        } else {
            this.resetIgnite();
        }
    }
}

