/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.integration;

import com.mcmoddev.golems.entity.BedrockGolem;
import com.mcmoddev.golems.entity.DispenserGolem;
import com.mcmoddev.golems.entity.FurnaceGolem;
import com.mcmoddev.golems.entity.RedstoneLampGolem;
import com.mcmoddev.golems.entity.base.GolemBase;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class GolemDescriptionManager {
    protected boolean showSpecial = true;
    protected boolean showSpecialChild = false;
    protected boolean showMultiTexture = true;
    protected boolean showAttack = true;
    protected boolean showFireproof = true;
    protected boolean showKnockbackResist = false;

    public List<ITextComponent> getEntityDescription(GolemBase golem) {
        LinkedList<ITextComponent> list = new LinkedList<ITextComponent>();
        if (this.showAttack) {
            double attack = golem.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            list.add(new TranslationTextComponent("entitytip.attack", new Object[0]).func_211708_a(TextFormatting.GRAY).func_150257_a((ITextComponent)new StringTextComponent(": ")).func_150257_a(new StringTextComponent(Double.toString(attack)).func_211708_a(TextFormatting.WHITE)));
        }
        if (this.showMultiTexture && golem.canInteractChangeTexture() && !(golem instanceof RedstoneLampGolem)) {
            list.add(new TranslationTextComponent("entitytip.click_change_texture", new Object[0]).func_211708_a(TextFormatting.BLUE));
        }
        if (this.showFireproof && golem.func_70045_F() && !(golem instanceof BedrockGolem)) {
            list.add(new TranslationTextComponent("entitytip.is_fireproof", new Object[0]).func_211708_a(TextFormatting.GOLD));
        }
        if (this.showKnockbackResist && golem.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111125_b() > 0.8999) {
            list.add(new TranslationTextComponent("attribute.name.generic.knockbackResistance", new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
        if (this.showSpecial) {
            if (golem instanceof FurnaceGolem) {
                this.addFurnaceGolemInfo((FurnaceGolem)golem, list);
            }
            if (golem instanceof DispenserGolem) {
                this.addDispenserGolemInfo((DispenserGolem)golem, list);
            }
        }
        if (!golem.func_70631_g_() && this.showSpecial || golem.func_70631_g_() && this.showSpecialChild) {
            golem.getGolemContainer().addDescription(list);
        }
        return list;
    }

    protected void addFurnaceGolemInfo(FurnaceGolem g, List<ITextComponent> list) {
        int fuel = g.getFuel();
        int percentFuel = (int)Math.ceil(g.getFuelPercentage() * 100.0f);
        TextFormatting color = percentFuel < 6 ? TextFormatting.RED : (percentFuel < 16 ? TextFormatting.YELLOW : TextFormatting.WHITE);
        String fuelString = GolemDescriptionManager.isShiftDown() ? Integer.toString(fuel) : Integer.toString(percentFuel) + "%";
        list.add(new TranslationTextComponent("entitytip.fuel", new Object[0]).func_211708_a(TextFormatting.GRAY).func_150257_a((ITextComponent)new StringTextComponent(": ")).func_150257_a(new StringTextComponent(fuelString).func_211708_a(color)));
    }

    protected void addDispenserGolemInfo(DispenserGolem g, List<ITextComponent> list) {
        int arrows = g.getArrowsInInventory();
        if (arrows > 0 && GolemDescriptionManager.isShiftDown()) {
            TextFormatting color = TextFormatting.WHITE;
            String arrowString = Integer.toString(arrows);
            list.add(new TranslationTextComponent("entitytip.arrows", new Object[0]).func_211708_a(TextFormatting.GRAY).func_150257_a((ITextComponent)new StringTextComponent(": ")).func_150257_a(new StringTextComponent(arrowString).func_211708_a(color)));
        }
    }

    protected static boolean isShiftDown() {
        return Screen.hasShiftDown();
    }
}

