/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.proxies;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemColorized;
import com.mcmoddev.golems.gui.GuiDispenserGolem;
import com.mcmoddev.golems.main.GolemItems;
import com.mcmoddev.golems.proxies.ProxyCommon;
import com.mcmoddev.golems.renders.RenderColoredGolem;
import com.mcmoddev.golems.renders.RenderGolem;
import com.mcmoddev.golems.util.config.GolemRegistrar;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.entity.EntityType;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public final class ProxyClient
extends ProxyCommon {
    public static final IRenderFactory<GolemBase> FACTORY_TEXTURED_GOLEM = RenderGolem::new;
    public static final IRenderFactory<GolemColorized> FACTORY_COLORED_GOLEM = RenderColoredGolem::new;

    @Override
    public void registerListeners() {
    }

    @Override
    public void registerContainerRenders() {
        ScreenManager.func_216911_a(GolemItems.DISPENSER_GOLEM, GuiDispenserGolem::new);
    }

    @Override
    public void registerEntityRenders() {
        GolemRegistrar.getContainers().forEach(container -> {
            if (container.useDefaultRender()) {
                if (GolemColorized.class.isAssignableFrom(container.getEntityClass())) {
                    ProxyClient.registerColorized(container.getEntityType());
                } else {
                    ProxyClient.registerTextured(container.getEntityType());
                }
            }
        });
    }

    public static void registerTextured(EntityType<? extends GolemBase> type) {
        RenderingRegistry.registerEntityRenderingHandler(type, FACTORY_TEXTURED_GOLEM);
    }

    public static void registerColorized(EntityType<? extends GolemColorized> type) {
        RenderingRegistry.registerEntityRenderingHandler(type, FACTORY_COLORED_GOLEM);
    }
}

