/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemMultiColorized;
import com.mcmoddev.golems.util.GolemTextureBytes;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public final class ConcreteGolem
extends GolemMultiColorized {
    public static final String ALLOW_RESIST = "Allow Special: Resistance";
    private static final ResourceLocation TEXTURE_BASE = GolemBase.makeTexture("golems", "golem_concrete_base");
    private static final ResourceLocation TEXTURE_OVERLAY = GolemBase.makeTexture("golems", "golem_concrete_grayscale");

    public ConcreteGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world, "golems", TEXTURE_BASE, TEXTURE_OVERLAY, DYE_COLORS);
        this.func_184644_a(PathNodeType.WATER, -0.8f);
    }

    protected void func_70665_d(DamageSource source, float amount) {
        if (this.getConfigBool(ALLOW_RESIST)) {
            amount *= 0.6f;
            if (source.func_76347_k()) {
                amount *= 0.85f;
            }
        }
        super.func_70665_d(source, amount);
    }

    @Override
    public Map<Block, Byte> getTextureBytes() {
        return GolemTextureBytes.CONCRETE;
    }

    @Override
    public ItemStack getCreativeReturn(RayTraceResult target) {
        return new ItemStack((IItemProvider)GolemTextureBytes.getByByte(GolemTextureBytes.CONCRETE, (byte)this.getTextureNum()));
    }
}

