/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemMultiTextured;
import com.mcmoddev.golems.items.ItemBedrockGolem;
import com.mcmoddev.golems.util.GolemTextureBytes;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.CoralBlock;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public final class CoralGolem
extends GolemMultiTextured {
    private static final DataParameter<Boolean> DRY = EntityDataManager.func_187226_a(CoralGolem.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> CHANGE_TIME = EntityDataManager.func_187226_a(CoralGolem.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final String KEY_DRY = "isDry";
    private static final String KEY_CHANGE = "changeTime";
    public static final String ALLOW_HEALING = "Allow Special: Healing";
    public static final String DRY_TIMER = "Max Wet Time";
    public static final String[] VARIANTS = new String[]{"tube", "brain", "bubble", "fire", "horn"};
    public final ResourceLocation[] variantsDry = new ResourceLocation[VARIANTS.length];
    private final boolean allowHealing;
    private final int maxChangingTime;

    public CoralGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world, "golems", VARIANTS);
        int len = VARIANTS.length;
        for (int n = 0; n < len; ++n) {
            this.variantsDry[n] = CoralGolem.makeTexture("golems", this.getGolemContainer().getName() + "/" + VARIANTS[n] + "_dead");
        }
        this.allowHealing = this.getConfigBool(ALLOW_HEALING);
        this.maxChangingTime = this.getConfigInt(DRY_TIMER);
    }

    public boolean isDry() {
        return (Boolean)this.func_184212_Q().func_187225_a(DRY);
    }

    public void setDry(boolean isDry) {
        if (this.isDry() != isDry) {
            this.func_184212_Q().func_187227_b(DRY, (Object)isDry);
        }
    }

    public int getChangingTime() {
        return (Integer)this.func_184212_Q().func_187225_a(CHANGE_TIME);
    }

    public void addChangingTime(int toAdd) {
        if (toAdd != 0) {
            this.func_184212_Q().func_187227_b(CHANGE_TIME, (Object)(this.getChangingTime() + toAdd));
        }
    }

    public void setChangingTime(int toSet) {
        this.func_184212_Q().func_187227_b(CHANGE_TIME, (Object)toSet);
    }

    protected void func_70665_d(DamageSource source, float amount) {
        if (this.isDry()) {
            amount *= 0.7f;
        }
        super.func_70665_d(source, amount);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DRY, (Object)false);
        this.func_184212_Q().func_187214_a(CHANGE_TIME, (Object)0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_70613_aW() && !this.field_70170_p.field_72995_K) {
            boolean isChanging;
            boolean bl = isChanging = this.func_70090_H() == this.isDry();
            if (isChanging) {
                this.addChangingTime(1);
                if (this.getChangingTime() > this.maxChangingTime) {
                    this.setDry(!this.func_70090_H());
                    this.setChangingTime(0);
                }
            } else {
                this.setChangingTime(0);
            }
            if (!this.isDry()) {
                if (isChanging && this.func_70026_G() && this.getChangingTime() > 0 && this.field_70146_Z.nextInt(3) == 0) {
                    this.addChangingTime(-1);
                }
                if (this.allowHealing && this.field_70146_Z.nextInt(650) == 0) {
                    this.func_195064_c(new EffectInstance(Effects.field_76428_l, 50, 1));
                }
            }
        }
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (DRY.equals(key)) {
            this.setDry((Boolean)this.func_184212_Q().func_187225_a(DRY));
            if (this.isDry()) {
                double dryHealth = Math.floor(this.getGolemContainer().getHealth() * 0.7 * 10.0) / 10.0;
                double dryAttack = Math.floor(this.getGolemContainer().getAttack() * 1.45 * 10.0) / 10.0;
                double drySpeed = Math.floor(this.getGolemContainer().getSpeed() * 0.7 * 100.0) / 100.0;
                this.func_110148_a(Attributes.field_233818_a_).func_111128_a(dryHealth);
                this.func_110148_a(Attributes.field_233823_f_).func_111128_a(dryAttack);
                this.func_110148_a(Attributes.field_233821_d_).func_111128_a(drySpeed);
                Vector3d pos = this.func_213303_ch().func_72441_c(0.0, 0.2, 0.0);
                ItemBedrockGolem.spawnParticles(this.field_70170_p, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.09, (IParticleData)ParticleTypes.field_197601_L, 80);
            } else {
                this.func_110148_a(Attributes.field_233818_a_).func_111128_a(this.getGolemContainer().getHealth());
                this.func_110148_a(Attributes.field_233823_f_).func_111128_a(this.getGolemContainer().getAttack());
                this.func_110148_a(Attributes.field_233821_d_).func_111128_a(this.getGolemContainer().getSpeed());
            }
        }
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a(KEY_DRY, this.isDry());
        nbt.func_74774_a(KEY_CHANGE, (byte)this.getChangingTime());
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setDry(nbt.func_74767_n(KEY_DRY));
        this.setChangingTime(nbt.func_74771_c(KEY_CHANGE));
    }

    @Override
    public ResourceLocation[] getTextureArray() {
        return this.isDry() ? this.variantsDry : super.getTextureArray();
    }

    @Override
    public void onBuilt(BlockState body, BlockState legs, BlockState arm1, BlockState arm2) {
        this.setDry(!(body.func_177230_c() instanceof CoralBlock));
        super.onBuilt(body, legs, arm1, arm2);
    }

    @Override
    public ItemStack getCreativeReturn(RayTraceResult target) {
        return new ItemStack((IItemProvider)GolemTextureBytes.getByByte(this.isDry() ? GolemTextureBytes.CORAL_DEAD : GolemTextureBytes.CORAL, (byte)this.getTextureNum()));
    }

    @Override
    public boolean shouldMoveToWater(Vector3d target) {
        if (this.isDry()) {
            return true;
        }
        double dis = this.func_213303_ch().func_72438_d(target);
        return dis > 8.0 && this.getTimeUntilChange() < 60;
    }

    @Override
    public Map<Block, Byte> getTextureBytes() {
        return this.isDry() ? GolemTextureBytes.CORAL_DEAD : GolemTextureBytes.CORAL;
    }

    public int getTimeUntilChange() {
        return this.maxChangingTime - this.getChangingTime();
    }
}

