/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.container.ContainerDispenserGolem;
import com.mcmoddev.golems.entity.base.GolemBase;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public final class DispenserGolem
extends GolemBase
implements IRangedAttackMob,
IInventoryChangedListener {
    private static final DataParameter<Integer> ARROWS = EntityDataManager.func_187226_a(DispenserGolem.class, (IDataSerializer)DataSerializers.field_187192_b);
    public static final String ALLOW_SPECIAL = "Allow Special: Shoot Arrows";
    public static final String ARROW_DAMAGE = "Arrow Damage";
    public static final String ARROW_SPEED = "Arrow Speed";
    private static final String KEY_INVENTORY = "Items";
    private static final String KEY_SLOT = "Slot";
    private static final int INVENTORY_SIZE = 9;
    private boolean allowArrows = this.getConfigBool("Allow Special: Shoot Arrows");
    private double arrowDamage = Math.max(0.0, this.getConfigDouble("Arrow Damage"));
    private int arrowSpeed = this.getConfigInt("Arrow Speed");
    private Inventory inventory;
    private final RangedAttackGoal aiArrowAttack = new RangedAttackGoal((IRangedAttackMob)this, 1.0, this.arrowSpeed, 32.0f);
    private final MeleeAttackGoal aiMeleeAttack = new MeleeAttackGoal((CreatureEntity)this, 1.0, true);

    public DispenserGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world);
        this.func_110148_a(Attributes.field_233819_b_).func_111128_a(32.0);
        this.initInventory();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(ARROWS, (Object)0);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(4, (Goal)new FindArrowsGoal(10.0));
    }

    protected void func_82167_n(Entity entityIn) {
        super.func_82167_n(entityIn);
        this.updateCombatTask(entityIn != null && this.func_70643_av() != null && entityIn == this.func_70643_av());
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70173_aa % 50 == 0) {
            boolean forceMelee = !this.allowArrows || this.func_70643_av() != null && this.func_70643_av().func_70068_e((Entity)this) < 4.5;
            this.updateCombatTask(forceMelee);
        }
        this.field_70170_p.func_217381_Z().func_76320_a("dispenserGolemLooting");
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.field_70729_aU && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223599_b) && ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this)) {
            List droppedArrows = this.func_130014_f_().func_175647_a(ItemEntity.class, this.func_174813_aQ().func_72314_b(1.0, 0.0, 1.0), e -> !e.func_174874_s() && e.func_92059_d().func_77973_b() instanceof ArrowItem);
            for (ItemEntity i : droppedArrows) {
                int arrowCountBefore = this.getArrowsInInventory();
                ItemStack item = i.func_92059_d().func_77946_l();
                i.func_92058_a(this.inventory.func_174894_a(item));
                int arrowCountAfter = this.updateArrowsInInventory();
                this.func_71001_a((Entity)i, arrowCountAfter - arrowCountBefore);
            }
        }
        this.field_70170_p.func_217381_Z().func_76319_b();
    }

    @Override
    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (!player.func_213453_ef() && player instanceof ServerPlayerEntity) {
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new ContainerDispenserGolem.Provider((IInventory)this.inventory));
            player.func_184609_a(hand);
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean func_70097_a(DamageSource src, float amnt) {
        if (super.func_70097_a(src, amnt)) {
            if (src instanceof IndirectEntityDamageSource && src.func_76346_g() instanceof LivingEntity) {
                this.func_70604_c((LivingEntity)src.func_76346_g());
            }
            return true;
        }
        return false;
    }

    public void func_213337_cE() {
        int l = this.inventory.func_70302_i_();
        for (int i = 0; i < l; ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            this.func_199701_a_(stack.func_77946_l());
            this.inventory.func_70299_a(i, ItemStack.field_190927_a);
        }
        this.func_76316_a((IInventory)this.inventory);
    }

    @Override
    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        ListNBT list = tag.func_150295_c(KEY_INVENTORY, 10);
        this.initInventory();
        for (int i = 0; i < list.size(); ++i) {
            CompoundNBT slotNBT = list.func_150305_b(i);
            int slotNum = slotNBT.func_74771_c(KEY_SLOT) & 0xFF;
            if (slotNum < 0 || slotNum >= this.inventory.func_70302_i_()) continue;
            this.inventory.func_70299_a(slotNum, ItemStack.func_199557_a((CompoundNBT)slotNBT));
        }
        this.func_76316_a((IInventory)this.inventory);
    }

    @Override
    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        ListNBT listNBT = new ListNBT();
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            CompoundNBT slotNBT = new CompoundNBT();
            slotNBT.func_74774_a(KEY_SLOT, (byte)i);
            stack.func_77955_b(slotNBT);
            listNBT.add((Object)slotNBT);
        }
        tag.func_218657_a(KEY_INVENTORY, (INBT)listNBT);
    }

    private void initInventory() {
        Inventory inv = this.inventory;
        this.inventory = new Inventory(9);
        if (inv != null) {
            inv.func_110132_b((IInventoryChangedListener)this);
            int i = Math.min(inv.func_70302_i_(), this.inventory.func_70302_i_());
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inv.func_70301_a(j);
                if (itemstack.func_190926_b()) continue;
                this.inventory.func_70299_a(j, itemstack.func_77946_l());
            }
        }
        this.inventory.func_110134_a((IInventoryChangedListener)this);
        this.func_76316_a((IInventory)this.inventory);
    }

    public void func_76316_a(IInventory inv) {
        if (this.func_70613_aW()) {
            this.updateArrowsInInventory();
            this.updateCombatTask();
        }
    }

    private static ItemStack findArrowsInInventory(IInventory inv) {
        int l = inv.func_70302_i_();
        for (int i = 0; i < l; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArrowItem)) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private int updateArrowsInInventory() {
        int arrowCount = 0;
        int l = this.inventory.func_70302_i_();
        for (int i = 0; i < l; ++i) {
            ItemStack stack = this.inventory.func_70301_a(i);
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ArrowItem)) continue;
            arrowCount += stack.func_190916_E();
        }
        if (arrowCount != this.getArrowsInInventory()) {
            this.func_184212_Q().func_187227_b(ARROWS, (Object)arrowCount);
        }
        return arrowCount;
    }

    public int getArrowsInInventory() {
        return (Integer)this.func_184212_Q().func_187225_a(ARROWS);
    }

    public int getMaxArrowsInInventory() {
        return 576;
    }

    public void func_82196_d(LivingEntity target, float distanceFactor) {
        ItemStack itemstack = DispenserGolem.findArrowsInInventory((IInventory)this.inventory);
        if (!itemstack.func_190926_b()) {
            AbstractArrowEntity arrow = ProjectileHelper.func_221272_a((LivingEntity)this, (ItemStack)itemstack, (float)distanceFactor);
            Vector3d myPos = this.func_213303_ch();
            arrow.func_70107_b(myPos.field_72450_a, myPos.field_72448_b + (double)(this.func_213302_cg() * 0.66666f), myPos.field_72449_c);
            double d0 = target.func_226277_ct_() - this.func_226277_ct_();
            double d1 = target.func_226283_e_(0.3333333333333333) - arrow.func_226278_cu_();
            double d2 = target.func_226281_cx_() - this.func_226281_cx_();
            double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
            arrow.func_212361_a((Entity)this);
            arrow.func_70239_b(this.arrowDamage + this.field_70146_Z.nextDouble() * 0.5);
            arrow.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
            arrow.func_70186_c(d0, d1 + d3 * 0.2, d2, 1.6f, 1.2f);
            this.func_184185_a(SoundEvents.field_187737_v, 1.0f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f);
            this.field_70170_p.func_217376_c((Entity)arrow);
            itemstack.func_190918_g(1);
            this.func_76316_a((IInventory)this.inventory);
        }
    }

    public void updateCombatTask() {
        this.updateCombatTask(!this.allowArrows);
    }

    public void updateCombatTask(boolean forceMelee) {
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            this.field_70714_bg.func_85156_a((Goal)this.aiMeleeAttack);
            this.field_70714_bg.func_85156_a((Goal)this.aiArrowAttack);
            if (forceMelee || this.getArrowsInInventory() == 0) {
                this.field_70714_bg.func_75776_a(0, (Goal)this.aiMeleeAttack);
            } else {
                this.field_70714_bg.func_75776_a(0, (Goal)this.aiArrowAttack);
            }
        }
    }

    public class FindArrowsGoal
    extends Goal {
        protected final double range;

        public FindArrowsGoal(double rangeIn) {
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE));
            this.range = rangeIn;
        }

        public boolean func_75250_a() {
            return DispenserGolem.this.allowArrows && DispenserGolem.this.getArrowsInInventory() < DispenserGolem.this.getMaxArrowsInInventory();
        }

        public boolean func_75253_b() {
            return false;
        }

        public void func_75246_d() {
            List droppedArrows = DispenserGolem.this.func_130014_f_().func_175647_a(ItemEntity.class, DispenserGolem.this.func_174813_aQ().func_186662_g(this.range), e -> !e.func_174874_s() && e.func_92059_d().func_77973_b() instanceof ArrowItem);
            if (!droppedArrows.isEmpty()) {
                droppedArrows.sort((e1, e2) -> (int)(DispenserGolem.this.func_70068_e((Entity)e1) - DispenserGolem.this.func_70068_e((Entity)e2)));
                DispenserGolem.this.func_70661_as().func_75497_a((Entity)droppedArrows.get(0), 1.2);
            }
        }

        public void func_75249_e() {
            this.func_75246_d();
        }
    }
}

