/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.GolemMultiTextured;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public final class WoodenGolem
extends GolemMultiTextured {
    public static final String[] WOOD_TYPES = new String[]{"oak", "spruce", "birch", "jungle", "acacia", "big_oak"};

    public WoodenGolem(EntityType<? extends GolemBase> entityType, World world) {
        super(entityType, world, "golems", WOOD_TYPES);
    }

    @Override
    public void onBuilt(BlockState body, BlockState legs, BlockState arm1, BlockState arm2) {
        int textureNum;
        Block b = body.func_177230_c();
        if (b.func_203417_a((ITag)BlockTags.field_203286_o)) {
            textureNum = 0;
        } else if (b.func_203417_a((ITag)BlockTags.field_203290_s)) {
            textureNum = 1;
        } else if (b.func_203417_a((ITag)BlockTags.field_203287_p)) {
            textureNum = 2;
        } else if (b.func_203417_a((ITag)BlockTags.field_203289_r)) {
            textureNum = 3;
        } else if (b.func_203417_a((ITag)BlockTags.field_203288_q)) {
            textureNum = 4;
        } else if (b.func_203417_a((ITag)BlockTags.field_203285_n)) {
            textureNum = 5;
        } else {
            this.randomizeTexture(this.field_70170_p, this.func_226270_aj_());
            return;
        }
        this.setTextureNum((byte)textureNum);
    }

    @Override
    public ItemStack getCreativeReturn(RayTraceResult target) {
        switch (this.getTextureNum()) {
            case 0: {
                return new ItemStack((IItemProvider)Blocks.field_196617_K);
            }
            case 1: {
                return new ItemStack((IItemProvider)Blocks.field_196618_L);
            }
            case 2: {
                return new ItemStack((IItemProvider)Blocks.field_196619_M);
            }
            case 3: {
                return new ItemStack((IItemProvider)Blocks.field_196620_N);
            }
            case 4: {
                return new ItemStack((IItemProvider)Blocks.field_196621_O);
            }
            case 5: {
                return new ItemStack((IItemProvider)Blocks.field_196623_P);
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void randomizeTexture(World world, BlockPos pos) {
        boolean useBiome = world.func_201674_k().nextBoolean();
        if (useBiome) {
            byte texture = 0;
            this.setTextureNum(texture);
        }
        super.randomizeTexture(world, pos);
    }

    @Override
    public Map<Block, Byte> getTextureBytes() {
        return new HashMap<Block, Byte>();
    }
}

