/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity.base;

import com.mcmoddev.golems.entity.ai.GoToWaterGoal;
import com.mcmoddev.golems.entity.ai.SwimUpGoal;
import com.mcmoddev.golems.entity.base.IMultiTexturedGolem;
import com.mcmoddev.golems.items.ItemBedrockGolem;
import com.mcmoddev.golems.main.ExtraGolems;
import com.mcmoddev.golems.main.ExtraGolemsEntities;
import com.mcmoddev.golems.util.config.ExtraGolemsConfig;
import com.mcmoddev.golems.util.config.GolemContainer;
import com.mcmoddev.golems.util.config.GolemRegistrar;
import com.mcmoddev.golems.util.config.special.GolemSpecialContainer;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.pathfinding.SwimmerPathNavigator;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeHooks;

public abstract class GolemBase
extends IronGolemEntity {
    protected static final DataParameter<Boolean> CHILD = EntityDataManager.func_187226_a(GolemBase.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final String KEY_CHILD = "isChild";
    private final GolemContainer container;
    protected final SwimmerPathNavigator waterNavigator;
    protected final GroundPathNavigator groundNavigator;
    protected boolean swimmingUp;

    public GolemBase(EntityType<? extends GolemBase> type, World world) {
        super(type, world);
        this.container = GolemRegistrar.getContainer(type);
        this.waterNavigator = new SwimmerPathNavigator((MobEntity)this, world);
        this.groundNavigator = new GroundPathNavigator((MobEntity)this, world);
        switch (this.container.getSwimMode()) {
            case FLOAT: {
                this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
                this.field_70699_by.func_212239_d(true);
                break;
            }
            case SWIM: {
                this.field_70138_W = 1.0f;
                this.field_70765_h = new SwimmingMovementController(this);
                this.func_184644_a(PathNodeType.WATER, 0.0f);
                this.field_70714_bg.func_75776_a(1, (Goal)new GoToWaterGoal(this, 14, 1.0));
                this.field_70714_bg.func_75776_a(2, (Goal)new SwimUpGoal(this, 1.0, this.field_70170_p.func_181545_F()));
                break;
            }
        }
    }

    public void onBuilt(BlockState body, BlockState legs, BlockState arm1, BlockState arm2) {
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(CHILD, (Object)false);
    }

    protected void func_184651_r() {
        super.func_184651_r();
    }

    public boolean canInteractChangeTexture() {
        return ExtraGolemsConfig.enableTextureInteract() && this instanceof IMultiTexturedGolem;
    }

    public boolean isProvidingLight() {
        return false;
    }

    public boolean isProvidingPower() {
        return false;
    }

    public GolemContainer getGolemContainer() {
        return this.container != null ? this.container : GolemRegistrar.getContainer(this.func_200600_R().getRegistryName());
    }

    public float getHealAmount(ItemStack i) {
        float amount = (float)((double)this.func_110138_aP() * this.getGolemContainer().getHealAmount(i.func_77973_b()));
        if (this.func_70631_g_()) {
            amount *= 1.75f;
        }
        return Math.min(amount, 32.0f);
    }

    public BlockPos getBlockBelow() {
        return this.func_226270_aj_();
    }

    public ForgeConfigSpec.ConfigValue getConfigValue(String name) {
        GolemSpecialContainer cont = this.getGolemContainer().getSpecialContainer(name);
        if (null != cont) {
            return ExtraGolemsConfig.GOLEM_CONFIG.specials.get((Object)cont).value;
        }
        ExtraGolems.LOGGER.error("Tried to access config value '" + name + "' in golem '" + this.getGolemContainer().getName() + "' but the config name wasn't registered!");
        return null;
    }

    public boolean getConfigBool(String name) {
        return (Boolean)this.getConfigValue(name).get();
    }

    public int getConfigInt(String name) {
        return (Integer)this.getConfigValue(name).get();
    }

    public double getConfigDouble(String name) {
        return (Double)this.getConfigValue(name).get();
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        if (!this.container.takesFallDamage()) {
            return false;
        }
        float[] ret = ForgeHooks.onLivingFall((LivingEntity)this, (float)distance, (float)damageMultiplier);
        if (ret == null) {
            return false;
        }
        distance = ret[0];
        damageMultiplier = ret[1];
        boolean flag = super.func_225503_b_(distance, damageMultiplier);
        int i = this.func_225508_e_(distance, damageMultiplier);
        if (i > 0) {
            this.func_184185_a(this.func_184588_d(i), 1.0f, 1.0f);
            this.func_226295_cZ_();
            this.func_70097_a(DamageSource.field_76379_h, i);
            return true;
        }
        return flag;
    }

    public boolean func_180427_aV() {
        return this.getGolemContainer().isImmuneToExplosions();
    }

    public boolean func_213358_a(EntityType<?> type) {
        if (type == EntityType.field_200729_aH && this.func_70850_q()) {
            return ExtraGolemsConfig.enableFriendlyFire();
        }
        if (type == EntityType.field_200756_av || type.getRegistryName().toString().contains("golem")) {
            return false;
        }
        return super.func_213358_a(type);
    }

    public ItemStack getPickedResult(RayTraceResult ray) {
        Block block = this.container.getPrimaryBuildingBlock();
        return block != null ? new ItemStack((IItemProvider)block) : ItemStack.field_190927_a;
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        float healAmount = this.getHealAmount(stack);
        if (ExtraGolemsConfig.enableHealGolems() && this.func_110143_aJ() < this.func_110138_aP() && healAmount > 0.0f) {
            this.func_70691_i(healAmount);
            if (!player.func_184812_l_()) {
                if (stack.func_190916_E() > 1) {
                    stack.func_190918_g(1);
                } else {
                    stack = stack.getContainerItem();
                }
                player.func_184611_a(hand, stack);
            }
            if (this.func_70638_az() == player) {
                this.func_70604_c(null);
                this.func_70624_b(null);
            }
            Vector3d pos = this.func_213303_ch();
            ItemBedrockGolem.spawnParticles(this.field_70170_p, pos.field_72450_a, pos.field_72448_b + (double)this.func_213302_cg() / 2.0, pos.field_72449_c, 0.15, (IParticleData)ParticleTypes.field_197590_A, 30);
            this.func_184185_a(SoundEvents.field_187845_fY, 0.85f, 1.1f + this.field_70146_Z.nextFloat() * 0.2f);
            return ActionResultType.CONSUME;
        }
        return super.func_230254_b_(player, hand);
    }

    public boolean func_70631_g_() {
        return (Boolean)this.func_184212_Q().func_187225_a(CHILD);
    }

    public void func_82227_f(boolean isChild) {
        if ((Boolean)this.func_184212_Q().func_187225_a(CHILD) != isChild) {
            this.func_184212_Q().func_187227_b(CHILD, (Object)isChild);
            this.func_213323_x_();
        }
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (CHILD.equals(key)) {
            if (this.func_70631_g_()) {
                double childHealth = Math.floor(this.getGolemContainer().getHealth() * 0.3 * 10.0) / 10.0;
                double childAttack = Math.floor(this.getGolemContainer().getAttack() * 0.6 * 10.0) / 10.0;
                this.func_110148_a(Attributes.field_233818_a_).func_111128_a(childHealth);
                this.func_110148_a(Attributes.field_233823_f_).func_111128_a(childAttack);
                this.func_110148_a(Attributes.field_233820_c_).func_111128_a(0.0);
            } else {
                this.func_110148_a(Attributes.field_233818_a_).func_111128_a(this.getGolemContainer().getHealth());
                this.func_110148_a(Attributes.field_233823_f_).func_111128_a(this.getGolemContainer().getAttack());
                this.func_110148_a(Attributes.field_233820_c_).func_111128_a(this.getGolemContainer().getKnockbackResist());
            }
            this.func_213323_x_();
        }
    }

    protected Collection<GolemBase> trySpawnChildren(int count) {
        ArrayList<GolemBase> children = new ArrayList<GolemBase>();
        if (!this.field_70170_p.field_72995_K && !this.func_70631_g_()) {
            for (int i = 0; i < count; ++i) {
                GolemBase child = (GolemBase)this.getGolemContainer().getEntityType().func_200721_a(this.field_70170_p);
                child.func_82227_f(true);
                if (this.func_70638_az() != null) {
                    child.func_70624_b(this.func_70638_az());
                }
                child.func_82149_j((Entity)this);
                this.func_130014_f_().func_217376_c((Entity)child);
                children.add(child);
            }
        }
        return children;
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.func_82227_f(tag.func_74767_n(KEY_CHILD));
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_74757_a(KEY_CHILD, this.func_70631_g_());
    }

    public ResourceLocation getTexture() {
        return this.getGolemContainer().getTexture();
    }

    protected static ResourceLocation makeTexture(String TEXTURE) {
        return ExtraGolemsEntities.makeTexture(TEXTURE);
    }

    protected static ResourceLocation makeTexture(String MODID, String TEXTURE) {
        return ExtraGolemsEntities.makeTexture(MODID, TEXTURE);
    }

    public boolean hasTransparency() {
        return false;
    }

    protected SoundEvent func_184639_G() {
        return this.getGolemSound();
    }

    protected SoundEvent func_184601_bQ(DamageSource ignored) {
        return this.getGolemSound() == SoundEvents.field_187569_bQ ? SoundEvents.field_187565_bO : this.getGolemSound();
    }

    protected SoundEvent func_184615_bR() {
        return this.getGolemSound() == SoundEvents.field_187569_bQ ? SoundEvents.field_187561_bM : this.getGolemSound();
    }

    public final SoundEvent getGolemSound() {
        return this.container.getSound();
    }

    public void func_213352_e(Vector3d vec) {
        if (this.func_70613_aW() && this.func_70090_H() && this.isSwimmingUp()) {
            this.func_213309_a(0.01f, vec);
            this.func_213315_a(MoverType.SELF, this.func_213322_ci());
            this.func_213317_d(this.func_213322_ci().func_186678_a(0.9));
        } else {
            super.func_213352_e(vec);
        }
    }

    public void func_205343_av() {
        if (this.container.getSwimMode() != GolemContainer.SwimMode.SWIM) {
            super.func_205343_av();
            return;
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70613_aW() && this.func_70090_H() && this.isSwimmingUp()) {
                this.field_70699_by = this.waterNavigator;
                this.func_204711_a(true);
            } else {
                this.field_70699_by = this.groundNavigator;
                this.func_204711_a(false);
            }
        }
    }

    protected float func_189749_co() {
        return this.container.getSwimMode() == GolemContainer.SwimMode.SWIM ? 0.88f : super.func_189749_co();
    }

    public boolean func_96092_aw() {
        return !this.func_203007_ba();
    }

    public void setSwimmingUp(boolean isSwimmingUp) {
        this.swimmingUp = isSwimmingUp && this.container.getSwimMode() == GolemContainer.SwimMode.SWIM;
    }

    public boolean isSwimmingUp() {
        if (this.container.getSwimMode() != GolemContainer.SwimMode.SWIM) {
            return false;
        }
        if (this.swimmingUp) {
            return true;
        }
        LivingEntity e = this.func_70638_az();
        return e != null && e.func_70090_H();
    }

    public static boolean isSwimmingUp(GolemBase golem) {
        return golem.swimmingUp;
    }

    public boolean shouldMoveToWater(Vector3d target) {
        return this.container.getSwimMode() == GolemContainer.SwimMode.SWIM;
    }

    static class SwimmingMovementController
    extends MovementController {
        private final GolemBase golem;

        public SwimmingMovementController(GolemBase golem) {
            super((MobEntity)golem);
            this.golem = golem;
        }

        public void func_75641_c() {
            Vector3d tPos;
            LivingEntity target = this.golem.func_70638_az();
            Vector3d gPos = this.golem.func_213303_ch();
            Vector3d vector3d = tPos = target != null ? target.func_213303_ch() : null;
            if (GolemBase.isSwimmingUp(this.golem) && this.golem.func_70090_H()) {
                if (target != null && tPos != null && (tPos.field_72448_b > gPos.field_72448_b || this.golem.isSwimmingUp())) {
                    this.golem.func_213317_d(this.golem.func_213322_ci().func_72441_c(0.0, 0.002, 0.0));
                }
                if (this.field_188491_h != MovementController.Action.MOVE_TO || this.golem.func_70661_as().func_75500_f()) {
                    this.golem.func_70659_e(0.0f);
                    return;
                }
                double x1 = this.field_75646_b - gPos.field_72450_a;
                double y1 = this.field_75647_c - gPos.field_72448_b;
                double z1 = this.field_75644_d - gPos.field_72449_c;
                double dis = MathHelper.func_76133_a((double)(x1 * x1 + y1 * y1 + z1 * z1));
                float f1 = (float)(MathHelper.func_181159_b((double)z1, (double)x1) * 57.2957763671875) - 90.0f;
                this.golem.field_70761_aq = this.golem.field_70177_z = this.func_75639_a(this.golem.field_70177_z, f1, 90.0f);
                float moveSpeed2 = MathHelper.func_219799_g((float)0.125f, (float)this.golem.func_70689_ay(), (float)((float)this.field_75645_e));
                this.golem.func_70659_e(moveSpeed2);
                this.golem.func_213317_d(this.golem.func_213322_ci().func_72441_c((double)moveSpeed2 * x1 * 0.005, (double)moveSpeed2 * (y1 /= dis) * 0.1, (double)moveSpeed2 * z1 * 0.005));
            } else {
                if (!this.golem.field_70122_E) {
                    this.golem.func_213317_d(this.golem.func_213322_ci().func_72441_c(0.0, -0.008, 0.0));
                }
                super.func_75641_c();
            }
        }
    }
}

