/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.entity.base;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.IMultiTexturedGolem;
import com.mcmoddev.golems.util.GolemTextureBytes;
import java.util.Map;
import net.minecraft.block.BlockState;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public abstract class GolemMultiTextured
extends GolemBase
implements IMultiTexturedGolem<ResourceLocation> {
    protected static final DataParameter<Byte> DATA_TEXTURE = EntityDataManager.func_187226_a(GolemMultiTextured.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final String KEY_TEXTURE = "GolemTextureData";
    public final ResourceLocation[] textures;
    public final ResourceLocation[] lootTables;

    public GolemMultiTextured(EntityType<? extends GolemBase> entityType, World world, String modid, String[] textureNames) {
        super(entityType, world);
        this.textures = new ResourceLocation[textureNames.length];
        this.lootTables = new ResourceLocation[textureNames.length];
        for (String s : textureNames) {
            this.textures[n] = GolemMultiTextured.makeTexture(modid, this.getGolemContainer().getName() + "/" + s);
            this.lootTables[n] = new ResourceLocation(modid, "entities/" + this.getGolemContainer().getName() + "/" + s);
        }
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(DATA_TEXTURE, (Object)0);
    }

    @Override
    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        if (!player.func_213453_ef() && this.canInteractChangeTexture()) {
            int incremented = (this.getTextureNum() + 1) % this.textures.length;
            this.setTextureNum((byte)incremented);
            player.func_184609_a(hand);
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    @Override
    public void onBuilt(BlockState body, BlockState legs, BlockState arm1, BlockState arm2) {
        Map map = this.getTextureBytes();
        if (map != null && !map.isEmpty()) {
            byte textureNum = GolemTextureBytes.getByBlock(map, body.func_177230_c());
            this.setTextureNum(textureNum);
        }
    }

    @Override
    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        if (DATA_TEXTURE.equals(key)) {
            this.setTextureNum((byte)this.getTextureNum());
        }
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74774_a(KEY_TEXTURE, (byte)this.getTextureNum());
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setTextureNum(nbt.func_74771_c(KEY_TEXTURE));
    }

    protected ResourceLocation func_184647_J() {
        return this.lootTables[this.getTextureNum() % this.lootTables.length];
    }

    @Override
    public ItemStack getPickedResult(RayTraceResult target) {
        return this.getCreativeReturn(target);
    }

    @Override
    public void setTextureNum(byte toSet) {
        if (toSet != (Byte)this.func_184212_Q().func_187225_a(DATA_TEXTURE)) {
            this.func_184212_Q().func_187227_b(DATA_TEXTURE, (Object)toSet);
        }
    }

    @Override
    public int getTextureNum() {
        return ((Byte)this.func_184212_Q().func_187225_a(DATA_TEXTURE)).byteValue();
    }

    @Override
    public int getNumTextures() {
        return this.textures != null ? Integer.valueOf(this.textures.length) : null;
    }

    public ResourceLocation[] getTextureArray() {
        return this.textures;
    }

    public ResourceLocation getTextureFromArray(int index) {
        return this.getTextureArray()[index % this.textures.length];
    }

    @Override
    public ResourceLocation getTexture() {
        return this.getTextureFromArray(this.getTextureNum());
    }
}

