/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.events.handlers;

import com.mcmoddev.golems.blocks.BlockGolemHead;
import com.mcmoddev.golems.entity.FurnaceGolem;
import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.entity.base.IMultiTexturedGolem;
import com.mcmoddev.golems.main.ExtraGolems;
import com.mcmoddev.golems.util.config.ExtraGolemsConfig;
import com.mcmoddev.golems.util.config.GolemContainer;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.brain.memory.MemoryModuleType;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GolemCommonEventHandler {
    @SubscribeEvent
    public void onPlacePumpkin(BlockEvent.EntityPlaceEvent event) {
        if (!event.isCanceled() && ExtraGolemsConfig.pumpkinBuildsGolems() && event.getPlacedBlock().func_177230_c() == Blocks.field_196625_cS && event.getWorld() instanceof World) {
            BlockGolemHead.trySpawnGolem((World)event.getWorld(), event.getPos());
        }
    }

    @SubscribeEvent
    public void onTargetEvent(LivingSetAttackTargetEvent event) {
        if (event.getEntityLiving() instanceof MobEntity && event.getTarget() instanceof FurnaceGolem && !((FurnaceGolem)event.getTarget()).hasFuel()) {
            ((MobEntity)event.getEntityLiving()).func_70624_b(null);
            ((MobEntity)event.getEntityLiving()).func_70604_c(null);
        }
    }

    @SubscribeEvent
    public void onLivingUpdate(LivingEvent.LivingUpdateEvent event) {
        VillagerEntity villager;
        VillagerData villagerdata;
        if (ExtraGolemsConfig.villagerSummonChance() > 0 && event.getEntityLiving() instanceof VillagerEntity && event.getEntityLiving().func_70613_aW() && !event.getEntityLiving().func_70608_bn() && event.getEntityLiving().field_70173_aa % 50 == 0 && (villagerdata = (villager = (VillagerEntity)event.getEntityLiving()).func_213700_eh()) != null && !villager.func_70631_g_() && villagerdata.func_221130_b() != VillagerProfession.field_221162_l) {
            long time = villager.func_130014_f_().func_82737_E();
            int minNumVillagers = 3;
            AxisAlignedBB aabb = villager.func_174813_aQ().func_186662_g(10.0);
            List nearbyVillagers = villager.func_130014_f_().func_175647_a(VillagerEntity.class, aabb, v -> v.func_223350_a(time) && v.func_70089_S());
            List nearbyGolems = villager.func_130014_f_().func_217357_a(IronGolemEntity.class, aabb.func_186662_g(10.0));
            if (nearbyVillagers.size() >= 3 && nearbyGolems.isEmpty()) {
                GolemBase golem;
                if (villager.func_70681_au().nextInt(100) < ExtraGolemsConfig.villagerSummonChance() && (golem = GolemCommonEventHandler.summonGolem(villager)) != null) {
                    ExtraGolems.LOGGER.info("Villager summoned a golem! " + golem.toString());
                }
                nearbyVillagers.forEach(v -> v.func_213375_cj().func_218205_a(MemoryModuleType.field_223542_x, (Object)time));
            }
        }
    }

    @Nullable
    private static GolemBase summonGolem(@Nonnull VillagerEntity villager) {
        World world = villager.func_130014_f_();
        BlockPos blockpos = villager.func_233580_cy_();
        for (int i = 0; i < 10; ++i) {
            BlockPos blockpos2;
            EntityType<? extends GolemBase> type;
            GolemBase golem;
            double d0 = world.field_73012_v.nextInt(16) - 8;
            double d1 = world.field_73012_v.nextInt(16) - 8;
            double d2 = 6.0;
            for (int j = 0; j >= -12; --j) {
                BlockPos blockpos1 = blockpos.func_177963_a(d0, d2 + (double)j, d1);
                if (!world.func_175623_d(blockpos1) && !world.func_180495_p(blockpos1).func_185904_a().func_76224_d() || !world.func_180495_p(blockpos1.func_177977_b()).func_185904_a().func_76218_k()) continue;
                d2 += (double)j;
                break;
            }
            GolemBase golemBase = golem = (type = GolemCommonEventHandler.getGolemToSpawn(world, blockpos2 = blockpos.func_177963_a(d0, d2, d1))) != null ? (GolemBase)type.func_220349_b(world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, blockpos2, SpawnReason.MOB_SUMMONED, false, false) : null;
            if (golem == null) continue;
            if (golem instanceof IMultiTexturedGolem) {
                ((IMultiTexturedGolem)((Object)golem)).randomizeTexture(world, blockpos2);
            }
            if (golem.func_213380_a((IWorld)world, SpawnReason.MOB_SUMMONED) && golem.func_205019_a((IWorldReader)world)) {
                world.func_217376_c((Entity)golem);
                return golem;
            }
            golem.func_70106_y();
        }
        return null;
    }

    @Nullable
    private static EntityType<? extends GolemBase> getGolemToSpawn(World world, BlockPos pos) {
        List<GolemContainer> options = ExtraGolemsConfig.getVillagerGolems();
        GolemContainer choice = options.isEmpty() ? null : options.get(world.func_201674_k().nextInt(options.size()));
        return choice != null ? choice.getEntityType() : null;
    }
}

