/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.gui;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.util.config.GolemContainer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class GolemBookEntry {
    private final Block[] buildingBlocks;
    private final String golemName;
    private ResourceLocation imageLoc = null;
    private final int health;
    private final float attack;
    private final List<IFormattableTextComponent> specials = new ArrayList<IFormattableTextComponent>();

    public GolemBookEntry(@Nonnull GolemContainer container) {
        EntityType<? extends GolemBase> golemType = container.getEntityType();
        this.golemName = golemType.func_210760_d();
        this.health = (int)container.getHealth();
        this.attack = (float)container.getAttack();
        container.addDescription(this.specials);
        this.buildingBlocks = container.getBuildingBlocks().toArray(new Block[0]);
        String modid = container.getRegistryName().func_110624_b();
        String name = container.getRegistryName().func_110623_a();
        String img = (modid + ":textures/gui/screenshots/").concat(name).concat(".png");
        try {
            this.imageLoc = Minecraft.func_71410_x().func_195551_G().func_199002_a(new ResourceLocation(img)).func_199029_a();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public IFormattableTextComponent getGolemName() {
        return GolemBookEntry.trans(this.golemName, new Object[0]);
    }

    public String getGolemNameRaw() {
        return this.golemName;
    }

    public boolean hasBlocks() {
        return this.buildingBlocks != null && this.buildingBlocks.length > 0;
    }

    public Block getBlock(int index) {
        return this.hasBlocks() ? this.buildingBlocks[index % this.buildingBlocks.length] : Blocks.field_150350_a;
    }

    public Block[] getBlocks() {
        return this.buildingBlocks;
    }

    public String getBlockName(Block b) {
        return GolemBookEntry.trans(b.func_149739_a(), new Object[0]).getString();
    }

    public float getAttack() {
        return this.attack;
    }

    public int getDescriptionSize() {
        return this.specials.size();
    }

    public IFormattableTextComponent getDescriptionPage() {
        return this.makePage();
    }

    public boolean hasImage() {
        return this.imageLoc != null;
    }

    @Nullable
    public ResourceLocation getImageResource() {
        return this.imageLoc;
    }

    private IFormattableTextComponent makePage() {
        StringTextComponent page = new StringTextComponent("");
        page.func_240702_b_("\n").func_230529_a_((ITextComponent)GolemBookEntry.trans("entitytip.health", new Object[0]).func_240702_b_(": ").func_240699_a_(TextFormatting.GRAY)).func_230529_a_((ITextComponent)GolemBookEntry.wrap(String.valueOf(this.health)).func_240699_a_(TextFormatting.BLACK)).func_230529_a_((ITextComponent)GolemBookEntry.wrap(" \u2764").func_240699_a_(TextFormatting.DARK_RED));
        page.func_240702_b_("\n").func_230529_a_((ITextComponent)GolemBookEntry.trans("entitytip.attack", new Object[0]).func_240702_b_(": ").func_240699_a_(TextFormatting.GRAY)).func_230529_a_((ITextComponent)GolemBookEntry.wrap(String.valueOf(this.attack)).func_240699_a_(TextFormatting.BLACK)).func_240702_b_(" \u2764").func_240702_b_("\n");
        for (ITextComponent iTextComponent : this.specials) {
            page.func_240702_b_("\n").func_230529_a_(iTextComponent);
        }
        return page;
    }

    protected static IFormattableTextComponent trans(String s, Object ... strings) {
        return new TranslationTextComponent(s, strings);
    }

    protected static IFormattableTextComponent wrap(String s) {
        return new StringTextComponent(s);
    }
}

