/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.gui;

import com.mcmoddev.golems.gui.GolemBookEntry;
import com.mcmoddev.golems.main.GolemItems;
import com.mcmoddev.golems.util.config.GolemContainer;
import com.mcmoddev.golems.util.config.GolemRegistrar;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiGolemBook
extends Screen {
    protected static final ResourceLocation TEXTURE = new ResourceLocation("golems", "textures/gui/info_book.png");
    protected static final ResourceLocation CONTENTS = new ResourceLocation("golems", "textures/gui/info_book_contents.png");
    protected static final int BOOK_HEIGHT = 164;
    protected static final int BOOK_WIDTH = 256;
    protected static final int ICON_SP = 5;
    protected static final int SCR_OFFSET_Y = 16;
    protected static final int ARROW_WIDTH = 18;
    protected static final int ARROW_HEIGHT = 15;
    protected static final int SUPP_WIDTH = 100;
    protected static final int SUPP_HEIGHT = 50;
    private BlockButton buttonBlockLeft;
    private BlockButton buttonBlockRight;
    private NextPageButton buttonNextPage;
    private NextPageButton buttonPreviousPage;
    private GolemEntryButton[] tableOfContents;
    protected int curPage;
    protected int totalPages;
    private static final List<GolemBookEntry> GOLEMS = new ArrayList<GolemBookEntry>();
    private static final List<GolemBookEntry> ALPHABETICAL = new ArrayList<GolemBookEntry>();
    private static final float GOLEM_BLOCK_SCALE = 1.6f;
    private static final int MARGIN = 12;
    private static final int NUM_PAGES_INTRO = 6;
    private static final int NUM_CONTENTS_ENTRIES = 5;
    protected static final int CONTENTS_W = 106;
    protected static final int CONTENTS_H = 110;
    protected static final int SCROLL_STARTX = 12;
    protected static final int SCROLL_STARTY = 24;
    protected static final int SCROLL_W = 12;
    protected static final int SCROLL_H = 15;
    protected static final int ENTRY_W = 88;
    protected static final int ENTRY_H = 22;
    private float currentScroll;
    private boolean isScrolling;
    protected long ticksOpen;
    private static final ItemStack[] ingredientsSpell = new ItemStack[]{new ItemStack((IItemProvider)Items.field_151121_aF), new ItemStack((IItemProvider)Items.field_151008_G), new ItemStack((IItemProvider)Items.field_151137_ax), new ItemStack((IItemProvider)Items.field_196136_br)};
    private static final ItemStack outputSpell = new ItemStack((IItemProvider)GolemItems.GOLEM_SPELL, 3);
    private static final ItemStack[] ingredientsHead = new ItemStack[]{new ItemStack((IItemProvider)Blocks.field_196625_cS), new ItemStack((IItemProvider)GolemItems.GOLEM_SPELL)};
    private static final ItemStack outputHead = new ItemStack((IItemProvider)GolemItems.GOLEM_HEAD);

    public GuiGolemBook(PlayerEntity playerIn, ItemStack itemIn) {
        super((ITextComponent)new TranslationTextComponent("item.golems.info_book"));
        if (GOLEMS.isEmpty()) {
            GuiGolemBook.initGolemBookEntries();
        }
        this.curPage = 0;
        this.totalPages = 6 + GOLEMS.size();
        this.currentScroll = 0.0f;
        this.isScrolling = false;
        this.tableOfContents = new GolemEntryButton[5];
        this.ticksOpen = 0L;
    }

    private static final void initGolemBookEntries() {
        GOLEMS.clear();
        for (GolemContainer container : GolemRegistrar.getContainers()) {
            if (!container.isEnabled()) continue;
            GOLEMS.add(new GolemBookEntry(container));
        }
        Collections.sort(GOLEMS, (g1, g2) -> Float.compare(g1.getAttack(), g2.getAttack()));
        ALPHABETICAL.clear();
        ALPHABETICAL.addAll(GOLEMS);
        Collections.sort(ALPHABETICAL, (g1, g2) -> g1.getGolemName().getString().compareTo(g2.getGolemName().getString()));
    }

    public void func_231160_c_() {
        int doneW = 98;
        int doneH = 20;
        int doneX = (this.field_230708_k_ - doneW) / 2;
        int doneY = 188;
        this.func_230480_a_((Widget)new Button(doneX, doneY, doneW, doneH, (ITextComponent)new TranslationTextComponent("gui.done"), c -> this.field_230706_i_.func_147108_a(null)));
        int arrowX = (this.field_230708_k_ - 256) / 2;
        int arrowY = 158;
        this.buttonPreviousPage = (NextPageButton)this.func_230480_a_((Widget)new NextPageButton(this, arrowX + 18, arrowY, false));
        this.buttonNextPage = (NextPageButton)this.func_230480_a_((Widget)new NextPageButton(this, arrowX + 256 - 36, arrowY, true));
        int blockX = (this.field_230708_k_ - 256) / 2 + 12 + 4;
        int blockY = 28;
        this.buttonBlockLeft = (BlockButton)this.func_230480_a_((Widget)new BlockButton(this, new Block[0], blockX, blockY, 1.6f));
        blockX = this.field_230708_k_ / 2 + 12;
        this.buttonBlockRight = (BlockButton)this.func_230480_a_((Widget)new BlockButton(this, new Block[0], blockX, blockY, 1.6f));
        for (int i = 0; i < 5; ++i) {
            this.tableOfContents[i] = (GolemEntryButton)this.func_230480_a_((Widget)new GolemEntryButton(this, ALPHABETICAL.get(i), this.field_230708_k_ / 2 + 12, 40 + 22 * i));
        }
        this.updateButtons();
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        ++this.ticksOpen;
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        int bookX = (this.field_230708_k_ - 256) / 2;
        int bookY = 16;
        this.func_238474_b_(matrix, bookX, bookY, 0, 0, 256, 164);
        this.drawPageAt(matrix, bookX + 1, bookY, this.curPage, partialTicks);
        this.drawPageAt(matrix, bookX + 128 - 2, bookY, this.curPage + 1, partialTicks);
        super.func_230430_a_(matrix, mouseX, mouseY, partialTicks);
        if (GuiGolemBook.isPageGolemEntry(this.curPage, this.totalPages) && this.buttonBlockLeft.func_230449_g_()) {
            this.buttonBlockLeft.drawHoveringText(matrix, mouseX, mouseY);
        }
        if (GuiGolemBook.isPageGolemEntry(this.curPage + 1, this.totalPages) && this.buttonBlockRight.func_230449_g_()) {
            this.buttonBlockRight.drawHoveringText(matrix, mouseX, mouseY);
        }
    }

    private void drawPageAt(MatrixStack matrix, int cornerX, int cornerY, int pageNum, float partialTicks) {
        this.drawPageNum(matrix, cornerX, cornerY, pageNum + 1);
        switch (pageNum) {
            case 0: {
                IFormattableTextComponent title = GuiGolemBook.trans("item.golems.info_book", new Object[0]);
                IFormattableTextComponent body = GuiGolemBook.trans("golembook.intro1", new Object[0]).func_240702_b_("\n").func_230529_a_((ITextComponent)GuiGolemBook.trans("golembook.intro2", new Object[0]));
                this.drawBasicPage(matrix, cornerX, cornerY, title, body);
                return;
            }
            case 1: {
                IFormattableTextComponent title = GuiGolemBook.trans("golembook.contents.title", new Object[0]);
                this.drawTableOfContents(matrix, cornerX, cornerY, title);
                return;
            }
            case 2: {
                IFormattableTextComponent title = GuiGolemBook.trans("item.golems.golem_paper", new Object[0]);
                IFormattableTextComponent body = GuiGolemBook.wrap("\n\n\n\n").func_230529_a_((ITextComponent)GuiGolemBook.trans("golembook.recipe_spell.recipe", title, GuiGolemBook.trans("item.minecraft.paper", new Object[0]), GuiGolemBook.trans("item.minecraft.feather", new Object[0]), GuiGolemBook.trans("item.minecraft.ink_sac", new Object[0]), GuiGolemBook.trans("item.minecraft.redstone", new Object[0])));
                this.drawBasicPage(matrix, cornerX, cornerY, title, body);
                this.draw2x2Grid(matrix, cornerX + 24, cornerY + 24, ingredientsSpell, outputSpell);
                return;
            }
            case 3: {
                IFormattableTextComponent title = GuiGolemBook.trans("block.golems.golem_head", new Object[0]);
                IFormattableTextComponent body = GuiGolemBook.wrap("\n\n\n\n").func_230529_a_((ITextComponent)GuiGolemBook.trans("golembook.recipe_head.recipe", title, GuiGolemBook.trans("item.golems.golem_paper", new Object[0]), GuiGolemBook.trans("block.minecraft.pumpkin", new Object[0])));
                this.drawBasicPage(matrix, cornerX, cornerY, title, body);
                this.draw2x2Grid(matrix, cornerX + 24, cornerY + 24, ingredientsHead, outputHead);
                return;
            }
            case 4: {
                IFormattableTextComponent title = GuiGolemBook.trans("golembook.build_golem.title", new Object[0]);
                IFormattableTextComponent body = GuiGolemBook.trans("golembook.build_golem.howto1", new Object[0]).func_240702_b_(" ").func_230529_a_((ITextComponent)GuiGolemBook.trans("golembook.build_golem.howto2", new Object[0])).func_240702_b_("\n\n").func_230529_a_((ITextComponent)GuiGolemBook.trans("golembook.build_golem.howto3", GuiGolemBook.trans("block.golems.golem_head", new Object[0])));
                this.drawBasicPage(matrix, cornerX, cornerY, title, body);
                return;
            }
            case 5: {
                this.drawGolemDiagram(matrix, cornerX, cornerY);
                return;
            }
        }
        if (GuiGolemBook.isPageGolemEntry(pageNum, this.totalPages)) {
            GolemBookEntry entry = GuiGolemBook.getGolemEntryForPage(pageNum);
            this.drawGolemEntry(matrix, cornerX, cornerY, entry, partialTicks);
        }
    }

    private void drawPageNum(MatrixStack matrix, int cornerX, int cornerY, int pageNum) {
        boolean isLeft = pageNum % 2 == 1;
        int numX = isLeft ? this.field_230708_k_ / 2 - 12 : this.field_230708_k_ / 2 + 12;
        int numY = cornerY + 164 - 22;
        String pageNumLeft = String.valueOf(pageNum);
        int sWidth = isLeft ? this.field_230712_o_.func_78256_a(pageNumLeft) : 0;
        this.field_230712_o_.func_238421_b_(matrix, pageNumLeft, (float)(numX - sWidth), (float)numY, 0);
    }

    protected void drawBlock(Block blockIn, int cornerX, int cornerY, float scale) {
        Block block = blockIn != Blocks.field_150350_a ? blockIn : Blocks.field_180401_cv;
        float blockX = cornerX + 12 + 4;
        float blockY = cornerY + 12;
        RenderSystem.pushMatrix();
        RenderSystem.enableRescaleNormal();
        RenderHelper.func_227780_a_();
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        this.field_230707_j_.func_175042_a(new ItemStack((IItemProvider)block), (int)(blockX / scale), (int)(blockY / scale));
        RenderSystem.popMatrix();
    }

    private void drawGolemEntry(MatrixStack matrix, int cornerX, int cornerY, GolemBookEntry entry, float partialTicks) {
        int nameX = cornerX + 48;
        int nameY = cornerY + 12;
        IFormattableTextComponent golemName = entry.getGolemName();
        this.field_230712_o_.func_238418_a_((ITextProperties)golemName, nameX, nameY, 68, 0);
        int statsX = cornerX + 12;
        int statsY = nameY + 24;
        IFormattableTextComponent stats = entry.getDescriptionPage();
        this.field_230712_o_.func_238418_a_((ITextProperties)stats, statsX, statsY, 104, 0);
        if (entry.hasImage()) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float scale = 0.9f;
            int imgX = cornerX + 64 - (int)(100.0f * scale / 2.0f);
            int imgY = cornerY + 164 - (int)(50.0f * scale) - 24;
            this.getMinecraft().func_110434_K().func_110577_a(entry.getImageResource());
            int w = (int)(100.0f * scale);
            int h = (int)(50.0f * scale);
            GuiGolemBook.func_238463_a_((MatrixStack)matrix, (int)imgX, (int)imgY, (float)0.0f, (float)0.0f, (int)w, (int)h, (int)w, (int)h);
        }
    }

    private void drawBasicPage(MatrixStack matrix, int cornerX, int cornerY, IFormattableTextComponent title, IFormattableTextComponent body) {
        int maxWidth = 104;
        int titleX = cornerX + 12 + 4;
        int titleY = cornerY + 12;
        int sWidth = this.field_230712_o_.func_78256_a(title.getString());
        if (sWidth > 104) {
            this.field_230712_o_.func_238418_a_((ITextProperties)title, titleX, titleY, 104, 0);
        } else {
            this.field_230712_o_.func_238421_b_(matrix, title.getString(), (float)(titleX + (104 - sWidth) / 2), (float)titleY, 0);
        }
        int bodyX = titleX;
        int bodyY = titleY + 24;
        this.field_230712_o_.func_238418_a_((ITextProperties)body, bodyX, bodyY, 104, 0);
    }

    private void drawTableOfContents(MatrixStack matrix, int cornerX, int cornerY, IFormattableTextComponent title) {
        this.drawBasicPage(matrix, cornerX, cornerY, title, GuiGolemBook.wrap(""));
        this.getMinecraft().func_110434_K().func_110577_a(CONTENTS);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int startX = cornerX + 12 + 1;
        int startY = cornerY + 24 - 1;
        this.func_238474_b_(matrix, startX, startY, 0, 0, 106, 112);
        startX = GuiGolemBook.getScrollX(this.field_230708_k_) - 2;
        startY = GuiGolemBook.getScrollY(this.currentScroll);
        this.func_238474_b_(matrix, startX, startY, this.isScrolling ? 17 : 0, 115, 12, 15);
        if (this.isScrolling) {
            GolemBookEntry[] visibleArray = GuiGolemBook.getGolemEntriesForScroll(this.currentScroll);
            int l = this.tableOfContents.length;
            for (int i = 0; i < l; ++i) {
                this.tableOfContents[i].setEntry(visibleArray[i]);
            }
        }
    }

    private void draw2x2Grid(MatrixStack matrix, int startX, int startY, ItemStack[] ingredients, ItemStack result) {
        float posY;
        float posX;
        int frameWidth = 3;
        float scale = 1.0f;
        int gridW = 84;
        int gridH = 46;
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(matrix, startX, startY, 172, 169, 84, 46);
        RenderSystem.enableRescaleNormal();
        RenderHelper.func_227780_a_();
        int iconW = 15;
        switch (ingredients.length) {
            case 4: {
                posX = (float)(startX + iconW) + 9.0f;
                posY = (float)(startY + iconW) + 9.0f;
                this.field_230707_j_.func_175042_a(ingredients[3], (int)(posX / 1.0f), (int)(posY / 1.0f));
            }
            case 3: {
                posX = (float)startX + 6.0f;
                posY = (float)(startY + iconW) + 9.0f;
                this.field_230707_j_.func_175042_a(ingredients[2], (int)(posX / 1.0f), (int)(posY / 1.0f));
            }
            case 2: {
                posX = (float)(startX + iconW) + 9.0f;
                posY = (float)startY + 6.0f;
                this.field_230707_j_.func_175042_a(ingredients[1], (int)(posX / 1.0f), (int)(posY / 1.0f));
            }
            case 1: {
                posX = (float)startX + 6.0f;
                posY = (float)startY + 6.0f;
                this.field_230707_j_.func_175042_a(ingredients[0], (int)(posX / 1.0f), (int)(posY / 1.0f));
            }
        }
        posX = (float)(startX + 84) - 16.0f - 6.0f;
        posY = (float)startY + 16.0f;
        this.field_230707_j_.func_175042_a(result, (int)(posX / 1.0f), (int)(posY / 1.0f));
        RenderSystem.popMatrix();
    }

    private void drawGolemDiagram(MatrixStack matrix, int cornerX, int cornerY) {
        Block golemBody = Blocks.field_150339_S;
        Block golemHead = GolemItems.GOLEM_HEAD;
        float scale = 2.0f;
        int blockW = (int)(8.0f * scale);
        int startX = cornerX + 32;
        int startY = cornerY + blockW;
        this.drawBlock(golemHead, startX, startY, scale);
        this.drawBlock(golemBody, startX, startY += blockW * 4, scale);
        this.drawBlock(golemBody, startX += blockW * 2, startY -= blockW * 5 / 2, scale);
        this.drawBlock(golemBody, startX -= blockW * 2, startY += blockW / 2, scale);
        this.drawBlock(golemBody, startX -= blockW * 2, startY += blockW / 2, scale);
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int state, double lastBtnClicked, double timeSinceClick) {
        if (GuiGolemBook.isPageTableContents(this.curPage)) {
            int mouseYCentered = (int)(mouseY - 7.5);
            if (GuiGolemBook.isMouseOverScroll((int)mouseX, mouseYCentered, this.field_230708_k_)) {
                this.isScrolling = true;
                if (mouseYCentered < 150 && mouseYCentered >= 40) {
                    this.currentScroll = GuiGolemBook.getScrollFloat((int)(mouseY - 7.5));
                }
            } else {
                this.isScrolling = false;
            }
        }
        return super.func_231045_a_(mouseX, mouseY, state, lastBtnClicked, timeSinceClick);
    }

    public boolean func_231043_a_(double d1, double d2, double d3) {
        this.currentScroll = GuiGolemBook.getScrollFloat(GuiGolemBook.getScrollY(this.currentScroll + (float)d3));
        return super.func_231043_a_(d1, d2, d3);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int state) {
        this.isScrolling = false;
        return super.func_231048_c_(mouseX, mouseY, state);
    }

    private void updateButtons() {
        this.buttonPreviousPage.field_230694_p_ = this.curPage > 0;
        this.buttonNextPage.field_230694_p_ = this.curPage + 2 < this.totalPages;
        boolean tableContentsVisible = GuiGolemBook.isPageTableContents(this.curPage);
        for (GolemEntryButton b : this.tableOfContents) {
            b.field_230694_p_ = tableContentsVisible;
        }
        if (GuiGolemBook.isPageGolemEntry(this.curPage, this.totalPages)) {
            this.buttonBlockLeft.field_230694_p_ = true;
            this.buttonBlockLeft.updateBlocks(GuiGolemBook.getGolemEntryForPage(this.curPage).getBlocks());
        } else {
            this.buttonBlockLeft.field_230694_p_ = false;
        }
        if (GuiGolemBook.isPageGolemEntry(this.curPage + 1, this.totalPages)) {
            this.buttonBlockRight.field_230694_p_ = true;
            this.buttonBlockRight.updateBlocks(GuiGolemBook.getGolemEntryForPage(this.curPage + 1).getBlocks());
        } else {
            this.buttonBlockRight.field_230694_p_ = false;
        }
    }

    private static boolean isMouseOverScroll(int mouseX, int mouseY, int width) {
        int scrollStartX = GuiGolemBook.getScrollX(width);
        int scrollStartY = 40;
        return mouseX >= scrollStartX && mouseY >= scrollStartY && mouseX < scrollStartX + 12 && mouseY < scrollStartY + 110 - 7;
    }

    private static int getScrollX(int screenWidth) {
        return screenWidth / 2 + 12 + 106 - 12;
    }

    private static int getScrollY(float scroll) {
        float f = Math.max(0.0f, Math.min(1.0f, scroll));
        return 40 + (int)(f * 95.0f);
    }

    private static float getScrollFloat(int currentY) {
        int minY = 40;
        int maxY = 135;
        float f = Math.max(40, Math.min(135, currentY)) - 40;
        return f / 95.0f;
    }

    private static boolean isPageGolemEntry(int page, int totalPages) {
        return page >= 6 && page < totalPages;
    }

    private static boolean isPageTableContents(int page) {
        return page >= 0 && page < 2;
    }

    private static GolemBookEntry getGolemEntryForPage(int page) {
        return GOLEMS.get(page - 6);
    }

    private static GolemBookEntry[] getGolemEntriesForScroll(float scrollIn) {
        float scroll = MathHelper.func_76131_a((float)scrollIn, (float)0.0f, (float)1.0f);
        int i = (int)(scroll * (float)(ALPHABETICAL.size() - 5));
        return ALPHABETICAL.subList(i, i + 5).toArray(new GolemBookEntry[5]);
    }

    protected static IFormattableTextComponent trans(String s, Object ... strings) {
        return new TranslationTextComponent(s, strings);
    }

    protected static IFormattableTextComponent wrap(String s) {
        return new StringTextComponent(s);
    }

    protected static class NextPageButton
    extends Button {
        protected static final int TEXTURE_STARTY = 169;
        private final GuiGolemBook gui;
        private final boolean isForward;

        public NextPageButton(GuiGolemBook guiBook, int x, int y, boolean isForwardIn) {
            super(x, y, 18, 15, (ITextComponent)GuiGolemBook.wrap(""), b -> {});
            this.gui = guiBook;
            this.isForward = isForwardIn;
        }

        public void func_230982_a_(double mouseX, double mouseY) {
            this.gui.curPage = this.isForward ? (this.gui.curPage += 2) : (this.gui.curPage -= 2);
            this.gui.updateButtons();
        }

        public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            if (this.field_230694_p_) {
                boolean mouseOver = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
                int tx = 0;
                int ty = 169;
                if (mouseOver) {
                    tx += 23;
                }
                if (!this.isForward) {
                    ty += 15;
                }
                this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, tx, ty, 18, 15);
            }
        }
    }

    protected static class GolemEntryButton
    extends Button {
        private final GuiGolemBook gui;
        private GolemBookEntry entry;

        public GolemEntryButton(GuiGolemBook guiIn, GolemBookEntry entryIn, int x, int y) {
            super(x, y, 88, 22, (ITextComponent)GuiGolemBook.wrap(""), b -> {});
            this.gui = guiIn;
            this.entry = entryIn;
        }

        public void setEntry(GolemBookEntry toSet) {
            this.entry = toSet;
        }

        public void func_230982_a_(double mouseX, double mouseY) {
            int index = GOLEMS.indexOf(this.entry);
            if (index >= 0 && index <= GOLEMS.size()) {
                int page = index + 6;
                this.gui.curPage = page = Math.floorDiv(page, 2) * 2;
            }
            this.gui.updateButtons();
        }

        public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            if (this.field_230694_p_) {
                this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
                Minecraft.func_71410_x().func_110434_K().func_110577_a(CONTENTS);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.func_238474_b_(matrix, this.field_230690_l_, this.field_230691_m_, 111, this.field_230692_n_ ? 27 : 0, 88, 22);
                int index = (int)(this.gui.ticksOpen / 30L);
                this.gui.drawBlock(this.entry.getBlock(index), this.field_230690_l_ - 12 - 2, this.field_230691_m_ - 9, 1.0f);
                RenderSystem.pushMatrix();
                IFormattableTextComponent name = this.entry.getGolemName();
                int wrap = this.field_230688_j_ - 20;
                float scale = 1.0f;
                int nameH = this.gui.field_230712_o_.func_78267_b(name.getString(), wrap);
                if (nameH > this.field_230689_k_) {
                    scale = 0.7f;
                    nameH = (int)(scale * (float)this.gui.field_230712_o_.func_78267_b(name.getString(), (int)((float)wrap / scale)));
                }
                int nameX = this.field_230690_l_ + 20;
                int nameY = this.field_230691_m_ + (this.field_230689_k_ - nameH) / 2 + 1;
                RenderSystem.scalef((float)scale, (float)scale, (float)scale);
                this.gui.field_230712_o_.func_238418_a_((ITextProperties)name, (int)((float)nameX / scale), (int)((float)nameY / scale), (int)((float)wrap / scale), 0);
                RenderSystem.popMatrix();
            }
        }
    }

    protected static class BlockButton
    extends Button {
        private float scale;
        private Block[] blocks;
        private Block currentBlock;
        private final GuiGolemBook gui;

        public BlockButton(GuiGolemBook guiIn, Block[] blockValues, int x, int y, float scaleIn) {
            super(x, y, (int)(scaleIn * 16.0f), (int)(scaleIn * 16.0f), (ITextComponent)new StringTextComponent(""), b -> {});
            this.gui = guiIn;
            this.blocks = blockValues;
            this.scale = scaleIn;
        }

        public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partialTicks) {
            if (this.field_230694_p_) {
                boolean bl = this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
                if (this.blocks != null && this.blocks.length > 0) {
                    int index = (int)(this.gui.ticksOpen / 30L) % this.blocks.length;
                    this.currentBlock = this.blocks[index];
                } else {
                    this.currentBlock = Blocks.field_150350_a;
                }
                this.gui.drawBlock(this.currentBlock, this.field_230690_l_ - 12 - 4, this.field_230691_m_ - 12, this.scale);
            }
        }

        public void updateBlocks(Block[] blocksToDraw) {
            this.blocks = blocksToDraw;
        }

        public boolean drawHoveringText(MatrixStack matrix, int mouseX, int mouseY) {
            if (this.currentBlock != Blocks.field_150350_a) {
                this.gui.func_238652_a_(matrix, (ITextProperties)new TranslationTextComponent(this.currentBlock.func_149739_a()), mouseX, mouseY);
                return true;
            }
            return false;
        }
    }
}

