/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.renders;

import com.mcmoddev.golems.entity.base.GolemColorized;
import com.mcmoddev.golems.renders.GolemModel;
import com.mcmoddev.golems.renders.GolemRenderer;
import com.mcmoddev.golems.util.config.ExtraGolemsConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRendererManager;

public class ColoredGolemRenderer
extends GolemRenderer<GolemColorized> {
    public ColoredGolemRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn);
    }

    @Override
    public void render(GolemColorized golem, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        float colorRed = golem.getColorRed();
        float colorGreen = golem.getColorGreen();
        float colorBlue = golem.getColorBlue();
        float colorAlpha = golem.getColorAlpha();
        if (golem.hasBase()) {
            ((GolemModel)this.field_77045_g).resetColor();
            this.texture = golem.getTextureBase();
            this.isAlphaLayer = false;
            super.render(golem, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
        matrixStackIn.func_227860_a_();
        ((GolemModel)this.field_77045_g).setColor(colorRed, colorGreen, colorBlue, colorAlpha);
        this.isAlphaLayer = this.isAlphaLayer(golem);
        if (this.isAlphaLayer) {
            RenderSystem.enableAlphaTest();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableBlend();
        }
        if (golem.hasOverlay()) {
            this.texture = ExtraGolemsConfig.halloween() && this.isNightTime(golem) ? boneTexture : golem.getTextureToColor();
            super.render(golem, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
        if (this.isAlphaLayer) {
            RenderSystem.disableAlphaTest();
            RenderSystem.disableBlend();
        }
        matrixStackIn.func_227865_b_();
    }

    @Override
    public void bindGolemTexture(GolemColorized golem) {
    }

    @Override
    protected void resetColor() {
    }
}

