/*
 * Decompiled with CFR 0.152.
 */
package com.mcmoddev.golems.renders;

import com.mcmoddev.golems.entity.base.GolemBase;
import com.mcmoddev.golems.main.ExtraGolemsEntities;
import com.mcmoddev.golems.renders.GolemFlowerLayer;
import com.mcmoddev.golems.renders.GolemModel;
import com.mcmoddev.golems.util.config.ExtraGolemsConfig;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class GolemRenderer<T extends GolemBase>
extends MobRenderer<T, GolemModel<T>> {
    protected static final ResourceLocation fallbackTexture = ExtraGolemsEntities.makeTexture("golem_clay");
    protected static final ResourceLocation boneTexture = ExtraGolemsEntities.makeTexture("golem_bone_skeleton");
    protected static final ResourceLocation specialTexture = ExtraGolemsEntities.makeTexture("special");
    protected static final ResourceLocation specialTexture2 = ExtraGolemsEntities.makeTexture("special2");
    protected ResourceLocation texture;
    protected static final String damageTexture = "minecraft:textures/entity/iron_golem/iron_golem_crackiness";
    protected static final ResourceLocation[] damageIndicators = new ResourceLocation[]{new ResourceLocation("minecraft:textures/entity/iron_golem/iron_golem_crackiness_low.png"), new ResourceLocation("minecraft:textures/entity/iron_golem/iron_golem_crackiness_medium.png"), new ResourceLocation("minecraft:textures/entity/iron_golem/iron_golem_crackiness_high.png")};
    protected static final float DAMAGE_ALPHA = 0.55f;
    protected boolean isAlphaLayer;

    public GolemRenderer(EntityRendererManager renderManagerIn) {
        super(renderManagerIn, new GolemModel(), 0.5f);
        this.func_177094_a(new GolemFlowerLayer(this));
    }

    public void render(T golem, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        this.bindGolemTexture(golem);
        this.resetColor();
        this.isAlphaLayer = this.isAlphaLayer(golem);
        super.func_225623_a_(golem, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        this.isAlphaLayer = true;
        this.renderDamage(golem, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
    }

    protected void bindGolemTexture(T golem) {
        this.texture = ((GolemBase)((Object)golem)).getTexture();
        if (ExtraGolemsConfig.halloween() && this.isNightTime(golem)) {
            this.texture = boneTexture;
        } else if (golem.func_145818_k_()) {
            String s = TextFormatting.func_110646_a((String)golem.func_200200_C_().getString());
            if ("Ganondorf".equals(s)) {
                this.texture = specialTexture;
            }
            if ("Cookie".equals(s)) {
                this.texture = specialTexture2;
            }
        }
    }

    protected void resetColor() {
        ((GolemModel)this.field_77045_g).resetColor();
    }

    protected boolean isAlphaLayer(T golem) {
        return ((GolemBase)((Object)golem)).hasTransparency();
    }

    protected void renderDamage(T golem, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        int index = Math.min(this.getDamageTexture(golem), damageIndicators.length - 1);
        if (index > -1) {
            matrixStackIn.func_227860_a_();
            RenderSystem.enableAlphaTest();
            RenderSystem.defaultAlphaFunc();
            RenderSystem.enableBlend();
            ((GolemModel)this.field_77045_g).setAlpha(0.55f);
            this.texture = damageIndicators[index];
            super.func_225623_a_(golem, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            RenderSystem.disableAlphaTest();
            RenderSystem.disableBlend();
            matrixStackIn.func_227865_b_();
        }
    }

    public ResourceLocation getEntityTexture(T golem) {
        return this.texture != null ? this.texture : fallbackTexture;
    }

    @Nullable
    protected RenderType func_230496_a_(T golem, boolean isVisible, boolean isVisibleToPlayer, boolean isGlowing) {
        ResourceLocation tex = this.getEntityTexture(golem);
        if (isVisible || isVisibleToPlayer || ((GolemBase)((Object)golem)).hasTransparency() || this.isAlphaLayer) {
            return RenderType.func_228644_e_((ResourceLocation)tex);
        }
        return golem.func_225510_bt_() ? RenderType.func_228654_j_((ResourceLocation)tex) : RenderType.func_228638_b_((ResourceLocation)tex);
    }

    protected int getDamageTexture(T golem) {
        float percentHealth = golem.func_110143_aJ() / golem.func_110138_aP();
        return damageIndicators.length - (int)Math.ceil(percentHealth * 4.0f);
    }

    protected boolean isNightTime(T golem) {
        long time = ((GolemBase)((Object)golem)).field_70170_p.func_72820_D() % 24000L;
        return time > 13000L && time < 23000L;
    }
}

